/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordIterator;

public class RenamingNameSuggestor {
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_SUFFIX = 3;
    private static final String PLURAL_S = "s";
    private static final String PLURAL_IES = "ies";
    private static final String SINGULAR_Y = "y";
    private int fStrategy;
    private String[] fFieldPrefixes;
    private String[] fFieldSuffixes;
    private String[] fStaticFieldPrefixes;
    private String[] fStaticFieldSuffixes;
    private String[] fLocalPrefixes;
    private String[] fLocalSuffixes;
    private String[] fArgumentPrefixes;
    private String[] fArgumentSuffixes;
    private boolean fExtendedInterfaceNameMatching;
    private boolean fExtendedAllUpperCaseHunkMatching;
    private boolean fExtendedPluralMatching;

    public RenamingNameSuggestor() {
        this(3);
    }

    public RenamingNameSuggestor(int n) {
        Assert.isTrue((n >= 1 && n <= 3 ? 1 : 0) != 0);
        this.fStrategy = n;
        this.fExtendedInterfaceNameMatching = true;
        this.fExtendedAllUpperCaseHunkMatching = true;
        this.fExtendedPluralMatching = true;
        this.resetPrefixes();
    }

    public String suggestNewFieldName(IJavaProject iJavaProject, String string, boolean bl, String string2, String string3) {
        this.initializePrefixesAndSuffixes(iJavaProject);
        if (bl) {
            return this.suggestNewVariableName(this.fStaticFieldPrefixes, this.fStaticFieldSuffixes, string, string2, string3);
        }
        return this.suggestNewVariableName(this.fFieldPrefixes, this.fFieldSuffixes, string, string2, string3);
    }

    public String suggestNewLocalName(IJavaProject iJavaProject, String string, boolean bl, String string2, String string3) {
        this.initializePrefixesAndSuffixes(iJavaProject);
        if (bl) {
            return this.suggestNewVariableName(this.fArgumentPrefixes, this.fArgumentSuffixes, string, string2, string3);
        }
        return this.suggestNewVariableName(this.fLocalPrefixes, this.fLocalSuffixes, string, string2, string3);
    }

    public String suggestNewMethodName(String string, String string2, String string3) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)string3);
        Assert.isTrue((string.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((string2.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((string3.length() > 0 ? 1 : 0) != 0);
        this.resetPrefixes();
        return this.match(string2, string3, string);
    }

    public String suggestNewVariableName(String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)stringArray2);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)string3);
        Assert.isTrue((string.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((string2.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((string3.length() > 0 ? 1 : 0) != 0);
        String string4 = this.findLongestPrefix(string, stringArray);
        String string5 = this.findLongestSuffix(string, stringArray2);
        String string6 = string.substring(string4.length(), string.length() - string5.length());
        String string7 = this.match(string2, string3, string6);
        return string7 != null ? String.valueOf(string4) + string7 + string5 : null;
    }

    private String match(String string, String string2, String string3) {
        String string4 = string;
        String string5 = string2;
        if (this.fExtendedInterfaceNameMatching && this.isInterfaceName(string4) && this.isInterfaceName(string5)) {
            string4 = this.getInterfaceName(string4);
            string5 = this.getInterfaceName(string5);
        }
        String string6 = this.matchDirect(string4, string5, string3);
        if (this.fExtendedPluralMatching && string6 == null && this.canPluralize(string4)) {
            string6 = this.matchDirect(this.pluralize(string4), this.pluralize(string5), string3);
        }
        return string6;
    }

    private String matchDirect(String string, String string2, String string3) {
        String string4 = this.exactMatch(string, string2, string3);
        if (string4 == null && this.fStrategy >= 2) {
            string4 = this.embeddedMatch(string, string2, string3);
        }
        if (string4 == null && this.fStrategy >= 3) {
            string4 = this.suffixMatch(string, string2, string3);
        }
        return string4;
    }

    private String exactMatch(String string, String string2, String string3) {
        String string4 = this.exactDirectMatch(string, string2, string3);
        if (string4 != null) {
            return string4;
        }
        if (this.fExtendedAllUpperCaseHunkMatching && this.isUpperCaseCamelCaseHunk(string)) {
            String string5 = this.getFirstUpperRestLowerCased(string);
            String string6 = this.isUpperCaseCamelCaseHunk(string2) ? this.getFirstUpperRestLowerCased(string2) : string2;
            string4 = this.exactDirectMatch(string5, string6, string3);
        }
        return string4;
    }

    private String exactDirectMatch(String string, String string2, String string3) {
        if (string3.equals(string)) {
            return string2;
        }
        if (string3.equals(this.getLowerCased(string))) {
            return this.getLowerCased(string2);
        }
        return null;
    }

    private String embeddedMatch(String string, String string2, String string3) {
        String string4 = string3.toLowerCase();
        String string5 = string.toLowerCase();
        int n = string4.indexOf(string5);
        while (n != -1) {
            String string6;
            String string7 = string3.substring(n, n + string.length());
            String string8 = string3.substring(0, n);
            String string9 = string3.substring(n + string.length());
            if (this.startsNewHunk(string9) && (string6 = this.exactMatch(string, string2, string7)) != null) {
                return String.valueOf(string8) + string6 + string9;
            }
            n = string4.indexOf(string5, n + 1);
        }
        return null;
    }

    private String suffixMatch(String string, String string2, String string3) {
        String string4;
        String[] stringArray;
        String[] stringArray2 = this.getSuffixes(string);
        String[] stringArray3 = this.getSuffixes(string2);
        String[] stringArray4 = this.getSuffixes(string3);
        int n = Math.min(stringArray2.length, stringArray3.length);
        String[] stringArray5 = new String[n];
        String[] stringArray6 = new String[n];
        System.arraycopy(stringArray2, stringArray2.length - n, stringArray5, 0, n);
        System.arraycopy(stringArray3, stringArray3.length - n, stringArray6, 0, n);
        int n2 = -1;
        int n3 = stringArray4.length - 1;
        while (n3 >= 0) {
            String string5 = this.exactMatch(stringArray5[stringArray5.length - 1], stringArray6[stringArray6.length - 1], stringArray4[n3]);
            if (string5 != null) {
                n2 = n3;
                break;
            }
            --n3;
        }
        if (n2 == -1) {
            return null;
        }
        n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = stringArray5.length - 1;
        while (n6 >= 0) {
            n5 = n2 - n3;
            ++n3;
            if (n5 < 0 || (stringArray = this.exactMatch(stringArray5[n6], stringArray6[n6], stringArray4[n5])) == null) break;
            stringArray4[n5] = stringArray;
            n4 = n6--;
        }
        if (n4 == 0 && (n6 = stringArray3.length - stringArray6.length) > 0) {
            if (Character.isLowerCase(stringArray4[n5].charAt(0)) && Character.isUpperCase(stringArray5[n4].charAt(0))) {
                stringArray4[n5] = this.getUpperCased(stringArray4[n5]);
                stringArray3[0] = this.getLowerCased(stringArray3[0]);
            }
            stringArray = new String[stringArray4.length + n6];
            System.arraycopy(stringArray4, 0, stringArray, 0, n5);
            System.arraycopy(stringArray3, 0, stringArray, n5, n6);
            System.arraycopy(stringArray4, n5, stringArray, n5 + n6, stringArray4.length - n5);
            stringArray4 = stringArray;
        }
        if ((string4 = this.concat(stringArray4)).equals(string3)) {
            return null;
        }
        return string4;
    }

    private boolean startsNewHunk(String string) {
        if (string.length() == 0) {
            return true;
        }
        return this.isLegalChar(string.charAt(0));
    }

    private boolean isUpperCaseCamelCaseHunk(String string) {
        if (string.length() < 2) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!this.isLegalChar(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isLegalChar(char c) {
        if (Character.isLetter(c)) {
            return Character.isUpperCase(c);
        }
        return true;
    }

    private String[] getSuffixes(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaWordIterator javaWordIterator = new JavaWordIterator();
        javaWordIterator.setText(string);
        int n2 = 0;
        while ((n = javaWordIterator.next()) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n;
        }
        return arrayList.toArray(new String[0]);
    }

    private String concat(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getLowerCased(String string) {
        if (string.length() > 1) {
            return String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
        }
        return string.toLowerCase();
    }

    private String getUpperCased(String string) {
        if (string.length() > 1) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
        }
        return string.toLowerCase();
    }

    private String getFirstUpperRestLowerCased(String string) {
        if (string.length() > 1) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1).toLowerCase();
        }
        return string.toLowerCase();
    }

    private boolean isInterfaceName(String string) {
        return string.length() >= 2 && string.charAt(0) == 'I' && Character.isUpperCase(string.charAt(1));
    }

    private String getInterfaceName(String string) {
        return string.substring(1);
    }

    private String findLongestPrefix(String string, String[] stringArray) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.startsWith(stringArray[n2]) && stringArray[n2].length() > n) {
                n = stringArray[n2].length();
                string2 = stringArray[n2];
            }
            ++n2;
        }
        return string2;
    }

    private String findLongestSuffix(String string, String[] stringArray) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.endsWith(stringArray[n2]) && stringArray[n2].length() > n) {
                n = stringArray[n2].length();
                string2 = stringArray[n2];
            }
            ++n2;
        }
        return string2;
    }

    private boolean canPluralize(String string) {
        return !string.endsWith(PLURAL_S);
    }

    private String pluralize(String string) {
        if (string.endsWith(SINGULAR_Y)) {
            string = string.substring(0, string.length() - 1).concat(PLURAL_IES);
        } else if (!string.endsWith(PLURAL_S)) {
            string = string.concat(PLURAL_S);
        }
        return string;
    }

    private void resetPrefixes() {
        String[] stringArray = new String[]{};
        this.fFieldPrefixes = stringArray;
        this.fFieldSuffixes = stringArray;
        this.fStaticFieldPrefixes = stringArray;
        this.fStaticFieldSuffixes = stringArray;
        this.fLocalPrefixes = stringArray;
        this.fLocalSuffixes = stringArray;
        this.fArgumentPrefixes = stringArray;
        this.fArgumentSuffixes = stringArray;
    }

    private void initializePrefixesAndSuffixes(IJavaProject iJavaProject) {
        this.fFieldPrefixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        this.fFieldSuffixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        this.fStaticFieldPrefixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.staticFieldPrefixes");
        this.fStaticFieldSuffixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.staticFieldSuffixes");
        this.fLocalPrefixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.localPrefixes");
        this.fLocalSuffixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.localSuffixes");
        this.fArgumentPrefixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.argumentPrefixes");
        this.fArgumentSuffixes = this.readCommaSeparatedPreference(iJavaProject, "org.eclipse.wst.jsdt.core.codeComplete.argumentSuffixes");
    }

    private String[] readCommaSeparatedPreference(IJavaProject iJavaProject, String string) {
        String string2 = iJavaProject.getOption(string, true);
        return string2 == null ? new String[]{} : string2.split(",");
    }
}

