/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

public class ASTNodeDeleteUtil {
    private static ASTNode[] getNodesToDelete(IJavaElement iJavaElement, CompilationUnit compilationUnit) throws JavaModelException {
        if (iJavaElement.getElementType() == 8) {
            if (JdtFlags.isEnum((IMember)((IField)iJavaElement))) {
                return new ASTNode[]{ASTNodeSearchUtil.getEnumConstantDeclaration((IField)iJavaElement, compilationUnit)};
            }
            return new ASTNode[]{ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)iJavaElement, compilationUnit)};
        }
        if (iJavaElement.getElementType() == 7 && ((IType)iJavaElement).isLocal()) {
            IType iType = (IType)iJavaElement;
            if (iType.isAnonymous()) {
                ASTNode aSTNode;
                ISourceRange iSourceRange;
                if (iType.getParent().getElementType() == 8 && (iSourceRange = iType.getSourceRange()) != null && (aSTNode = ASTNodeSearchUtil.getAstNode(compilationUnit, iSourceRange.getOffset(), iSourceRange.getLength())) instanceof AnonymousClassDeclaration) {
                    return new ASTNode[]{aSTNode};
                }
                return new ASTNode[]{ASTNodeSearchUtil.getClassInstanceCreationNode(iType, compilationUnit)};
            }
            ASTNode[] aSTNodeArray = ASTNodeSearchUtil.getDeclarationNodes(iJavaElement, compilationUnit);
            aSTNodeArray[0] = aSTNodeArray[0].getParent();
            return aSTNodeArray;
        }
        return ASTNodeSearchUtil.getDeclarationNodes(iJavaElement, compilationUnit);
    }

    private static Set getRemovedNodes(final List list, CompilationUnitRewrite compilationUnitRewrite) {
        final HashSet hashSet = new HashSet();
        compilationUnitRewrite.getRoot().accept((ASTVisitor)new GenericVisitor(true){

            protected boolean visitNode(ASTNode aSTNode) {
                if (list.contains(aSTNode)) {
                    hashSet.add(aSTNode);
                }
                return true;
            }
        });
        return hashSet;
    }

    public static void markAsDeleted(IJavaElement[] iJavaElementArray, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < iJavaElementArray.length) {
            ASTNodeDeleteUtil.markAsDeleted(arrayList, iJavaElementArray[n], compilationUnitRewrite, textEditGroup);
            ++n;
        }
        ASTNodeDeleteUtil.propagateFieldDeclarationNodeDeletions(arrayList, compilationUnitRewrite, textEditGroup);
    }

    private static void markAsDeleted(List list, IJavaElement iJavaElement, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) throws JavaModelException {
        ASTNode[] aSTNodeArray = ASTNodeDeleteUtil.getNodesToDelete(iJavaElement, compilationUnitRewrite.getRoot());
        int n = 0;
        while (n < aSTNodeArray.length) {
            ASTNode aSTNode = aSTNodeArray[n];
            if (aSTNode != null) {
                list.add(aSTNode);
                compilationUnitRewrite.getASTRewrite().remove(aSTNode, textEditGroup);
                compilationUnitRewrite.getImportRemover().registerRemovedNode(aSTNode);
            }
            ++n;
        }
    }

    private static void propagateFieldDeclarationNodeDeletions(List list, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        Set set = ASTNodeDeleteUtil.getRemovedNodes(list, compilationUnitRewrite);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            if (!(aSTNode instanceof VariableDeclarationFragment) || !(aSTNode.getParent() instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode.getParent();
            if (!list.contains(fieldDeclaration) && set.containsAll(fieldDeclaration.fragments())) {
                compilationUnitRewrite.getASTRewrite().remove((ASTNode)fieldDeclaration, textEditGroup);
            }
            compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)fieldDeclaration);
        }
    }

    private ASTNodeDeleteUtil() {
    }
}

