/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;

public final class LoggedNewNameQueries
implements INewNameQueries {
    private final ReorgExecutionLog fLog;

    public LoggedNewNameQueries(ReorgExecutionLog reorgExecutionLog) {
        this.fLog = reorgExecutionLog;
    }

    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit iCompilationUnit, String string) {
        return new NewNameQuery(iCompilationUnit, string);
    }

    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot iPackageFragmentRoot, String string) {
        return new NewNameQuery(iPackageFragmentRoot, string);
    }

    public INewNameQuery createNewPackageNameQuery(IPackageFragment iPackageFragment, String string) {
        return new NewNameQuery(iPackageFragment, string);
    }

    public INewNameQuery createNewResourceNameQuery(IResource iResource, String string) {
        return new NewNameQuery(iResource, string);
    }

    public INewNameQuery createNullQuery() {
        return new NullNewNameQuery();
    }

    public INewNameQuery createStaticQuery(final String string) {
        return new INewNameQuery(){

            public String getNewName() {
                return string;
            }
        };
    }

    private final class NewNameQuery
    implements INewNameQuery {
        private final String fName;
        private final Object fObject;

        public NewNameQuery(Object object, String string) {
            this.fObject = object;
            this.fName = string;
        }

        private String getCompilationUnitName() {
            int n;
            String string = LoggedNewNameQueries.this.fLog.getNewName(this.fObject);
            if (string != null && (n = string.lastIndexOf(46)) > 0) {
                string = string.substring(0, n);
            }
            return string;
        }

        public String getNewName() {
            String string = null;
            string = this.fObject instanceof ICompilationUnit ? this.getCompilationUnitName() : LoggedNewNameQueries.this.fLog.getNewName(this.fObject);
            if (string == null) {
                string = this.fName;
            }
            return this.fName;
        }
    }

    private static final class NullNewNameQuery
    implements INewNameQuery {
        private NullNewNameQuery() {
        }

        public String getNewName() {
            return "null";
        }
    }
}

