/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.Message;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class SelfEncapsulateFieldRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_GETTER = "getter";
    private static final String ATTRIBUTE_SETTER = "setter";
    private static final String ATTRIBUTE_INSERTION = "insertion";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_DECLARING = "declaring";
    private IField fField;
    private TextChangeManager fChangeManager = new TextChangeManager();
    private CompilationUnit fRoot;
    private VariableDeclarationFragment fFieldDeclaration;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private int fVisibility = -1;
    private String fGetterName;
    private String fSetterName;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass = true;
    private boolean fGenerateJavadoc;
    private List fUsedReadNames;
    private List fUsedModifyNames;
    private boolean fConsiderVisibility = true;
    private static final String NO_NAME = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SelfEncapsulateFieldRefactoring(IField iField) throws JavaModelException {
        this.fField = iField;
        if (iField != null) {
            this.initialize(iField);
        }
    }

    private void initialize(IField iField) throws JavaModelException {
        this.fGetterName = GetterSetterUtil.getGetterName(iField, null);
        this.fSetterName = GetterSetterUtil.getSetterName(iField, null);
        this.fArgName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)iField.getJavaProject(), (String)iField.getElementName(), (int)iField.getFlags());
        this.checkArgName();
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String string) {
        this.fGetterName = string;
        Assert.isNotNull((Object)this.fGetterName);
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String string) {
        this.fSetterName = string;
        Assert.isNotNull((Object)this.fSetterName);
    }

    public void setInsertionIndex(int n) {
        this.fInsertionIndex = n;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int n) {
        this.fVisibility = n;
    }

    public void setEncapsulateDeclaringClass(boolean bl) {
        this.fEncapsulateDeclaringClass = bl;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    public void setGenerateJavadoc(boolean bl) {
        this.fGenerateJavadoc = bl;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fVisibility < 0) {
            this.fVisibility = this.fField.getFlags() & 7;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(Checks.checkAvailability((IJavaElement)this.fField));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.fRoot = new RefactoringASTParser(3).parse((ITypeRoot)this.fField.getCompilationUnit(), true, iProgressMonitor);
        ISourceRange iSourceRange = this.fField.getNameRange();
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fRoot, iSourceRange.getOffset(), iSourceRange.getLength());
        if (aSTNode == null) {
            return this.mappingErrorFound(refactoringStatus, aSTNode);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFieldDeclaration = (VariableDeclarationFragment)ASTNodes.getParent(aSTNode, clazz);
        if (this.fFieldDeclaration == null) {
            return this.mappingErrorFound(refactoringStatus, aSTNode);
        }
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(refactoringStatus, aSTNode)) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.SelfEncapsulateField_type_not_resolveable);
            }
            return refactoringStatus;
        }
        this.computeUsedNames();
        this.fRewriter = ASTRewrite.create((AST)this.fRoot.getAST());
        return refactoringStatus;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus refactoringStatus, ASTNode aSTNode) {
        if (aSTNode != null && (aSTNode.getFlags() & 1) != 0 && this.processCompilerError(refactoringStatus, aSTNode)) {
            return refactoringStatus;
        }
        refactoringStatus.addFatalError(this.getMappingErrorMessage());
        return refactoringStatus;
    }

    private boolean processCompilerError(RefactoringStatus refactoringStatus, ASTNode aSTNode) {
        Message[] messageArray = ASTNodes.getMessages(aSTNode, 2);
        if (messageArray.length == 0) {
            return false;
        }
        refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_field, new String[]{this.fField.getElementName(), messageArray[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return Messages.format(RefactoringCoreMessages.SelfEncapsulateField_cannot_analyze_selected_field, new String[]{this.fField.getElementName()});
    }

    public RefactoringStatus checkMethodNames() {
        return this.checkMethodNames(this.isUsingLocalGetter(), this.isUsingLocalSetter());
    }

    public RefactoringStatus checkMethodNames(boolean bl, boolean bl2) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IType iType = this.fField.getDeclaringType();
        SelfEncapsulateFieldRefactoring.checkName(refactoringStatus, this.fGetterName, this.fUsedReadNames, iType, bl, this.fField);
        SelfEncapsulateFieldRefactoring.checkName(refactoringStatus, this.fSetterName, this.fUsedModifyNames, iType, bl2, this.fField);
        return refactoringStatus;
    }

    private static void checkName(RefactoringStatus refactoringStatus, String string, List list, IType iType, boolean bl, IField iField) {
        if (NO_NAME.equals(string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.Checks_Choose_name);
            return;
        }
        boolean bl2 = false;
        try {
            bl2 = Flags.isStatic((int)iField.getFlags());
        }
        catch (JavaModelException javaModelException) {}
        refactoringStatus.merge(Checks.checkMethodName(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMethodBinding iMethodBinding = (IMethodBinding)iterator.next();
            String string2 = iMethodBinding.getName();
            if (!string2.equals(string)) continue;
            if (!bl) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_method_exists, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), iType.getElementName()}));
                continue;
            }
            boolean bl3 = Modifier.isStatic((int)iMethodBinding.getModifiers());
            if (bl3 && !bl2) {
                refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_static_method_but_nonstatic_field, new String[]{iMethodBinding.getName(), iField.getElementName()}));
            }
            if (!bl3 && bl2) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nonstatic_method_but_static_field, new String[]{iMethodBinding.getName(), iField.getElementName()}));
            }
            return;
        }
        if (bl) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_methoddoesnotexist_status_fatalError, new String[]{string, iType.getElementName()}));
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fChangeManager.clear();
        iProgressMonitor.beginTask(NO_NAME, 12);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_checking_preconditions);
        boolean bl = this.isUsingLocalGetter();
        boolean bl2 = this.isUsingLocalSetter();
        refactoringStatus.merge(this.checkMethodNames(bl, bl2));
        iProgressMonitor.worked(1);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        iProgressMonitor.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_searching_for_cunits);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 5);
        ICompilationUnit[] iCompilationUnitArray = RefactoringSearchEngine.findAffectedCompilationUnits(SearchPattern.createPattern((IJavaElement)this.fField, (int)2), RefactoringScopeFactory.create((IJavaElement)this.fField, this.fConsiderVisibility), (IProgressMonitor)subProgressMonitor, refactoringStatus, true);
        this.checkInHierarchy(refactoringStatus, bl, bl2);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        iProgressMonitor.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_analyzing);
        SubProgressMonitor subProgressMonitor2 = new SubProgressMonitor(iProgressMonitor, 5);
        subProgressMonitor2.beginTask(NO_NAME, iCompilationUnitArray.length);
        IVariableBinding iVariableBinding = this.fFieldDeclaration.resolveBinding();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITypeBinding iTypeBinding = ((AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding();
        ArrayList arrayList = new ArrayList();
        ICompilationUnit iCompilationUnit = this.fField.getCompilationUnit();
        this.fImportRewrite = StubUtility.createImportRewrite(this.fRoot, true);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            ArrayList arrayList2;
            ImportRewrite importRewrite;
            ICompilationUnit iCompilationUnit2 = iCompilationUnitArray[n];
            subProgressMonitor2.subTask(iCompilationUnit2.getElementName());
            CompilationUnit compilationUnit = null;
            ASTRewrite aSTRewrite = null;
            if (iCompilationUnit.equals(iCompilationUnit2)) {
                compilationUnit = this.fRoot;
                aSTRewrite = this.fRewriter;
                importRewrite = this.fImportRewrite;
                arrayList2 = arrayList;
            } else {
                compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit2, true);
                aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
                arrayList2 = new ArrayList();
                importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
            }
            this.checkCompileErrors(refactoringStatus, compilationUnit, iCompilationUnit2);
            AccessAnalyzer accessAnalyzer = new AccessAnalyzer(this, iCompilationUnit2, iVariableBinding, iTypeBinding, aSTRewrite, importRewrite);
            compilationUnit.accept((ASTVisitor)accessAnalyzer);
            refactoringStatus.merge(accessAnalyzer.getStatus());
            if (!this.fSetterMustReturnValue) {
                this.fSetterMustReturnValue = accessAnalyzer.getSetterMustReturnValue();
            }
            if (refactoringStatus.hasFatalError()) {
                this.fChangeManager.clear();
                return refactoringStatus;
            }
            arrayList2.addAll(accessAnalyzer.getGroupDescriptions());
            if (!iCompilationUnit.equals(iCompilationUnit2)) {
                this.createEdits(iCompilationUnit2, aSTRewrite, arrayList2, importRewrite);
            }
            subProgressMonitor2.worked(1);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n;
        }
        arrayList.addAll(this.addGetterSetterChanges(this.fRoot, this.fRewriter, iCompilationUnit.findRecommendedLineSeparator(), bl2, bl));
        this.createEdits(iCompilationUnit, this.fRewriter, arrayList, this.fImportRewrite);
        subProgressMonitor2.done();
        IFile[] iFileArray = ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
        refactoringStatus.merge(Checks.validateModifiesFiles(iFileArray, this.getValidationContext()));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        ResourceChangeChecker.checkFilesToBeChanged((IFile[])iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return refactoringStatus;
    }

    private void createEdits(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, List list, ImportRewrite importRewrite) throws CoreException {
        TextChange textChange = this.fChangeManager.get(iCompilationUnit);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        textChange.setEdit((TextEdit)multiTextEdit);
        multiTextEdit.addChild(importRewrite.rewriteImports(null));
        multiTextEdit.addChild(aSTRewrite.rewriteAST());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            textChange.addTextEditGroup((TextEditGroup)iterator.next());
        }
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fField.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        int n = 589830;
        IType iType = this.fField.getDeclaringType();
        try {
            if (iType.isAnonymous() || iType.isLocal()) {
                n |= 0x40000;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        String string2 = Messages.format(RefactoringCoreMessages.SelfEncapsulateField_descriptor_description_short, this.fField.getElementName());
        String string3 = Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_getter_pattern, this.fGetterName));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_setter_pattern, this.fSetterName));
        String string4 = JdtFlags.getVisibilityString(this.fVisibility);
        if (NO_NAME.equals(string4)) {
            string4 = RefactoringCoreMessages.SelfEncapsulateField_default_visibility;
        }
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_visibility_pattern, string4));
        if (this.fEncapsulateDeclaringClass) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_use_accessors);
        } else {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_do_not_use_accessors);
        }
        if (this.fGenerateJavadoc) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.SelfEncapsulateField_generate_comments);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.self.encapsulate", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fField));
        hashMap.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        hashMap.put(ATTRIBUTE_INSERTION, new Integer(this.fInsertionIndex).toString());
        hashMap.put(ATTRIBUTE_SETTER, this.fSetterName);
        hashMap.put(ATTRIBUTE_GETTER, this.fGetterName);
        hashMap.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fGenerateJavadoc).toString());
        hashMap.put(ATTRIBUTE_DECLARING, Boolean.valueOf(this.fEncapsulateDeclaringClass).toString());
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, this.getName());
        TextChange[] textChangeArray = this.fChangeManager.getAllChanges();
        iProgressMonitor.beginTask(NO_NAME, textChangeArray.length);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.SelfEncapsulateField_create_changes);
        int n2 = 0;
        while (n2 < textChangeArray.length) {
            dynamicValidationRefactoringChange.add((Change)textChangeArray[n2]);
            iProgressMonitor.worked(1);
            ++n2;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    public String getName() {
        return RefactoringCoreMessages.SelfEncapsulateField_name;
    }

    private void checkCompileErrors(RefactoringStatus refactoringStatus, CompilationUnit compilationUnit, ICompilationUnit iCompilationUnit) {
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n];
            if (!this.isIgnorableProblem(iProblem)) {
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.SelfEncapsulateField_compiler_errors_update, iCompilationUnit.getElementName()), JavaStatusContext.create((ITypeRoot)iCompilationUnit));
                return;
            }
            ++n;
        }
    }

    private void checkInHierarchy(RefactoringStatus refactoringStatus, boolean bl, boolean bl2) {
        AbstractTypeDeclaration abstractTypeDeclaration;
        ITypeBinding iTypeBinding;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTypeBinding = (abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding()) != null) {
            ITypeBinding iTypeBinding2 = this.fFieldDeclaration.resolveBinding().getType();
            SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(iTypeBinding, this.fGetterName, iTypeBinding2, new ITypeBinding[0], refactoringStatus, bl);
            SelfEncapsulateFieldRefactoring.checkMethodInHierarchy(iTypeBinding, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{iTypeBinding2}, refactoringStatus, bl2);
        }
    }

    public static void checkMethodInHierarchy(ITypeBinding iTypeBinding, String string, ITypeBinding iTypeBinding2, ITypeBinding[] iTypeBindingArray, RefactoringStatus refactoringStatus, boolean bl) {
        IMethodBinding iMethodBinding = Bindings.findMethodInHierarchy(iTypeBinding, string, iTypeBindingArray);
        if (iMethodBinding != null) {
            Object object;
            boolean bl2 = false;
            ITypeBinding iTypeBinding3 = iMethodBinding.getReturnType();
            if (iTypeBinding2 != null && iTypeBinding3 != null) {
                object = iTypeBinding2.getKey();
                String string2 = iTypeBinding3.getKey();
                if (object == null && string2 == null) {
                    bl2 = iTypeBinding2 != iTypeBinding3;
                } else if (object != null && string2 != null) {
                    bl2 = !((String)object).equals(string2);
                }
            }
            object = iMethodBinding.getDeclaringClass();
            if (bl2) {
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{string, object.getName()}), JavaStatusContext.create(iMethodBinding));
            } else if (!bl) {
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{string, object.getName()}), JavaStatusContext.create(iMethodBinding));
            }
        } else if (bl) {
            refactoringStatus.addError(Messages.format(RefactoringCoreMessages.SelfEncapsulateFieldRefactoring_nosuchmethod_status_fatalError, new Object[]{string}), JavaStatusContext.create(iMethodBinding));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList(0);
        this.fUsedModifyNames = new ArrayList(0);
        IVariableBinding iVariableBinding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        IMethodBinding[] iMethodBindingArray = iVariableBinding.getDeclaringClass().getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            IMethodBinding iMethodBinding = iMethodBindingArray[n];
            ITypeBinding[] iTypeBindingArray = iMethodBindingArray[n].getParameterTypes();
            if (iTypeBindingArray == null || iTypeBindingArray.length == 0) {
                this.fUsedReadNames.add(iMethodBinding);
            } else if (iTypeBindingArray.length == 1 && iTypeBindingArray[0] == iTypeBinding) {
                this.fUsedModifyNames.add(iMethodBinding);
            }
            ++n;
        }
    }

    private List addGetterSetterChanges(CompilationUnit compilationUnit, ASTRewrite aSTRewrite, String string, boolean bl, boolean bl2) throws CoreException {
        BodyDeclaration bodyDeclaration;
        ArrayList<TextEditGroup> arrayList = new ArrayList<TextEditGroup>(2);
        AST aST = compilationUnit.getAST();
        FieldDeclaration fieldDeclaration = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 23);
        int n = 0;
        int n2 = 0;
        List list = ASTNodes.getBodyDeclarations(fieldDeclaration.getParent());
        TextEditGroup textEditGroup = list.iterator();
        while (textEditGroup.hasNext()) {
            bodyDeclaration = (BodyDeclaration)textEditGroup.next();
            if (bodyDeclaration.getNodeType() == 31) {
                if (this.fInsertionIndex == -1) break;
                if (this.fInsertionIndex == n2) {
                    ++n;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        bodyDeclaration = this.fRewriter.getListRewrite(fieldDeclaration.getParent(), this.getBodyDeclarationsProperty(fieldDeclaration.getParent()));
        if (!JdtFlags.isFinal((IMember)this.fField) && !bl) {
            textEditGroup = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_setter);
            arrayList.add(textEditGroup);
            bodyDeclaration.insertAt((ASTNode)this.createSetterMethod(aST, aSTRewrite, string), n++, textEditGroup);
        }
        if (!bl2) {
            textEditGroup = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_add_getter);
            arrayList.add(textEditGroup);
            bodyDeclaration.insertAt((ASTNode)this.createGetterMethod(aST, aSTRewrite, string), n, textEditGroup);
        }
        if (!JdtFlags.isPrivate((IMember)this.fField)) {
            arrayList.add(this.makeDeclarationPrivate(aSTRewrite, fieldDeclaration));
        }
        return arrayList;
    }

    private TextEditGroup makeDeclarationPrivate(ASTRewrite aSTRewrite, FieldDeclaration fieldDeclaration) {
        AST aST = aSTRewrite.getAST();
        TextEditGroup textEditGroup = new TextEditGroup(RefactoringCoreMessages.SelfEncapsulateField_change_visibility);
        if (fieldDeclaration.fragments().size() > 1) {
            aSTRewrite.remove((ASTNode)this.fFieldDeclaration, textEditGroup);
            ChildListPropertyDescriptor childListPropertyDescriptor = this.getBodyDeclarationsProperty(fieldDeclaration.getParent());
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTRewrite.createCopyTarget((ASTNode)this.fFieldDeclaration);
            FieldDeclaration fieldDeclaration2 = aST.newFieldDeclaration(variableDeclarationFragment);
            fieldDeclaration2.setType((Type)aSTRewrite.createCopyTarget((ASTNode)fieldDeclaration.getType()));
            fieldDeclaration2.modifiers().addAll(ASTNodeFactory.newModifiers(aST, 2));
            aSTRewrite.getListRewrite(fieldDeclaration.getParent(), childListPropertyDescriptor).insertAfter((ASTNode)fieldDeclaration2, (ASTNode)fieldDeclaration, textEditGroup);
        } else {
            ModifierRewrite.create(aSTRewrite, (ASTNode)fieldDeclaration).setVisibility(2, textEditGroup);
        }
        return textEditGroup;
    }

    private ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode aSTNode) {
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private MethodDeclaration createSetterMethod(AST aST, ASTRewrite aSTRewrite, String string) throws CoreException {
        Object object;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration fieldDeclaration = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = fieldDeclaration.getType();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setName(aST.newSimpleName(this.fSetterName));
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.createModifiers()));
        if (this.fSetterMustReturnValue) {
            methodDeclaration.setReturnType2((Type)aSTRewrite.createCopyTarget((ASTNode)type));
        }
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        methodDeclaration.parameters().add(singleVariableDeclaration);
        singleVariableDeclaration.setName(aST.newSimpleName(this.fArgName));
        singleVariableDeclaration.setType((Type)aSTRewrite.createCopyTarget((ASTNode)type));
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        Assignment assignment = aST.newAssignment();
        assignment.setLeftHandSide(this.createFieldAccess(aST));
        assignment.setRightHandSide((Expression)aST.newSimpleName(this.fArgName));
        if (this.fSetterMustReturnValue) {
            object = aST.newReturnStatement();
            object.setExpression((Expression)assignment);
            block.statements().add(object);
        } else {
            block.statements().add(aST.newExpressionStatement((Expression)assignment));
        }
        if (this.fGenerateJavadoc && (object = CodeGeneration.getSetterComment(this.fField.getCompilationUnit(), this.getTypeName(fieldDeclaration.getParent()), this.fSetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), this.fArgName, NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), string)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder((String)object, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        return methodDeclaration;
    }

    private MethodDeclaration createGetterMethod(AST aST, ASTRewrite aSTRewrite, String string) throws CoreException {
        String string2;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration fieldDeclaration = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = fieldDeclaration.getType();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setName(aST.newSimpleName(this.fGetterName));
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.createModifiers()));
        methodDeclaration.setReturnType2((Type)aSTRewrite.createCopyTarget((ASTNode)type));
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        ReturnStatement returnStatement = aST.newReturnStatement();
        returnStatement.setExpression((Expression)aST.newSimpleName(this.fField.getElementName()));
        block.statements().add(returnStatement);
        if (this.fGenerateJavadoc && (string2 = CodeGeneration.getGetterComment(this.fField.getCompilationUnit(), this.getTypeName(fieldDeclaration.getParent()), this.fGetterName, this.fField.getElementName(), ASTNodes.asString((ASTNode)type), NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fField.getJavaProject(), (String)this.fField.getElementName(), (int)this.fField.getFlags()), string)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string2, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        return methodDeclaration;
    }

    private int createModifiers() throws JavaModelException {
        int n = 0;
        if (Flags.isPublic((int)this.fVisibility)) {
            n |= 1;
        } else if (Flags.isProtected((int)this.fVisibility)) {
            n |= 4;
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            n |= 2;
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            n |= 8;
        }
        return n;
    }

    private Expression createFieldAccess(AST aST) throws JavaModelException {
        String string = this.fField.getElementName();
        if (this.fArgName.equals(string)) {
            if (JdtFlags.isStatic((IMember)this.fField)) {
                return aST.newQualifiedName((Name)aST.newSimpleName(this.fField.getDeclaringType().getElementName()), aST.newSimpleName(string));
            }
            FieldAccess fieldAccess = aST.newFieldAccess();
            fieldAccess.setExpression((Expression)aST.newThisExpression());
            fieldAccess.setName(aST.newSimpleName(string));
            return fieldAccess;
        }
        return aST.newSimpleName(string);
    }

    private void checkArgName() {
        String string = this.fField.getElementName();
        boolean bl = true;
        try {
            bl = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException javaModelException) {}
        IJavaProject iJavaProject = this.fField.getJavaProject();
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String string3 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        if (bl && this.fArgName.equals(string) && string.equals(this.fField.getDeclaringType().getElementName()) || JavaConventions.validateIdentifier((String)this.fArgName, (String)string2, (String)string3).getSeverity() == 4) {
            this.fArgName = "_" + this.fArgName;
        }
    }

    private String getTypeName(ASTNode aSTNode) {
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getName().getIdentifier();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz);
            return ASTNodes.asString((ASTNode)classInstanceCreation.getType());
        }
        Assert.isTrue((boolean)false, (String)"Should not happen");
        return null;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            String string;
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object == null || !object.exists() || object.getElementType() != 8) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.self.encapsulate");
                }
                this.fField = (IField)object;
                try {
                    this.initialize(this.fField);
                }
                catch (JavaModelException javaModelException) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.self.encapsulate");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_GETTER);
            if (object == null || NO_NAME.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_GETTER));
            }
            this.fGetterName = object;
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_SETTER);
            if (object == null || NO_NAME.equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SETTER));
            }
            this.fSetterName = object;
            String string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DECLARING);
            if (string3 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DECLARING));
            }
            this.fEncapsulateDeclaringClass = Boolean.valueOf(string3);
            String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_COMMENTS);
            if (string4 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
            }
            this.fGenerateJavadoc = Boolean.valueOf(string4);
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY);
            if (string5 != null && !NO_NAME.equals(string5)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = n;
            }
            if ((string = javaRefactoringArguments.getAttribute(ATTRIBUTE_INSERTION)) != null && !NO_NAME.equals(string)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INSERTION));
                }
                this.fInsertionIndex = n;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean isUsingLocalGetter() {
        IType iType = this.fField.getDeclaringType();
        return SelfEncapsulateFieldRefactoring.checkName(this.fGetterName, this.fUsedReadNames, iType);
    }

    public boolean isUsingLocalSetter() {
        IType iType = this.fField.getDeclaringType();
        return SelfEncapsulateFieldRefactoring.checkName(this.fSetterName, this.fUsedModifyNames, iType);
    }

    private static boolean checkName(String string, List list, IType iType) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMethodBinding iMethodBinding = (IMethodBinding)iterator.next();
            String string2 = iMethodBinding.getName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnorableProblem(IProblem iProblem) {
        return iProblem.getID() == 33554503;
    }

    public boolean isConsiderVisibility() {
        return this.fConsiderVisibility;
    }

    public void setConsiderVisibility(boolean bl) {
        this.fConsiderVisibility = bl;
    }
}

