/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class MemberVisibilityAdjustor {
    public static final GroupCategorySet SET_VISIBILITY_ADJUSTMENTS = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.visibilityAdjustments", RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_name, RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_description));
    private Map fAdjustments = new HashMap();
    private boolean fIncoming = true;
    private boolean fOutgoing = true;
    private final IMember fReferenced;
    private final IJavaElement fReferencing;
    private ASTRewrite fRewrite = null;
    private Map fRewrites = new HashMap(3);
    private CompilationUnit fRoot = null;
    private IJavaSearchScope fScope;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private final Map fTypeHierarchies = new HashMap();
    private int fVisibilitySeverity = 2;
    private WorkingCopyOwner fOwner = null;

    public static String getLabel(IJavaElement iJavaElement) {
        Assert.isNotNull((Object)iJavaElement);
        return JavaElementLabels.getElementLabel(iJavaElement, JavaElementLabels.ALL_FULLY_QUALIFIED | JavaElementLabels.ALL_DEFAULT);
    }

    public static String getLabel(Modifier.ModifierKeyword modifierKeyword) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(modifierKeyword));
        if (modifierKeyword == null) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default;
        }
        if (Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(modifierKeyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
        }
        if (Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(modifierKeyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_private;
    }

    public static String getMessage(IMember iMember) {
        Assert.isTrue((iMember instanceof IType || iMember instanceof IMethod || iMember instanceof IField ? 1 : 0) != 0);
        if (iMember instanceof IType) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning;
        }
        if (iMember instanceof IMethod) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning;
    }

    public static boolean hasLowerVisibility(int n, int n2) {
        if (Modifier.isPrivate((int)n2)) {
            return false;
        }
        if (Modifier.isPublic((int)n2)) {
            return !Modifier.isPublic((int)n);
        }
        if (Modifier.isProtected((int)n2)) {
            return !Modifier.isProtected((int)n) && !Modifier.isPublic((int)n);
        }
        return Modifier.isPrivate((int)n);
    }

    public static boolean hasLowerVisibility(Modifier.ModifierKeyword modifierKeyword, Modifier.ModifierKeyword modifierKeyword2) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(modifierKeyword));
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(modifierKeyword2));
        return MemberVisibilityAdjustor.hasLowerVisibility(modifierKeyword != null ? modifierKeyword.toFlagValue() : 0, modifierKeyword2 != null ? modifierKeyword2.toFlagValue() : 0);
    }

    private static boolean isStatusSeverity(int n) {
        return n == 3 || n == 4 || n == 1 || n == 0 || n == 2;
    }

    private static boolean isVisibilityKeyword(Modifier.ModifierKeyword modifierKeyword) {
        return modifierKeyword == null || Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(modifierKeyword) || Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(modifierKeyword) || Modifier.ModifierKeyword.PRIVATE_KEYWORD.equals(modifierKeyword);
    }

    private static boolean isVisibilityModifier(int n) {
        return n == 0 || n == 1 || n == 4 || n == 2;
    }

    private static int keywordToVisibility(Modifier.ModifierKeyword modifierKeyword) {
        int n = 0;
        if (modifierKeyword == Modifier.ModifierKeyword.PUBLIC_KEYWORD) {
            n = 1;
        } else if (modifierKeyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD) {
            n = 2;
        } else if (modifierKeyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD) {
            n = 4;
        }
        return n;
    }

    public static boolean needsVisibilityAdjustments(IMember iMember, int n, Map map) {
        Assert.isNotNull((Object)iMember);
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityModifier(n));
        Assert.isNotNull((Object)map);
        IncomingMemberVisibilityAdjustment incomingMemberVisibilityAdjustment = (IncomingMemberVisibilityAdjustment)map.get(iMember);
        if (incomingMemberVisibilityAdjustment != null) {
            Modifier.ModifierKeyword modifierKeyword = incomingMemberVisibilityAdjustment.getKeyword();
            return MemberVisibilityAdjustor.hasLowerVisibility(modifierKeyword == null ? 0 : modifierKeyword.toFlagValue(), n);
        }
        return true;
    }

    public static boolean needsVisibilityAdjustments(IMember iMember, Modifier.ModifierKeyword modifierKeyword, Map map) {
        Assert.isNotNull((Object)iMember);
        Assert.isNotNull((Object)map);
        IncomingMemberVisibilityAdjustment incomingMemberVisibilityAdjustment = (IncomingMemberVisibilityAdjustment)map.get(iMember);
        if (incomingMemberVisibilityAdjustment != null) {
            return MemberVisibilityAdjustor.hasLowerVisibility(incomingMemberVisibilityAdjustment.getKeyword(), modifierKeyword);
        }
        return true;
    }

    public MemberVisibilityAdjustor(IJavaElement iJavaElement, IMember iMember) {
        Assert.isTrue((!(iMember instanceof IInitializer) ? 1 : 0) != 0);
        Assert.isTrue((iJavaElement instanceof ICompilationUnit || iJavaElement instanceof IType || iJavaElement instanceof IPackageFragment ? 1 : 0) != 0);
        this.fScope = RefactoringScopeFactory.createReferencedScope(new IJavaElement[]{iMember}, 11);
        this.fReferencing = iJavaElement;
        this.fReferenced = iMember;
    }

    private void adjustIncomingVisibility(IJavaElement iJavaElement, IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Modifier.ModifierKeyword modifierKeyword = this.getVisibilityThreshold(iJavaElement, iMember, iProgressMonitor);
        int n = iMember.getFlags();
        IType iType = iMember.getDeclaringType();
        if (iType.isInterface()) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(n, modifierKeyword == null ? 0 : modifierKeyword.toFlagValue()) && this.needsVisibilityAdjustment(iMember, modifierKeyword)) {
            this.fAdjustments.put(iMember, new IncomingMemberVisibilityAdjustment(iMember, modifierKeyword, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(MemberVisibilityAdjustor.getMessage(iMember), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)iMember), MemberVisibilityAdjustor.getLabel(modifierKeyword)}), (RefactoringStatusContext)JavaStatusContext.create(iMember), null, (int)-1, null)));
        }
    }

    private void adjustMemberVisibility(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        int n;
        Object[] objectArray;
        if (iMember instanceof IType) {
            objectArray = ((IType)iMember).getChildren();
            n = 0;
            while (n < objectArray.length) {
                if (!(objectArray[n] instanceof IInitializer)) {
                    this.adjustMemberVisibility((IMember)objectArray[n], iProgressMonitor);
                }
                ++n;
            }
        }
        if (iMember.equals(this.fReferenced) || Modifier.isPublic((int)iMember.getFlags())) {
            return;
        }
        objectArray = this.findReferences(iMember, iProgressMonitor);
        n = 0;
        while (n < objectArray.length) {
            SearchMatch[] searchMatchArray = objectArray[n].getSearchResults();
            int n2 = 0;
            while (n2 < searchMatchArray.length) {
                IJavaElement iJavaElement = (IJavaElement)searchMatchArray[n2].getElement();
                if (this.fAdjustments.get(iMember) == null && iJavaElement instanceof IMember && !this.isInsideMovedMember(iJavaElement)) {
                    this.adjustIncomingVisibility(this.fReferencing, iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isInsideMovedMember(IJavaElement iJavaElement) {
        IJavaElement iJavaElement2 = iJavaElement;
        while ((iJavaElement2 = iJavaElement2.getParent()) != null) {
            if (!iJavaElement2.equals(this.fReferenced)) continue;
            return true;
        }
        return false;
    }

    private SearchResultGroup[] findReferences(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)iMember, (int)2, (int)24));
        refactoringSearchEngine2.setOwner(this.fOwner);
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)iMember));
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return (SearchResultGroup[])refactoringSearchEngine2.getResults();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustIncomingVisibility(SearchResultGroup[] searchResultGroupArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask("", searchResultGroupArray.length);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            SearchMatch[] searchMatchArray = null;
            boolean bl = false;
            int n = 0;
            while (n < searchResultGroupArray.length) {
                searchMatchArray = searchResultGroupArray[n].getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    Object object = searchMatchArray[n2].getElement();
                    if (object instanceof IMember && !this.isInsideMovedMember((IJavaElement)((IMember)object))) {
                        this.adjustIncomingVisibility(this.fReferencing, this.fReferenced, iProgressMonitor);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    iProgressMonitor.worked(1);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        iProgressMonitor.done();
    }

    private void adjustOutgoingVisibility(IField iField, Modifier.ModifierKeyword modifierKeyword) throws JavaModelException {
        Assert.isTrue((!iField.isBinary() && !iField.isReadOnly() ? 1 : 0) != 0);
        IType iType = iField.getDeclaringType();
        if (iType != null && iType.equals(this.fReferenced)) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(iField.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(modifierKeyword)) && this.needsVisibilityAdjustment((IMember)iField, modifierKeyword)) {
            this.adjustOutgoingVisibility((IMember)iField, modifierKeyword, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning);
        }
    }

    private void adjustOutgoingVisibility(IMember iMember, Modifier.ModifierKeyword modifierKeyword, String string) throws JavaModelException {
        Assert.isTrue((!iMember.isBinary() && !iMember.isReadOnly() ? 1 : 0) != 0);
        boolean bl = true;
        IType iType = iMember.getDeclaringType();
        if (iType != null && (JavaModelUtil.isInterfaceOrAnnotation(iType) || iType.equals(this.fReferenced))) {
            bl = false;
        }
        if (bl && MemberVisibilityAdjustor.hasLowerVisibility(iMember.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(modifierKeyword)) && this.needsVisibilityAdjustment(iMember, modifierKeyword)) {
            this.fAdjustments.put(iMember, new OutgoingMemberVisibilityAdjustment(iMember, modifierKeyword, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(string, new String[]{JavaElementLabels.getTextLabel(iMember, 1L | JavaElementLabels.ALL_FULLY_QUALIFIED), MemberVisibilityAdjustor.getLabel(modifierKeyword)}), (RefactoringStatusContext)JavaStatusContext.create(iMember), null, (int)-1, null)));
        }
    }

    private void adjustOutgoingVisibility(SearchMatch searchMatch, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMember iMember;
        Object object = searchMatch.getElement();
        if (object instanceof IMember && !(iMember = (IMember)object).isBinary() && !iMember.isReadOnly() && !this.isInsideMovedMember((IJavaElement)iMember)) {
            this.adjustOutgoingVisibilityChain(iMember, iProgressMonitor);
        }
    }

    private void adjustOutgoingVisibilityChain(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (!Modifier.isPublic((int)iMember.getFlags())) {
            Modifier.ModifierKeyword modifierKeyword = this.computeOutgoingVisibilityThreshold(this.fReferencing, iMember, iProgressMonitor);
            if (iMember instanceof IMethod) {
                this.adjustOutgoingVisibility(iMember, modifierKeyword, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
            } else if (iMember instanceof IField) {
                this.adjustOutgoingVisibility((IField)iMember, modifierKeyword);
            } else if (iMember instanceof IType) {
                this.adjustOutgoingVisibility(iMember, modifierKeyword, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning);
            }
        }
        if (iMember.getDeclaringType() != null) {
            this.adjustOutgoingVisibilityChain((IMember)iMember.getDeclaringType(), iProgressMonitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustOutgoingVisibility(SearchResultGroup[] searchResultGroupArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask("", searchResultGroupArray.length);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            IJavaElement iJavaElement = null;
            SearchMatch[] searchMatchArray = null;
            SearchResultGroup searchResultGroup = null;
            int n = 0;
            while (n < searchResultGroupArray.length) {
                searchResultGroup = searchResultGroupArray[n];
                iJavaElement = JavaCore.create((IResource)searchResultGroup.getResource());
                if (iJavaElement instanceof ICompilationUnit) {
                    searchMatchArray = searchResultGroup.getSearchResults();
                    int n2 = 0;
                    while (n2 < searchMatchArray.length) {
                        this.adjustOutgoingVisibility(searchMatchArray[n2], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ++n2;
                    }
                }
                iProgressMonitor.worked(1);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void adjustVisibility(IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask("", 7);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fReferenced, (int)2, (int)24));
            refactoringSearchEngine2.setScope(this.fScope);
            refactoringSearchEngine2.setStatus(this.fStatus);
            refactoringSearchEngine2.setOwner(this.fOwner);
            if (this.fIncoming) {
                refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.adjustIncomingVisibility((SearchResultGroup[])refactoringSearchEngine2.getResults(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                refactoringSearchEngine2.clearResults();
                if (this.fReferenced instanceof IType) {
                    IType iType = (IType)this.fReferenced;
                    this.adjustMemberVisibility((IMember)iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
            }
            if (this.fOutgoing) {
                refactoringSearchEngine2.searchReferencedTypes((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
                refactoringSearchEngine2.searchReferencedFields((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
                refactoringSearchEngine2.searchReferencedMethods((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
                this.adjustOutgoingVisibility((SearchResultGroup[])refactoringSearchEngine2.getResults(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Modifier.ModifierKeyword getVisibilityThreshold(IJavaElement iJavaElement, IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isTrue((!(iJavaElement instanceof IInitializer) ? 1 : 0) != 0);
        Assert.isTrue((!(iMember instanceof IInitializer) ? 1 : 0) != 0);
        Modifier.ModifierKeyword modifierKeyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int n = iJavaElement.getElementType();
            int n2 = iMember.getElementType();
            switch (n2) {
                case 7: {
                    IType iType = (IType)iMember;
                    ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
                    switch (n) {
                        case 7: {
                            modifierKeyword = this.thresholdTypeToType((IType)iJavaElement, iType, iProgressMonitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember iMember2 = (IMember)iJavaElement;
                            if (iType.equals(iMember2.getDeclaringType())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit != null && iCompilationUnit.equals(iMember2.getCompilationUnit())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!iType.getPackageFragment().equals(iMember2.getDeclaringType().getPackageFragment())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iType.getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField iField = (IField)iMember;
                    ICompilationUnit iCompilationUnit = iField.getCompilationUnit();
                    switch (n) {
                        case 7: {
                            modifierKeyword = this.thresholdTypeToField((IType)iJavaElement, iField, iProgressMonitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember iMember3 = (IMember)iJavaElement;
                            if (iField.getDeclaringType().equals(iMember3.getDeclaringType())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit != null && iCompilationUnit.equals(iMember3.getCompilationUnit())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!iField.getDeclaringType().getPackageFragment().equals(iMember3.getDeclaringType().getPackageFragment())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iField.getDeclaringType().getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod iMethod = (IMethod)iMember;
                    ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
                    switch (n) {
                        case 7: {
                            modifierKeyword = this.thresholdTypeToMethod((IType)iJavaElement, iMethod, iProgressMonitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember iMember4 = (IMember)iJavaElement;
                            if (iMethod.getDeclaringType().equals(iMember4.getDeclaringType())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit != null && iCompilationUnit.equals(iMember4.getCompilationUnit())) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!iMethod.getDeclaringType().getPackageFragment().equals(iMember4.getDeclaringType().getPackageFragment())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iMethod.getDeclaringType().getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        iProgressMonitor.done();
        return modifierKeyword;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Modifier.ModifierKeyword computeOutgoingVisibilityThreshold(IJavaElement iJavaElement, IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isTrue((iJavaElement instanceof ICompilationUnit || iJavaElement instanceof IType || iJavaElement instanceof IPackageFragment ? 1 : 0) != 0);
        Assert.isTrue((iMember instanceof IType || iMember instanceof IField || iMember instanceof IMethod ? 1 : 0) != 0);
        Modifier.ModifierKeyword modifierKeyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int n = iJavaElement.getElementType();
            int n2 = iMember.getElementType();
            switch (n2) {
                case 7: {
                    IType iType = (IType)iMember;
                    switch (n) {
                        case 5: {
                            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
                            ICompilationUnit iCompilationUnit2 = iType.getCompilationUnit();
                            if (iCompilationUnit2 != null && iCompilationUnit2.equals(iCompilationUnit)) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit2 == null || !iCompilationUnit2.getParent().equals(iCompilationUnit.getParent())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 7: {
                            modifierKeyword = this.thresholdTypeToType((IType)iJavaElement, iType, iProgressMonitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iType.getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField iField = (IField)iMember;
                    ICompilationUnit iCompilationUnit = iField.getCompilationUnit();
                    switch (n) {
                        case 5: {
                            ICompilationUnit iCompilationUnit3 = (ICompilationUnit)iJavaElement;
                            if (iCompilationUnit != null && iCompilationUnit.equals(iCompilationUnit3)) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit == null || !iCompilationUnit.getParent().equals(iCompilationUnit3.getParent())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 7: {
                            modifierKeyword = this.thresholdTypeToField((IType)iJavaElement, iField, iProgressMonitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iField.getDeclaringType().getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod iMethod = (IMethod)iMember;
                    ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
                    switch (n) {
                        case 5: {
                            ICompilationUnit iCompilationUnit4 = (ICompilationUnit)iJavaElement;
                            if (iCompilationUnit != null && iCompilationUnit.equals(iCompilationUnit4)) {
                                modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (iCompilationUnit == null || !iCompilationUnit.getParent().equals(iCompilationUnit4.getParent())) break;
                            modifierKeyword = null;
                            break;
                        }
                        case 7: {
                            modifierKeyword = this.thresholdTypeToMethod((IType)iJavaElement, iMethod, iProgressMonitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                            if (!iMethod.getDeclaringType().getPackageFragment().equals(iPackageFragment)) break;
                            modifierKeyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        iProgressMonitor.done();
        return modifierKeyword;
    }

    public final Map getAdjustments() {
        return this.fAdjustments;
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit iCompilationUnit) {
        CompilationUnitRewrite compilationUnitRewrite = (CompilationUnitRewrite)this.fRewrites.get(iCompilationUnit);
        if (compilationUnitRewrite == null) {
            compilationUnitRewrite = this.fOwner == null ? new CompilationUnitRewrite(iCompilationUnit) : new CompilationUnitRewrite(this.fOwner, iCompilationUnit);
        }
        return compilationUnitRewrite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeHierarchy getTypeHierarchy(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ITypeHierarchy iTypeHierarchy = null;
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            try {
                iTypeHierarchy = (ITypeHierarchy)this.fTypeHierarchies.get(iType);
                if (iTypeHierarchy == null) {
                    iTypeHierarchy = this.fOwner == null ? iType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2)) : iType.newSupertypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
                iProgressMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        iProgressMonitor.done();
        return iTypeHierarchy;
    }

    private boolean needsVisibilityAdjustment(IMember iMember, Modifier.ModifierKeyword modifierKeyword) {
        Assert.isNotNull((Object)iMember);
        return MemberVisibilityAdjustor.needsVisibilityAdjustments(iMember, modifierKeyword, this.fAdjustments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask("", this.fAdjustments.keySet().size());
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember iMember = null;
            IVisibilityAdjustment iVisibilityAdjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                iMember = (IMember)iterator.next();
                if (!iCompilationUnit.equals(iMember.getCompilationUnit()) || (iVisibilityAdjustment = (IVisibilityAdjustment)this.fAdjustments.get(iMember)) == null) continue;
                iVisibilityAdjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fTypeHierarchies.clear();
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fTypeHierarchies.clear();
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask("", this.fAdjustments.keySet().size());
            iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember iMember = null;
            IVisibilityAdjustment iVisibilityAdjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                iMember = (IMember)iterator.next();
                iVisibilityAdjustment = (IVisibilityAdjustment)this.fAdjustments.get(iMember);
                if (iVisibilityAdjustment != null) {
                    iVisibilityAdjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                if (!iProgressMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fTypeHierarchies.clear();
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fTypeHierarchies.clear();
        }
        iProgressMonitor.done();
    }

    public final void setAdjustments(Map map) {
        Assert.isNotNull((Object)map);
        this.fAdjustments = map;
    }

    public final void setFailureSeverity(int n) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(n));
    }

    public final void setIncoming(boolean bl) {
        this.fIncoming = bl;
    }

    public final void setOutgoing(boolean bl) {
        this.fOutgoing = bl;
    }

    public final void setRewrite(ASTRewrite aSTRewrite, CompilationUnit compilationUnit) {
        Assert.isTrue((aSTRewrite == null || compilationUnit != null ? 1 : 0) != 0);
        this.fRewrite = aSTRewrite;
        this.fRoot = compilationUnit;
    }

    public final void setRewrites(Map map) {
        Assert.isNotNull((Object)map);
        this.fRewrites = map;
    }

    public final void setScope(IJavaSearchScope iJavaSearchScope) {
        Assert.isNotNull((Object)iJavaSearchScope);
        this.fScope = iJavaSearchScope;
    }

    public final void setOwner(WorkingCopyOwner workingCopyOwner) {
        this.fOwner = workingCopyOwner;
    }

    public final void setStatus(RefactoringStatus refactoringStatus) {
        Assert.isNotNull((Object)refactoringStatus);
        this.fStatus = refactoringStatus;
    }

    public final void setVisibilitySeverity(int n) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(n));
        this.fVisibilitySeverity = n;
    }

    private Modifier.ModifierKeyword thresholdTypeToField(IType iType, IField iField, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        Modifier.ModifierKeyword modifierKeyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit iCompilationUnit2 = iField.getCompilationUnit();
        if (iField.getDeclaringType().equals(iType)) {
            modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            iCompilationUnit = this.getTypeHierarchy(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iCompilationUnit.getSupertypes(iType);
            IType iType2 = null;
            int n = 0;
            while (n < iTypeArray.length) {
                iType2 = iTypeArray[n];
                if (iType2.equals(iField.getDeclaringType())) {
                    modifierKeyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return modifierKeyword;
                }
                ++n;
            }
        }
        iCompilationUnit = iType.getCompilationUnit();
        if (iCompilationUnit2 != null && iCompilationUnit2.equals(iCompilationUnit)) {
            modifierKeyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (iCompilationUnit2 != null && iCompilationUnit != null && iCompilationUnit2.getParent().equals(iCompilationUnit.getParent())) {
            modifierKeyword = null;
        }
        return modifierKeyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToMethod(IType iType, IMethod iMethod, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        ICompilationUnit iCompilationUnit2 = iMethod.getCompilationUnit();
        Object object = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        if (iMethod.getDeclaringType().equals(iType)) {
            object = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            iCompilationUnit = this.getTypeHierarchy(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iCompilationUnit.getSupertypes(iType);
            IType iType2 = null;
            int n = 0;
            while (n < iTypeArray.length) {
                iType2 = iTypeArray[n];
                if (iType2.equals(iMethod.getDeclaringType())) {
                    object = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return object;
                }
                ++n;
            }
        }
        iCompilationUnit = iType.getCompilationUnit();
        if (iCompilationUnit2 != null && iCompilationUnit2.equals(iCompilationUnit)) {
            object = iMethod.getDeclaringType().getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (iCompilationUnit2 != null && iCompilationUnit2.getParent().equals(iCompilationUnit.getParent())) {
            object = null;
        }
        return object;
    }

    private Modifier.ModifierKeyword thresholdTypeToType(IType iType, IType iType2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        Object object = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit iCompilationUnit2 = iType2.getCompilationUnit();
        if (iType.equals(iType2.getDeclaringType())) {
            object = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            iCompilationUnit = this.getTypeHierarchy(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iCompilationUnit.getSupertypes(iType);
            IType iType3 = null;
            int n = 0;
            while (n < iTypeArray.length) {
                iType3 = iTypeArray[n];
                if (iType3.equals(iType2)) {
                    object = null;
                    return object;
                }
                ++n;
            }
        }
        iCompilationUnit = iType.getCompilationUnit();
        if (iCompilationUnit2 != null && iCompilationUnit2.equals(iCompilationUnit)) {
            object = iType2.getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (iCompilationUnit2 != null && iCompilationUnit != null && iCompilationUnit2.getParent().equals(iCompilationUnit.getParent())) {
            object = null;
        }
        return object;
    }

    public static interface IVisibilityAdjustment {
        public void rewriteVisibility(MemberVisibilityAdjustor var1, IProgressMonitor var2) throws JavaModelException;
    }

    public static class IncomingMemberVisibilityAdjustment
    implements IVisibilityAdjustment {
        protected final Modifier.ModifierKeyword fKeyword;
        protected final IMember fMember;
        protected boolean fNeedsRewriting = true;
        protected final RefactoringStatus fRefactoringStatus;

        public IncomingMemberVisibilityAdjustment(IMember iMember, Modifier.ModifierKeyword modifierKeyword, RefactoringStatus refactoringStatus) {
            Assert.isNotNull((Object)iMember);
            Assert.isTrue((!(iMember instanceof IInitializer) ? 1 : 0) != 0);
            Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(modifierKeyword));
            this.fMember = iMember;
            this.fKeyword = modifierKeyword;
            this.fRefactoringStatus = refactoringStatus;
        }

        public final Modifier.ModifierKeyword getKeyword() {
            return this.fKeyword;
        }

        public final IMember getMember() {
            return this.fMember;
        }

        public final RefactoringStatus getStatus() {
            return this.fRefactoringStatus;
        }

        public final boolean needsRewriting() {
            return this.fNeedsRewriting;
        }

        protected final void rewriteVisibility(MemberVisibilityAdjustor memberVisibilityAdjustor, ASTRewrite aSTRewrite, CompilationUnit compilationUnit, CategorizedTextEditGroup categorizedTextEditGroup, RefactoringStatus refactoringStatus) throws JavaModelException {
            BodyDeclaration bodyDeclaration;
            int n;
            Assert.isNotNull((Object)memberVisibilityAdjustor);
            Assert.isNotNull((Object)aSTRewrite);
            Assert.isNotNull((Object)compilationUnit);
            int n2 = n = this.fKeyword != null ? this.fKeyword.toFlagValue() : 0;
            if (this.fMember instanceof IField && !Flags.isEnum((int)this.fMember.getFlags())) {
                VariableDeclarationFragment variableDeclarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)this.fMember, compilationUnit);
                FieldDeclaration fieldDeclaration = (FieldDeclaration)variableDeclarationFragment.getParent();
                if (fieldDeclaration.fragments().size() == 1) {
                    ModifierRewrite.create(aSTRewrite, (ASTNode)fieldDeclaration).setVisibility(n, (TextEditGroup)categorizedTextEditGroup);
                } else {
                    Modifier modifier;
                    VariableDeclarationFragment variableDeclarationFragment2 = aSTRewrite.getAST().newVariableDeclarationFragment();
                    variableDeclarationFragment2.setName((SimpleName)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationFragment.getName()));
                    FieldDeclaration fieldDeclaration2 = aSTRewrite.getAST().newFieldDeclaration(variableDeclarationFragment2);
                    fieldDeclaration2.setType((Type)aSTRewrite.createCopyTarget((ASTNode)fieldDeclaration.getType()));
                    IExtendedModifier iExtendedModifier = null;
                    AbstractTypeDeclaration abstractTypeDeclaration = fieldDeclaration.modifiers().iterator();
                    while (abstractTypeDeclaration.hasNext()) {
                        int n3;
                        iExtendedModifier = (IExtendedModifier)abstractTypeDeclaration.next();
                        if (iExtendedModifier.isModifier() && ((n3 = (modifier = (Modifier)iExtendedModifier).getKeyword().toFlagValue()) & 7) != 0) continue;
                        fieldDeclaration2.modifiers().add(aSTRewrite.createCopyTarget((ASTNode)iExtendedModifier));
                    }
                    ModifierRewrite.create(aSTRewrite, (ASTNode)fieldDeclaration2).setVisibility(n, (TextEditGroup)categorizedTextEditGroup);
                    abstractTypeDeclaration = (AbstractTypeDeclaration)fieldDeclaration.getParent();
                    aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAfter((ASTNode)fieldDeclaration2, (ASTNode)fieldDeclaration, null);
                    modifier = aSTRewrite.getListRewrite((ASTNode)fieldDeclaration, FieldDeclaration.FRAGMENTS_PROPERTY);
                    modifier.remove((ASTNode)variableDeclarationFragment, (TextEditGroup)categorizedTextEditGroup);
                    if (modifier.getRewrittenList().isEmpty()) {
                        aSTRewrite.remove((ASTNode)fieldDeclaration, null);
                    }
                }
                if (refactoringStatus != null) {
                    memberVisibilityAdjustor.fStatus.merge(refactoringStatus);
                }
            } else if (this.fMember != null && (bodyDeclaration = ASTNodeSearchUtil.getBodyDeclarationNode(this.fMember, compilationUnit)) != null) {
                ModifierRewrite.create(aSTRewrite, (ASTNode)bodyDeclaration).setVisibility(n, (TextEditGroup)categorizedTextEditGroup);
                if (refactoringStatus != null) {
                    memberVisibilityAdjustor.fStatus.merge(refactoringStatus);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor memberVisibilityAdjustor, IProgressMonitor iProgressMonitor) throws JavaModelException {
            Assert.isNotNull((Object)memberVisibilityAdjustor);
            Assert.isNotNull((Object)iProgressMonitor);
            try {
                iProgressMonitor.beginTask("", 1);
                iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    if (memberVisibilityAdjustor.fRewrite != null && memberVisibilityAdjustor.fRoot != null) {
                        this.rewriteVisibility(memberVisibilityAdjustor, memberVisibilityAdjustor.fRewrite, memberVisibilityAdjustor.fRoot, null, this.fRefactoringStatus);
                    } else {
                        CompilationUnitRewrite compilationUnitRewrite = memberVisibilityAdjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                        this.rewriteVisibility(memberVisibilityAdjustor, compilationUnitRewrite.getASTRewrite(), compilationUnitRewrite.getRoot(), compilationUnitRewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                    }
                } else if (this.fRefactoringStatus != null) {
                    memberVisibilityAdjustor.fStatus.merge(this.fRefactoringStatus);
                }
                iProgressMonitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            iProgressMonitor.done();
        }

        public final void setNeedsRewriting(boolean bl) {
            this.fNeedsRewriting = bl;
        }
    }

    public static class OutgoingMemberVisibilityAdjustment
    extends IncomingMemberVisibilityAdjustment {
        public OutgoingMemberVisibilityAdjustment(IMember iMember, Modifier.ModifierKeyword modifierKeyword, RefactoringStatus refactoringStatus) {
            super(iMember, modifierKeyword, refactoringStatus);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor memberVisibilityAdjustor, IProgressMonitor iProgressMonitor) throws JavaModelException {
            Assert.isNotNull((Object)memberVisibilityAdjustor);
            Assert.isNotNull((Object)iProgressMonitor);
            try {
                iProgressMonitor.beginTask("", 1);
                iProgressMonitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    CompilationUnitRewrite compilationUnitRewrite = memberVisibilityAdjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                    this.rewriteVisibility(memberVisibilityAdjustor, compilationUnitRewrite.getASTRewrite(), compilationUnitRewrite.getRoot(), compilationUnitRewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                }
                iProgressMonitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            iProgressMonitor.done();
        }
    }
}

