/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class ArrayType
extends TType {
    private TType fElementType;
    private int fDimensions;
    private TType fErasure;

    protected ArrayType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected ArrayType(TypeEnvironment typeEnvironment, String string) {
        super(typeEnvironment, string);
    }

    protected void initialize(ITypeBinding iTypeBinding, TType tType) {
        Assert.isTrue((boolean)iTypeBinding.isArray());
        super.initialize(iTypeBinding);
        this.fElementType = tType;
        this.fDimensions = iTypeBinding.getDimensions();
        this.fErasure = this.fElementType.isStandardType() || this.fElementType.isGenericType() || this.fElementType.isPrimitiveType() ? this : this.getEnvironment().create(iTypeBinding.getErasure());
    }

    protected void initialize(TType tType, int n) {
        this.fElementType = tType;
        this.fDimensions = n;
        this.fErasure = this.fElementType.isStandardType() || this.fElementType.isGenericType() || this.fElementType.isPrimitiveType() ? this : this.getEnvironment().createArrayType(tType.getErasure(), n);
    }

    public TType getElementType() {
        return this.fElementType;
    }

    public TType getComponentType() {
        if (this.fDimensions > 1) {
            return this.getEnvironment().createArrayType(this.fElementType, this.fDimensions - 1);
        }
        return this.fElementType;
    }

    public int getDimensions() {
        return this.fDimensions;
    }

    public int getKind() {
        return 4;
    }

    public TType[] getSubTypes() {
        TType[] tTypeArray = this.fElementType.getSubTypes();
        TType[] tTypeArray2 = new TType[tTypeArray.length];
        int n = 0;
        while (n < tTypeArray.length) {
            tTypeArray2[n] = this.getEnvironment().createArrayType(tTypeArray[n], this.fDimensions);
            ++n;
        }
        return tTypeArray2;
    }

    public TType getErasure() {
        return this.fErasure;
    }

    public boolean doEquals(TType tType) {
        ArrayType arrayType = (ArrayType)tType;
        return this.fElementType.equals(arrayType.fElementType) && this.fDimensions == arrayType.fDimensions;
    }

    public int hashCode() {
        return this.fElementType.hashCode() << 5;
    }

    protected boolean doCanAssignTo(TType tType) {
        switch (tType.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.canAssignToArrayType((ArrayType)tType);
            }
            case 6: {
                return false;
            }
            case 5: {
                return this.isArrayLhsCompatible(tType);
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(tType);
            }
        }
        return false;
    }

    private boolean canAssignToArrayType(ArrayType arrayType) {
        if (this.fDimensions == arrayType.fDimensions) {
            if (this.fElementType.getKind() == 3 || arrayType.fElementType.getKind() == 3) {
                return this.fElementType.isTypeEquivalentTo(arrayType.fElementType);
            }
            return this.fElementType.canAssignTo(arrayType.fElementType);
        }
        if (this.fDimensions < arrayType.fDimensions) {
            return false;
        }
        return this.isArrayLhsCompatible(arrayType.fElementType);
    }

    private boolean isArrayLhsCompatible(TType tType) {
        return tType.isJavaLangObject() || tType.isJavaLangCloneable() || tType.isJavaIoSerializable();
    }

    protected String getPlainPrettySignature() {
        StringBuffer stringBuffer = new StringBuffer(this.fElementType.getPlainPrettySignature());
        int n = 0;
        while (n < this.fDimensions) {
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer(this.fElementType.getName());
        int n = 0;
        while (n < this.fDimensions) {
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }
}

