/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class StandardType
extends HierarchyType {
    private static final String OBJECT_KEY = BindingKey.createTypeBindingKey((String)"java.lang.Object");
    private static final String CLONEABLE_KEY = BindingKey.createTypeBindingKey((String)"java.lang.Cloneable");
    private static final String SERIALIZABLE_KEY = BindingKey.createTypeBindingKey((String)"java.io.Serializable");

    protected StandardType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    public int getKind() {
        return 5;
    }

    public boolean isJavaLangObject() {
        return OBJECT_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaLangCloneable() {
        return CLONEABLE_KEY.equals(this.getBindingKey());
    }

    public boolean isJavaIoSerializable() {
        return SERIALIZABLE_KEY.equals(this.getBindingKey());
    }

    public boolean doEquals(TType tType) {
        return this.getJavaElementType().equals(((StandardType)tType).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    protected boolean doCanAssignTo(TType tType) {
        switch (tType.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return this.canAssignToPrimitive((PrimitiveType)tType);
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)tType);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((HierarchyType)tType);
            }
            case 8: {
                return this.isSubType((HierarchyType)tType);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(this);
            }
        }
        return false;
    }

    private boolean canAssignToPrimitive(PrimitiveType primitiveType) {
        PrimitiveType primitiveType2 = this.getEnvironment().createUnBoxed(this);
        return primitiveType2 != null && primitiveType2.canAssignTo(primitiveType);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        return this.getJavaElementType().getFullyQualifiedName('.');
    }
}

