/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class TypeVariable
extends AbstractTypeVariable {
    private ITypeParameter fJavaTypeParameter;

    protected TypeVariable(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, ITypeParameter iTypeParameter) {
        Assert.isTrue((boolean)iTypeBinding.isTypeVariable());
        Assert.isNotNull((Object)iTypeParameter);
        this.fJavaTypeParameter = iTypeParameter;
        super.initialize(iTypeBinding);
    }

    public int getKind() {
        return 12;
    }

    public boolean doEquals(TType tType) {
        return this.fJavaTypeParameter.equals(((TypeVariable)tType).fJavaTypeParameter);
    }

    public int hashCode() {
        return this.fJavaTypeParameter.hashCode();
    }

    protected boolean doCanAssignTo(TType tType) {
        switch (tType.getKind()) {
            case 1: 
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return false;
            }
            case 6: {
                return false;
            }
            case 5: 
            case 7: 
            case 8: {
                return this.canAssignOneBoundTo(tType);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return this.doExtends((TypeVariable)tType);
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(this);
            }
        }
        return false;
    }

    private boolean doExtends(TypeVariable typeVariable) {
        int n = 0;
        while (n < this.fBounds.length) {
            TType tType = this.fBounds[n];
            if (typeVariable.equals(tType) || tType.getKind() == 12 && ((TypeVariable)tType).doExtends(typeVariable)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getName() {
        return this.fJavaTypeParameter.getElementName();
    }

    public String getPrettySignature() {
        if (this.fBounds.length == 1 && this.fBounds[0].isJavaLangObject()) {
            return this.fJavaTypeParameter.getElementName();
        }
        StringBuffer stringBuffer = new StringBuffer(this.fJavaTypeParameter.getElementName());
        if (this.fBounds.length > 0) {
            stringBuffer.append(" extends ");
            stringBuffer.append(this.fBounds[0].getPlainPrettySignature());
            int n = 1;
            while (n < this.fBounds.length) {
                stringBuffer.append(" & ");
                stringBuffer.append(this.fBounds[n].getPlainPrettySignature());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected String getPlainPrettySignature() {
        return this.fJavaTypeParameter.getElementName();
    }
}

