/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SuperTypesOfSingleton
extends TypeSet {
    private TType fLowerBound;
    private EnumeratedTypeSet fEnumCache = null;

    SuperTypesOfSingleton(TType tType, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBound = tType;
    }

    public boolean isUniverse() {
        return false;
    }

    public TypeSet makeClone() {
        return this;
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        if (typeSet.isSingleton() && typeSet.anyMember().equals(this.fLowerBound)) {
            return typeSet;
        }
        if (typeSet instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton superTypesOfSingleton = (SuperTypesOfSingleton)typeSet;
            if (TTypes.canAssignTo(superTypesOfSingleton.fLowerBound, this.fLowerBound)) {
                return this;
            }
            if (TTypes.canAssignTo(this.fLowerBound, superTypesOfSingleton.fLowerBound)) {
                return superTypesOfSingleton;
            }
        } else if (typeSet.hasUniqueUpperBound()) {
            TType tType = typeSet.uniqueUpperBound();
            if (tType.equals(this.fLowerBound)) {
                return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
            }
            if (tType != this.fLowerBound && TTypes.canAssignTo(tType, this.fLowerBound) || !TTypes.canAssignTo(this.fLowerBound, tType)) {
                return this.getTypeSetEnvironment().getEmptyTypeSet();
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
    }

    public TypeSet lowerBound() {
        return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
    }

    public boolean hasUniqueLowerBound() {
        return true;
    }

    public boolean hasUniqueUpperBound() {
        return true;
    }

    public TType uniqueLowerBound() {
        return this.fLowerBound;
    }

    public TType uniqueUpperBound() {
        return this.getJavaLangObject();
    }

    public TypeSet superTypes() {
        return this;
    }

    public boolean contains(TType tType) {
        if (tType.equals(this.fLowerBound)) {
            return true;
        }
        if (tType.equals(this.getJavaLangObject())) {
            return true;
        }
        return TTypes.canAssignTo(this.fLowerBound, tType);
    }

    public boolean containsAll(TypeSet typeSet) {
        if (typeSet instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton superTypesOfSingleton = (SuperTypesOfSingleton)typeSet;
            return TTypes.canAssignTo(this.fLowerBound, superTypesOfSingleton.fLowerBound);
        }
        if (typeSet instanceof SuperTypesSet) {
            SuperTypesSet superTypesSet = (SuperTypesSet)typeSet;
            TypeSet typeSet2 = superTypesSet.lowerBound();
            Iterator iterator = typeSet2.iterator();
            while (iterator.hasNext()) {
                TType tType = (TType)iterator.next();
                if (TTypes.canAssignTo(this.fLowerBound, tType)) continue;
                return false;
            }
            return true;
        }
        if (typeSet.isUniverse()) {
            return false;
        }
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            if (TTypes.canAssignTo(this.fLowerBound, tType)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public boolean isSingleton() {
        return this.fLowerBound.equals(this.getJavaLangObject());
    }

    public TType anyMember() {
        return this.fLowerBound;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            if (this.fLowerBound instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)this.fLowerBound;
                this.fEnumCache = EnumeratedTypeSet.makeArrayTypesForElements(TTypes.getAllSuperTypesIterator(arrayType.getComponentType()), this.getTypeSetEnvironment());
                this.fEnumCache.add(this.getJavaLangObject());
            } else {
                this.fEnumCache = new EnumeratedTypeSet(TTypes.getAllSuperTypesIterator(this.fLowerBound), this.getTypeSetEnvironment());
            }
            this.fEnumCache.add(this.fLowerBound);
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SuperTypesOfSingleton)) {
            return false;
        }
        SuperTypesOfSingleton superTypesOfSingleton = (SuperTypesOfSingleton)object;
        return superTypesOfSingleton.fLowerBound.equals(this.fLowerBound);
    }

    public String toString() {
        return "<" + this.fID + ": superTypes(" + this.fLowerBound.getPrettySignature() + ")>";
    }
}

