/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;

public abstract class CompilationUnitContextType
extends TemplateContextType {
    public CompilationUnitContextType(String string) {
        super(string);
    }

    public abstract CompilationUnitContext createContext(IDocument var1, int var2, int var3, ICompilationUnit var4);

    public abstract CompilationUnitContext createContext(IDocument var1, Position var2, ICompilationUnit var3);

    protected void validateVariables(TemplateVariable[] templateVariableArray) throws TemplateException {
        int n = 0;
        while (n < templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor") && templateVariable.getOffsets().length > 1) {
                throw new TemplateException(JavaTemplateMessages.ContextType_error_multiple_cursor_variables);
            }
            ++n;
        }
    }

    protected static class Arguments
    extends TemplateVariableResolver {
        public Arguments() {
            super("enclosing_method_arguments", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_method_arguments);
        }

        protected String resolve(TemplateContext templateContext) {
            IJavaElement iJavaElement = ((CompilationUnitContext)templateContext).findEnclosingElement(9);
            if (iJavaElement == null) {
                return null;
            }
            IMethod iMethod = (IMethod)iJavaElement;
            try {
                String[] stringArray = iMethod.getParameterNames();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
                return stringBuffer.toString();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
    }

    protected static class EnclosingJavaElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingJavaElement(String string, String string2, int n) {
            super(string, string2);
            this.fElementType = n;
        }

        protected String resolve(TemplateContext templateContext) {
            IJavaElement iJavaElement = ((CompilationUnitContext)templateContext).findEnclosingElement(this.fElementType);
            return iJavaElement == null ? null : iJavaElement.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext templateContext) {
            return this.resolve(templateContext) != null;
        }
    }

    protected static class File
    extends TemplateVariableResolver {
        public File() {
            super("file", JavaTemplateMessages.CompilationUnitContextType_variable_description_file);
        }

        protected String resolve(TemplateContext templateContext) {
            ICompilationUnit iCompilationUnit = ((CompilationUnitContext)templateContext).getCompilationUnit();
            return iCompilationUnit == null ? null : iCompilationUnit.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext templateContext) {
            return this.resolve(templateContext) != null;
        }
    }

    protected static class Method
    extends EnclosingJavaElement {
        public Method() {
            super("enclosing_method", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_method, 9);
        }
    }

    protected static class Package
    extends EnclosingJavaElement {
        public Package() {
            super("enclosing_package", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_package, 4);
        }
    }

    protected static class PrimaryTypeName
    extends TemplateVariableResolver {
        public PrimaryTypeName() {
            super("primary_type_name", JavaTemplateMessages.CompilationUnitContextType_variable_description_primary_type_name);
        }

        protected String resolve(TemplateContext templateContext) {
            ICompilationUnit iCompilationUnit = ((CompilationUnitContext)templateContext).getCompilationUnit();
            if (iCompilationUnit == null) {
                return null;
            }
            return JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName());
        }

        protected boolean isUnambiguous(TemplateContext templateContext) {
            return this.resolve(templateContext) != null;
        }
    }

    protected static class Project
    extends EnclosingJavaElement {
        public Project() {
            super("enclosing_project", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_project, 2);
        }
    }

    protected static class ReturnType
    extends TemplateVariableResolver {
        public ReturnType() {
            super("return_type", JavaTemplateMessages.CompilationUnitContextType_variable_description_return_type);
        }

        protected String resolve(TemplateContext templateContext) {
            IJavaElement iJavaElement = ((CompilationUnitContext)templateContext).findEnclosingElement(9);
            if (iJavaElement == null) {
                return null;
            }
            try {
                return Signature.toString((String)((IMethod)iJavaElement).getReturnType());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
    }

    protected static class Type
    extends EnclosingJavaElement {
        public Type() {
            super("enclosing_type", JavaTemplateMessages.CompilationUnitContextType_variable_description_enclosing_type, 7);
        }
    }
}

