/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.ValidateEditException;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public final class JavaModelUtil {
    public static final String DEFAULT_CU_SUFFIX = ".js";

    public static IType findType(IJavaProject iJavaProject, String string) throws JavaModelException {
        IType iType = iJavaProject.findType(string);
        if (iType != null) {
            return iType;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            iType = JavaModelUtil.findType(iPackageFragmentRoot, string);
            if (iType != null && iType.exists()) {
                return iType;
            }
            ++n;
        }
        return null;
    }

    public static IType findType(IJavaProject iJavaProject, String string, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        IType iType = iJavaProject.findType(string, workingCopyOwner);
        if (iType != null) {
            return iType;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            iType = JavaModelUtil.findType(iPackageFragmentRoot, string);
            if (iType != null && iType.exists()) {
                return iType;
            }
            ++n;
        }
        return null;
    }

    private static IType findType(IPackageFragmentRoot iPackageFragmentRoot, String string) throws JavaModelException {
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IType iType;
            IPackageFragment iPackageFragment;
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement.getElementType() == 4 && string.startsWith((iPackageFragment = (IPackageFragment)iJavaElement).getElementName()) && (iType = JavaModelUtil.findType(iPackageFragment, string)) != null && iType.exists()) {
                return iType;
            }
            ++n;
        }
        return null;
    }

    private static IType findType(IPackageFragment iPackageFragment, String string) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
            IType iType = JavaModelUtil.findType(iCompilationUnit, string);
            if (iType != null && iType.exists()) {
                return iType;
            }
            ++n;
        }
        return null;
    }

    private static IType findType(ICompilationUnit iCompilationUnit, String string) throws JavaModelException {
        IType[] iTypeArray = iCompilationUnit.getAllTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            if (JavaModelUtil.getFullyQualifiedName(iType).equals(string)) {
                return iType;
            }
            ++n;
        }
        return null;
    }

    public static IJavaElement findTypeContainer(IJavaProject iJavaProject, String string) throws JavaModelException {
        Path path;
        IType iType = iJavaProject.findType(string);
        if (iType == null && !((iType = iJavaProject.findElement((IPath)(path = new Path(string.replace('.', '/'))))) instanceof IPackageFragment)) {
            iType = null;
        }
        return iType;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit iCompilationUnit, String string) throws JavaModelException {
        IType[] iTypeArray = iCompilationUnit.getAllTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            String string2 = JavaModelUtil.getTypeQualifiedName(iTypeArray[n]);
            if (string.equals(string2)) {
                return iTypeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit iCompilationUnit, IJavaElement iJavaElement) {
        IJavaElement[] iJavaElementArray = iCompilationUnit.findElements(iJavaElement);
        if (iJavaElementArray != null && iJavaElementArray.length > 0) {
            return iJavaElementArray[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType iType) {
        try {
            IType iType2;
            if (iType.isBinary() && !iType.isAnonymous() && (iType2 = iType.getDeclaringType()) != null) {
                return String.valueOf(JavaModelUtil.getTypeQualifiedName(iType2)) + '.' + iType.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {}
        return iType.getTypeQualifiedName('.');
    }

    public static String getFullyQualifiedName(IType iType) {
        try {
            IType iType2;
            if (iType.isBinary() && !iType.isAnonymous() && (iType2 = iType.getDeclaringType()) != null) {
                return String.valueOf(JavaModelUtil.getFullyQualifiedName(iType2)) + '.' + iType.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {}
        return iType.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType iType) {
        IType iType2 = iType.getDeclaringType();
        if (iType2 != null) {
            return JavaModelUtil.getFullyQualifiedName(iType2);
        }
        return iType.getPackageFragment().getElementName();
    }

    public static String concatenateName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        if (string2 != null && string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String concatenateName(char[] cArray, char[] cArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray != null && cArray.length > 0) {
            stringBuffer.append(cArray);
        }
        if (cArray2 != null && cArray2.length > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(cArray2);
        }
        return stringBuffer.toString();
    }

    public static boolean isVisible(IMember iMember, IPackageFragment iPackageFragment) throws JavaModelException {
        int n = iMember.getElementType();
        if (n == 10 || n == 9 && iMember.getElementName().startsWith("<")) {
            return false;
        }
        int n2 = iMember.getFlags();
        IType iType = iMember.getDeclaringType();
        if (Flags.isPublic((int)n2) || iType != null && JavaModelUtil.isInterfaceOrAnnotation(iType)) {
            return true;
        }
        if (Flags.isPrivate((int)n2)) {
            return false;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)iMember.getAncestor(4);
        return iPackageFragment != null && iPackageFragment2 != null && JavaModelUtil.isSamePackage(iPackageFragment, iPackageFragment2);
    }

    public static boolean isVisibleInHierarchy(IMember iMember, IPackageFragment iPackageFragment) throws JavaModelException {
        int n = iMember.getElementType();
        if (n == 10 || n == 9 && iMember.getElementName().startsWith("<")) {
            return false;
        }
        int n2 = iMember.getFlags();
        IType iType = iMember.getDeclaringType();
        if (Flags.isPublic((int)n2) || Flags.isProtected((int)n2) || iType != null && JavaModelUtil.isInterfaceOrAnnotation(iType)) {
            return true;
        }
        if (Flags.isPrivate((int)n2)) {
            return false;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)iMember.getAncestor(4);
        return iPackageFragment != null && iPackageFragment.equals(iPackageFragment2);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement iJavaElement) {
        return (IPackageFragmentRoot)iJavaElement.getAncestor(3);
    }

    public static IMethod findMethod(String string, String[] stringArray, boolean bl, IType iType) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (JavaModelUtil.isSameMethodSignature(string, stringArray, bl, iMethodArray[n])) {
                return iMethodArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IMethod findMethodInHierarchy(ITypeHierarchy iTypeHierarchy, IType iType, String string, String[] stringArray, boolean bl) throws JavaModelException {
        IMethod iMethod;
        IMethod iMethod2 = JavaModelUtil.findMethod(string, stringArray, bl, iType);
        if (iMethod2 != null) {
            return iMethod2;
        }
        IType iType2 = iTypeHierarchy.getSuperclass(iType);
        if (iType2 != null && (iMethod = JavaModelUtil.findMethodInHierarchy(iTypeHierarchy, iType2, string, stringArray, bl)) != null) {
            return iMethod;
        }
        if (!bl) {
            iMethod = iTypeHierarchy.getSuperInterfaces(iType);
            int n = 0;
            while (n < ((IMethod)iMethod).length) {
                IMethod iMethod3 = JavaModelUtil.findMethodInHierarchy(iTypeHierarchy, (IType)iMethod[n], string, stringArray, false);
                if (iMethod3 != null) {
                    return iMethod3;
                }
                ++n;
            }
        }
        return iMethod2;
    }

    public static boolean isSameMethodSignature(String string, String[] stringArray, boolean bl, IMethod iMethod) throws JavaModelException {
        String[] stringArray2;
        if ((bl || string.equals(iMethod.getElementName())) && bl == iMethod.isConstructor() && stringArray.length == (stringArray2 = iMethod.getParameterTypes()).length) {
            int n = 0;
            while (n < stringArray.length) {
                String string2;
                String string3 = Signature.getSimpleName((String)Signature.toString((String)stringArray[n]));
                if (!string3.equals(string2 = Signature.getSimpleName((String)Signature.toString((String)stringArray2[n])))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean isSamePackage(IPackageFragment iPackageFragment, IPackageFragment iPackageFragment2) {
        return iPackageFragment.getElementName().equals(iPackageFragment2.getElementName());
    }

    public static boolean hasMainMethod(IType iType) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (iMethodArray[n].isMainMethod()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isBoolean(IField iField) throws JavaModelException {
        return iField.getTypeSignature().equals("Z");
    }

    public static boolean isInterfaceOrAnnotation(IType iType) throws JavaModelException {
        return false;
    }

    public static String getResolvedTypeName(String string, IType iType) throws JavaModelException {
        int n = Signature.getArrayCount((String)string);
        char c = string.charAt(n);
        if (c == 'Q') {
            String string2 = "";
            int n2 = string.indexOf(60, n + 1);
            if (n2 > 0) {
                string2 = string.substring(n + 1, n2);
            } else {
                int n3 = string.indexOf(59, n + 1);
                if (n3 == -1) {
                    throw new IllegalArgumentException();
                }
                string2 = string.substring(n + 1, n3);
            }
            String[][] stringArray = iType.resolveType(string2);
            if (stringArray != null && stringArray.length > 0) {
                return JavaModelUtil.concatenateName(stringArray[0][0], stringArray[0][1]);
            }
            return null;
        }
        return Signature.toString((String)string.substring(n));
    }

    public static boolean isEditable(ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)iCompilationUnit);
        IResource iResource = iCompilationUnit.getPrimary().getResource();
        return iResource.exists() && !iResource.getResourceAttributes().isReadOnly();
    }

    public static IMember toOriginal(IMember iMember) {
        if (iMember instanceof IMethod) {
            return JavaModelUtil.toOriginalMethod((IMethod)iMember);
        }
        return (IMember)iMember.getPrimaryElement();
    }

    private static IMethod toOriginalMethod(IMethod iMethod) {
        ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
        if (iCompilationUnit == null || JavaModelUtil.isPrimary(iCompilationUnit)) {
            return iMethod;
        }
        try {
            if (iMethod.getDeclaringType() == null || !iMethod.getElementName().equals(iMethod.getDeclaringType().getElementName())) {
                return (IMethod)iMethod.getPrimaryElement();
            }
            IType iType = (IType)JavaModelUtil.toOriginal((IMember)iMethod.getDeclaringType());
            IMethod[] iMethodArray = iType.findMethods(iMethod);
            boolean bl = iMethod.isConstructor();
            int n = 0;
            while (n < iMethodArray.length) {
                if (iMethodArray[n].isConstructor() == bl) {
                    return iMethodArray[n];
                }
                ++n;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static boolean isPrimary(ICompilationUnit iCompilationUnit) {
        return iCompilationUnit.getOwner() == null;
    }

    public static boolean isExceptionToBeLogged(CoreException coreException) {
        if (!(coreException instanceof JavaModelException)) {
            return true;
        }
        JavaModelException javaModelException = (JavaModelException)((Object)coreException);
        if (!javaModelException.isDoesNotExist()) {
            return true;
        }
        IJavaElement[] iJavaElementArray = javaModelException.getJavaModelStatus().getElements();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement.getElementType() != 5) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                if (iCompilationUnit == null) {
                    return true;
                }
                if (!iCompilationUnit.isWorkingCopy()) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static IType[] getAllSuperTypes(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType iType2;
        IType[] iTypeArray = SuperTypeHierarchyCache.getTypeHierarchy(iType).getAllSupertypes(iType);
        if (iType.isInterface() && (iType2 = iType.getJavaProject().findType("java.lang.Object")) != null) {
            IType[] iTypeArray2 = new IType[iTypeArray.length + 1];
            System.arraycopy(iTypeArray, 0, iTypeArray2, 0, iTypeArray.length);
            iTypeArray2[iTypeArray.length] = iType2;
            return iTypeArray2;
        }
        return iTypeArray;
    }

    public static boolean isSuperType(ITypeHierarchy iTypeHierarchy, IType iType, IType iType2) {
        IType iType3 = iTypeHierarchy.getSuperclass(iType2);
        if (iType3 != null && (iType.equals(iType3) || JavaModelUtil.isSuperType(iTypeHierarchy, iType, iType3))) {
            return true;
        }
        if (Flags.isInterface((int)iTypeHierarchy.getCachedFlags(iType))) {
            IType[] iTypeArray = iTypeHierarchy.getSuperInterfaces(iType2);
            int n = 0;
            while (n < iTypeArray.length) {
                IType iType4 = iTypeArray[n];
                if (iType.equals(iType4) || JavaModelUtil.isSuperType(iTypeHierarchy, iType, iType4)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean isExcludedPath(IPath iPath, IPath[] iPathArray) {
        char[] cArray = iPath.toString().toCharArray();
        int n = 0;
        int n2 = iPathArray.length;
        while (n < n2) {
            char[] cArray2 = iPathArray[n].toString().toCharArray();
            if (CharOperation.pathMatch((char[])cArray2, (char[])cArray, (boolean)true, (char)'/')) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isExcluded(IPath iPath, char[][] cArray) {
        if (cArray == null) {
            return false;
        }
        char[] cArray2 = iPath.toString().toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (CharOperation.pathMatch((char[])cArray[n], (char[])cArray2, (boolean)true, (char)'/')) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void reconcile(ICompilationUnit iCompilationUnit) throws JavaModelException {
        iCompilationUnit.reconcile(0, false, null, null);
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject iJavaProject, IPath iPath, IPath iPath2) throws JavaModelException {
        IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
        if (iClasspathContainer != null && classpathContainerInitializer != null && classpathContainerInitializer.canUpdateClasspathContainer(iPath, iJavaProject)) {
            return JavaModelUtil.findEntryInContainer(iClasspathContainer, iPath2);
        }
        return null;
    }

    public static IClasspathEntry findEntryInContainer(IClasspathContainer iClasspathContainer, IPath iPath) {
        IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
            if (iClasspathEntry2 != null && iPath.equals((Object)iClasspathEntry2.getPath())) {
                return iClasspathEntry;
            }
            ++n;
        }
        return null;
    }

    public static ICompilationUnit[] getAllCompilationUnits(IJavaElement[] iJavaElementArray) throws JavaModelException {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iJavaElementArray.length) {
            JavaModelUtil.addAllCus(hashSet, iJavaElementArray[n]);
            ++n;
        }
        return hashSet.toArray(new ICompilationUnit[hashSet.size()]);
    }

    private static void addAllCus(HashSet hashSet, IJavaElement iJavaElement) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 2: {
                IJavaProject iJavaProject = (IJavaProject)iJavaElement;
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                int n = 0;
                while (n < iPackageFragmentRootArray.length) {
                    JavaModelUtil.addAllCus(hashSet, (IJavaElement)iPackageFragmentRootArray[n]);
                    ++n;
                }
                return;
            }
            case 3: {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                if (iPackageFragmentRoot.getKind() != 1) {
                    return;
                }
                IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    JavaModelUtil.addAllCus(hashSet, iJavaElementArray[n]);
                    ++n;
                }
                return;
            }
            case 4: {
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                hashSet.addAll(Arrays.asList(iPackageFragment.getCompilationUnits()));
                return;
            }
            case 5: {
                hashSet.add(iJavaElement);
                return;
            }
        }
        IJavaElement iJavaElement2 = iJavaElement.getAncestor(5);
        if (iJavaElement2 != null) {
            hashSet.add(iJavaElement2);
        }
    }

    public static void set50CompilanceOptions(Map map) {
        JavaModelUtil.setCompilanceOptions(map, "1.5");
    }

    public static void setCompilanceOptions(Map map, String string) {
        if ("1.6".equals(string)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.5".equals(string)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "error");
        } else if ("1.4".equals(string)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "warning");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "warning");
        } else if ("1.3".equals(string)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "ignore");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "ignore");
        } else {
            throw new IllegalArgumentException("Unsupported compliance: " + string);
        }
    }

    public static void setDefaultClassfileOptions(Map map, String string) {
        map.put("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode", JavaModelUtil.is50OrHigher(string) ? "enabled" : "disabled");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "preserve");
    }

    public static boolean isVersionLessThan(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    public static boolean is50OrHigher(String string) {
        return !JavaModelUtil.isVersionLessThan(string, "1.5");
    }

    public static boolean is50OrHigher(IJavaProject iJavaProject) {
        return JavaModelUtil.is50OrHigher(iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true));
    }

    public static boolean is50OrHigherJRE(IJavaProject iJavaProject) throws CoreException {
        IVMInstall iVMInstall = JavaRuntime.getVMInstall(iJavaProject);
        if (!(iVMInstall instanceof IVMInstall2)) {
            return true;
        }
        String string = JavaModelUtil.getCompilerCompliance((IVMInstall2)((Object)iVMInstall), null);
        if (string == null) {
            return true;
        }
        return string.startsWith("1.5") || string.startsWith("1.6");
    }

    public static String getCompilerCompliance(IVMInstall2 iVMInstall2, String string) {
        String string2 = iVMInstall2.getJavaVersion();
        if (string2 == null) {
            return string;
        }
        if (string2.startsWith("1.6")) {
            return "1.6";
        }
        if (string2.startsWith("1.5")) {
            return "1.5";
        }
        if (string2.startsWith("1.4")) {
            return "1.4";
        }
        if (string2.startsWith("1.3")) {
            return "1.3";
        }
        if (string2.startsWith("1.2")) {
            return "1.3";
        }
        if (string2.startsWith("1.1")) {
            return "1.3";
        }
        return string;
    }

    public static String getRenamedCUName(ICompilationUnit iCompilationUnit, String string) {
        String string2 = iCompilationUnit.getElementName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            return String.valueOf(string) + string2.substring(n);
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void applyEdit(ICompilationUnit iCompilationUnit, TextEdit textEdit, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException, ValidateEditException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 3);
        try {
            IDocument iDocument = null;
            try {
                try {
                    iDocument = JavaModelUtil.aquireDocument(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    if (bl) {
                        JavaModelUtil.commitDocument(iCompilationUnit, iDocument, textEdit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    } else {
                        new RewriteSessionEditProcessor(iDocument, textEdit, 2).performEdits();
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new CoreException(JavaUIStatus.createError(4, badLocationException));
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                JavaModelUtil.releaseDocument(iCompilationUnit, iDocument, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                throw throwable;
            }
            {
                Object var6_8 = null;
                JavaModelUtil.releaseDocument(iCompilationUnit, iDocument, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        iProgressMonitor.done();
    }

    private static IDocument aquireDocument(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        if (JavaModelUtil.isPrimary(iCompilationUnit) && (iFile = (IFile)iCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            IPath iPath = iCompilationUnit.getPath();
            iTextFileBufferManager.connect(iPath, LocationKind.IFILE, iProgressMonitor);
            return iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.IFILE).getDocument();
        }
        iProgressMonitor.done();
        return new Document(iCompilationUnit.getSource());
    }

    private static void commitDocument(ICompilationUnit iCompilationUnit, IDocument iDocument, TextEdit textEdit, IProgressMonitor iProgressMonitor) throws CoreException, MalformedTreeException, BadLocationException {
        IFile iFile;
        if (JavaModelUtil.isPrimary(iCompilationUnit) && (iFile = (IFile)iCompilationUnit.getResource()).exists()) {
            IStatus iStatus = Resources.makeCommittable((IResource)iFile, null);
            if (!iStatus.isOK()) {
                throw new ValidateEditException(iStatus);
            }
            new RewriteSessionEditProcessor(iDocument, textEdit, 2).performEdits();
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            iTextFileBufferManager.getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE).commit(iProgressMonitor, true);
            return;
        }
        new RewriteSessionEditProcessor(iDocument, textEdit, 2).performEdits();
    }

    private static void releaseDocument(ICompilationUnit iCompilationUnit, IDocument iDocument, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        if (JavaModelUtil.isPrimary(iCompilationUnit) && (iFile = (IFile)iCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            iTextFileBufferManager.disconnect(iFile.getFullPath(), LocationKind.IFILE, iProgressMonitor);
            return;
        }
        iCompilationUnit.getBuffer().setContents(iDocument.get());
        iProgressMonitor.done();
    }

    public static boolean isImplicitImport(String string, ICompilationUnit iCompilationUnit) {
        if ("java.lang".equals(string)) {
            return true;
        }
        String string2 = iCompilationUnit.getParent().getElementName();
        if (string.equals(string2)) {
            return true;
        }
        String string3 = JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName());
        String string4 = JavaModelUtil.concatenateName(string2, string3);
        return string.equals(string4);
    }

    public static boolean isOpenableStorage(Object object) {
        if (object instanceof IJarEntryResource) {
            return ((IJarEntryResource)object).isFile();
        }
        return object instanceof IStorage;
    }

    public static boolean isParameter(ILocalVariable iLocalVariable) throws JavaModelException {
        IJavaElement iJavaElement = iLocalVariable.getParent();
        if (iJavaElement instanceof IMethod) {
            String[] stringArray = ((IMethod)iJavaElement).getParameterNames();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(iLocalVariable.getElementName())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

