/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.ui.actions.QuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public abstract class JDTQuickMenuAction
extends QuickMenuAction {
    private JavaEditor fEditor;

    public JDTQuickMenuAction(String string) {
        super(string);
    }

    public JDTQuickMenuAction(JavaEditor javaEditor, String string) {
        super(string);
        this.fEditor = javaEditor;
    }

    protected Point computeMenuLocation(StyledText styledText) {
        if (this.fEditor == null || styledText != this.fEditor.getViewer().getTextWidget()) {
            return null;
        }
        return this.computeWordStart();
    }

    private Point computeWordStart() {
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        IRegion iRegion = JavaWordFinder.findWord(this.fEditor.getViewer().getDocument(), iTextSelection.getOffset());
        if (iRegion == null) {
            return null;
        }
        IRegion iRegion2 = this.modelRange2WidgetRange(iRegion);
        if (iRegion2 == null) {
            return null;
        }
        int n = iRegion2.getOffset();
        StyledText styledText = this.fEditor.getViewer().getTextWidget();
        Point point = styledText.getLocationAtOffset(n);
        point.y += styledText.getLineHeight(n);
        if (!styledText.getClientArea().contains(point)) {
            return null;
        }
        return point;
    }

    private IRegion modelRange2WidgetRange(IRegion iRegion) {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            return iTextViewerExtension5.modelRange2WidgetRange(iRegion);
        }
        IRegion iRegion2 = iSourceViewer.getVisibleRegion();
        int n = iRegion.getOffset() - iRegion2.getOffset();
        int n2 = n + iRegion.getLength();
        if (n2 > iRegion2.getLength()) {
            n2 = iRegion2.getLength();
        }
        return new Region(n, n2 - n);
    }
}

