/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;

class PackageViewerWrapper
extends StructuredViewer {
    private StructuredViewer fViewer;
    private ListenerList fListenerList = new ListenerList(1);
    private ListenerList fSelectionChangedListenerList;
    private ListenerList fPostSelectionChangedListenerList = new ListenerList(1);

    public PackageViewerWrapper() {
        this.fSelectionChangedListenerList = new ListenerList(1);
    }

    public void setViewer(StructuredViewer structuredViewer) {
        Assert.isNotNull((Object)structuredViewer);
        StructuredViewer structuredViewer2 = this.fViewer;
        this.fViewer = structuredViewer;
        if (this.fViewer.getContentProvider() != null) {
            super.setContentProvider(this.fViewer.getContentProvider());
        }
        this.transferFilters(structuredViewer2);
        this.transferListeners();
    }

    StructuredViewer getViewer() {
        return this.fViewer;
    }

    private void transferFilters(StructuredViewer structuredViewer) {
        if (structuredViewer != null) {
            ViewerFilter[] viewerFilterArray = structuredViewer.getFilters();
            int n = 0;
            while (n < viewerFilterArray.length) {
                ViewerFilter viewerFilter = viewerFilterArray[n];
                this.fViewer.addFilter(viewerFilter);
                ++n;
            }
        }
    }

    private void transferListeners() {
        ISelectionChangedListener iSelectionChangedListener;
        Object object;
        Object[] objectArray = this.fPostSelectionChangedListenerList.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            iSelectionChangedListener = (ISelectionChangedListener)object;
            this.fViewer.addPostSelectionChangedListener(iSelectionChangedListener);
            ++n;
        }
        objectArray = this.fSelectionChangedListenerList.getListeners();
        n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            iSelectionChangedListener = (ISelectionChangedListener)object;
            this.fViewer.addSelectionChangedListener(iSelectionChangedListener);
            ++n;
        }
        objectArray = this.fListenerList.getListeners();
        n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (object instanceof IOpenListener) {
                iSelectionChangedListener = (IOpenListener)object;
                this.addOpenListener((IOpenListener)iSelectionChangedListener);
            } else if (object instanceof HelpListener) {
                iSelectionChangedListener = (HelpListener)object;
                this.addHelpListener((HelpListener)iSelectionChangedListener);
            } else if (object instanceof IDoubleClickListener) {
                iSelectionChangedListener = (IDoubleClickListener)object;
                this.addDoubleClickListener((IDoubleClickListener)iSelectionChangedListener);
            }
            ++n;
        }
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IContentProvider iContentProvider = this.getContentProvider();
            if (iContentProvider instanceof LogicalPackagesProvider) {
                LogicalPackagesProvider logicalPackagesProvider = (LogicalPackagesProvider)iContentProvider;
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof IPackageFragment) {
                    IPackageFragment iPackageFragment = (IPackageFragment)object;
                    LogicalPackage logicalPackage = logicalPackagesProvider.findLogicalPackage(iPackageFragment);
                    object = logicalPackage != null ? logicalPackage : iPackageFragment;
                }
                if (object != null) {
                    this.fViewer.setSelection((ISelection)new StructuredSelection(object), bl);
                } else {
                    this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY, bl);
                }
            }
        } else {
            this.fViewer.setSelection(iSelection, bl);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPostSelectionChangedListenerList.add((Object)iSelectionChangedListener);
        this.fViewer.addPostSelectionChangedListener(iSelectionChangedListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionChangedListenerList.add((Object)iSelectionChangedListener);
        this.fViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.fViewer.addDoubleClickListener(iDoubleClickListener);
        this.fListenerList.add((Object)iDoubleClickListener);
    }

    public void addOpenListener(IOpenListener iOpenListener) {
        this.fViewer.addOpenListener(iOpenListener);
        this.fListenerList.add((Object)iOpenListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.fViewer.addHelpListener(helpListener);
        this.fListenerList.add((Object)helpListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fViewer.removeSelectionChangedListener(iSelectionChangedListener);
        this.fSelectionChangedListenerList.remove((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fViewer.removePostSelectionChangedListener(iSelectionChangedListener);
        this.fPostSelectionChangedListenerList.remove((Object)iSelectionChangedListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.fListenerList.remove((Object)helpListener);
        this.fViewer.removeHelpListener(helpListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.fViewer.removeDoubleClickListener(iDoubleClickListener);
        this.fListenerList.remove((Object)iDoubleClickListener);
    }

    public void removeOpenListener(IOpenListener iOpenListener) {
        this.fViewer.removeOpenListener(iOpenListener);
        this.fListenerList.remove((Object)iOpenListener);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public void addFilter(ViewerFilter viewerFilter) {
        this.fViewer.addFilter(viewerFilter);
    }

    public void setFilters(ViewerFilter[] viewerFilterArray) {
        this.fViewer.setFilters(viewerFilterArray);
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void removeFilter(ViewerFilter viewerFilter) {
        this.fViewer.removeFilter(viewerFilter);
    }

    public ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void refresh(boolean bl) {
        this.fViewer.refresh(bl);
    }

    public void refresh(Object object, boolean bl) {
        this.fViewer.refresh(object, bl);
    }

    public void refresh(Object object) {
        this.fViewer.refresh(object);
    }

    public void resetFilters() {
        this.fViewer.resetFilters();
    }

    public void reveal(Object object) {
        this.fViewer.reveal(object);
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        this.fViewer.setContentProvider(iContentProvider);
    }

    public void setSorter(ViewerSorter viewerSorter) {
        this.fViewer.setSorter(viewerSorter);
    }

    public void setComparator(ViewerComparator viewerComparator) {
        this.fViewer.setComparator(viewerComparator);
    }

    public void setUseHashlookup(boolean bl) {
        this.fViewer.setUseHashlookup(bl);
    }

    public Widget testFindItem(Object object) {
        return this.fViewer.testFindItem(object);
    }

    public void update(Object object, String[] stringArray) {
        this.fViewer.update(object, stringArray);
    }

    public void update(Object[] objectArray, String[] stringArray) {
        this.fViewer.update(objectArray, stringArray);
    }

    public IContentProvider getContentProvider() {
        return this.fViewer.getContentProvider();
    }

    public Object getInput() {
        return this.fViewer.getInput();
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.fViewer.getLabelProvider();
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        this.fViewer.setLabelProvider(iBaseLabelProvider);
    }

    public Object getData(String string) {
        return this.fViewer.getData(string);
    }

    public Item scrollDown(int n, int n2) {
        return this.fViewer.scrollDown(n, n2);
    }

    public Item scrollUp(int n, int n2) {
        return this.fViewer.scrollUp(n, n2);
    }

    public void setData(String string, Object object) {
        this.fViewer.setData(string, object);
    }

    public void setSelection(ISelection iSelection) {
        this.fViewer.setSelection(iSelection);
    }

    public boolean equals(Object object) {
        return this.fViewer.equals(object);
    }

    public int hashCode() {
        return this.fViewer.hashCode();
    }

    public String toString() {
        return this.fViewer.toString();
    }

    public void setViewerInput(Object object) {
        this.fViewer.setInput(object);
    }

    protected Widget doFindInputItem(Object object) {
        return ((IPackagesViewViewer)this.fViewer).doFindInputItem(object);
    }

    protected Widget doFindItem(Object object) {
        return ((IPackagesViewViewer)this.fViewer).doFindItem(object);
    }

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        ((IPackagesViewViewer)this.fViewer).doUpdateItem(widget, object, bl);
    }

    protected List getSelectionFromWidget() {
        return ((IPackagesViewViewer)this.fViewer).getSelectionFromWidget();
    }

    protected void internalRefresh(Object object) {
        ((IPackagesViewViewer)this.fViewer).internalRefresh(object);
    }

    protected void setSelectionToWidget(List list, boolean bl) {
        ((IPackagesViewViewer)this.fViewer).setSelectionToWidget(list, bl);
    }
}

