/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.DeferredMethodWrapper;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.TreeRoot;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class CallHierarchyContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private DeferredTreeContentManager fManager;
    private CallHierarchyViewPart fPart;

    public CallHierarchyContentProvider(CallHierarchyViewPart callHierarchyViewPart) {
        this.fPart = callHierarchyViewPart;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof TreeRoot) {
            TreeRoot treeRoot = (TreeRoot)object;
            return new Object[]{treeRoot.getRoot()};
        }
        if (object instanceof MethodWrapper) {
            Object[] objectArray;
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            if (this.shouldStopTraversion(methodWrapper)) {
                return EMPTY_ARRAY;
            }
            if (this.fManager != null && (objectArray = this.fManager.getChildren((Object)new DeferredMethodWrapper(this, methodWrapper))) != null) {
                return objectArray;
            }
            return this.fetchChildren(methodWrapper);
        }
        return EMPTY_ARRAY;
    }

    protected Object[] fetchChildren(MethodWrapper methodWrapper) {
        IWorkbenchWindow iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow();
        MethodWrapperRunnable methodWrapperRunnable = new MethodWrapperRunnable(methodWrapper);
        try {
            iWorkbenchWindow.run(true, true, (IRunnableWithProgress)methodWrapperRunnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, CallHierarchyMessages.CallHierarchyContentProvider_searchError_title, CallHierarchyMessages.CallHierarchyContentProvider_searchError_message);
            return EMPTY_ARRAY;
        }
        catch (InterruptedException interruptedException) {
            return new Object[]{TreeTermination.SEARCH_CANCELED};
        }
        return methodWrapperRunnable.getCalls();
    }

    private boolean shouldStopTraversion(MethodWrapper methodWrapper) {
        return methodWrapper.getLevel() > CallHierarchyUI.getDefault().getMaxCallDepth() || methodWrapper.isRecursive();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof MethodWrapper) {
            return ((MethodWrapper)((Object)object)).getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public boolean hasChildren(Object object) {
        if (object == TreeRoot.EMPTY_ROOT || object == TreeTermination.SEARCH_CANCELED) {
            return false;
        }
        if (object instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            if (methodWrapper.getMember().getElementType() != 9) {
                return false;
            }
            return !this.shouldStopTraversion(methodWrapper);
        }
        if (object instanceof TreeRoot) {
            return true;
        }
        return object instanceof DeferredMethodWrapper;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        Object object3;
        if (object instanceof TreeRoot && (object3 = ((TreeRoot)object).getRoot()) instanceof MethodWrapper) {
            this.cancelJobs((MethodWrapper)((Object)object3));
        }
        if (viewer instanceof AbstractTreeViewer) {
            this.fManager = new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer, this.fPart.getSite());
        }
    }

    void cancelJobs(MethodWrapper methodWrapper) {
        if (this.fManager != null && methodWrapper != null) {
            this.fManager.cancel((Object)methodWrapper);
            if (this.fPart != null) {
                this.fPart.setCancelEnabled(false);
            }
        }
    }

    public void doneFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(false);
        }
    }

    public void startFetching() {
        if (this.fPart != null) {
            this.fPart.setCancelEnabled(true);
        }
    }

    private class MethodWrapperRunnable
    implements IRunnableWithProgress {
        private MethodWrapper fMethodWrapper;
        private MethodWrapper[] fCalls = null;

        MethodWrapperRunnable(MethodWrapper methodWrapper) {
            this.fMethodWrapper = methodWrapper;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            this.fCalls = this.fMethodWrapper.getCalls(iProgressMonitor);
        }

        MethodWrapper[] getCalls() {
            if (this.fCalls != null) {
                return this.fCalls;
            }
            return new MethodWrapper[0];
        }
    }
}

