/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyLabelDecorator;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

class CallHierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private static final long TEXTFLAGS = 0x210000200029L | JavaElementLabels.ALL_POST_QUALIFIED | 0x2000000000L;
    private static final int IMAGEFLAGS = 3;
    private ILabelDecorator fDecorator = new CallHierarchyLabelDecorator();

    CallHierarchyLabelProvider() {
        super(TEXTFLAGS, 3);
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            if (methodWrapper.getMember() != null) {
                image = this.fDecorator.decorateImage(super.getImage(methodWrapper.getMember()), (Object)methodWrapper);
            }
        } else {
            if (this.isPendingUpdate(object)) {
                return null;
            }
            image = super.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        if (object instanceof MethodWrapper && ((MethodWrapper)((Object)object)).getMember() != null) {
            return this.getElementLabel((MethodWrapper)((Object)object));
        }
        return this.getSpecialLabel(object);
    }

    public ColoredString getRichTextLabel(Object object) {
        if (object instanceof MethodWrapper && ((MethodWrapper)((Object)object)).getMember() != null) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            String string = this.getElementLabel(methodWrapper);
            ColoredString coloredString = super.getRichTextLabel(methodWrapper.getMember());
            return ColoredJavaElementLabels.decorateColoredString(coloredString, string, ColoredJavaElementLabels.COUNTER_STYLE);
        }
        return new ColoredString(this.getSpecialLabel(object));
    }

    private String getSpecialLabel(Object object) {
        if (object instanceof MethodWrapper) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_root;
        }
        if (object == TreeTermination.SEARCH_CANCELED) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_searchCanceled;
        }
        if (this.isPendingUpdate(object)) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_updatePending;
        }
        return CallHierarchyMessages.CallHierarchyLabelProvider_noMethodSelected;
    }

    private boolean isPendingUpdate(Object object) {
        return object instanceof IWorkbenchAdapter;
    }

    private String getElementLabel(MethodWrapper methodWrapper) {
        String string = super.getText(methodWrapper.getMember());
        Collection collection = methodWrapper.getMethodCall().getCallLocations();
        if (collection != null && collection.size() > 1) {
            return Messages.format(CallHierarchyMessages.CallHierarchyLabelProvider_matches, new String[]{string, String.valueOf(collection.size())});
        }
        return string;
    }
}

