/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

class OpenLocationAction
extends SelectionDispatchAction {
    private CallHierarchyViewPart fPart;

    public OpenLocationAction(CallHierarchyViewPart callHierarchyViewPart, IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fPart = callHierarchyViewPart;
        this.setText(CallHierarchyMessages.OpenLocationAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenLocationAction_tooltip);
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof MethodWrapper || e instanceof CallLocation) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            boolean bl = CallHierarchyUI.openInEditor(iterator.next(), this.getShell(), this.getDialogTitle());
            if (bl) continue;
            return;
        }
    }

    private String getDialogTitle() {
        return CallHierarchyMessages.OpenLocationAction_error_title;
    }
}

