/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeProjectAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeWorkspaceAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SelectWorkingSetAction;

class SearchScopeActionGroup
extends ActionGroup {
    private static final String TAG_SEARCH_SCOPE_TYPE = "search_scope_type";
    private static final String TAG_SELECTED_WORKING_SET = "working_set";
    private static final String TAG_WORKING_SET_COUNT = "working_set_count";
    private static final String DIALOGSTORE_SCOPE_TYPE = "SearchScopeActionGroup.search_scope_type";
    private static final String DIALOGSTORE_SELECTED_WORKING_SET = "SearchScopeActionGroup.working_set";
    static final int SEARCH_SCOPE_TYPE_WORKSPACE = 1;
    static final int SEARCH_SCOPE_TYPE_PROJECT = 2;
    static final int SEARCH_SCOPE_TYPE_HIERARCHY = 3;
    static final int SEARCH_SCOPE_TYPE_WORKING_SET = 4;
    private SearchScopeAction fSelectedAction = null;
    private String[] fSelectedWorkingSetNames = null;
    private CallHierarchyViewPart fView;
    private IDialogSettings fDialogSettings;
    private SearchScopeHierarchyAction fSearchScopeHierarchyAction;
    private SearchScopeProjectAction fSearchScopeProjectAction;
    private SearchScopeWorkspaceAction fSearchScopeWorkspaceAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;

    public SearchScopeActionGroup(CallHierarchyViewPart callHierarchyViewPart, IDialogSettings iDialogSettings) {
        this.fView = callHierarchyViewPart;
        this.fDialogSettings = iDialogSettings;
        this.createActions();
    }

    public IJavaSearchScope getSearchScope() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScope();
        }
        return null;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fillContextMenu(iActionBars.getMenuManager());
    }

    protected void setActiveWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray != null) {
            this.fSelectedWorkingSetNames = this.getWorkingSetNames(iWorkingSetArray);
            this.fSelectedAction = new SearchScopeWorkingSetAction(this, iWorkingSetArray, this.getScopeDescription(iWorkingSetArray));
        } else {
            this.fSelectedWorkingSetNames = null;
            this.fSelectedAction = null;
        }
    }

    private String[] getWorkingSetNames(IWorkingSet[] iWorkingSetArray) {
        String[] stringArray = new String[iWorkingSetArray.length];
        int n = 0;
        while (n < iWorkingSetArray.length) {
            stringArray[n] = iWorkingSetArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    protected IWorkingSet[] getActiveWorkingSets() {
        if (this.fSelectedWorkingSetNames != null) {
            return this.getWorkingSets(this.fSelectedWorkingSetNames);
        }
        return null;
    }

    private IWorkingSet[] getWorkingSets(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(2);
        int n = 0;
        while (n < stringArray.length) {
            IWorkingSet iWorkingSet = this.getWorkingSetManager().getWorkingSet(stringArray[n]);
            if (iWorkingSet != null) {
                hashSet.add(iWorkingSet);
            }
            ++n;
        }
        return hashSet.toArray(new IWorkingSet[hashSet.size()]);
    }

    protected void setSelected(SearchScopeAction searchScopeAction, boolean bl) {
        if (!bl || searchScopeAction.isChecked()) {
            this.fSelectedWorkingSetNames = searchScopeAction instanceof SearchScopeWorkingSetAction ? this.getWorkingSetNames(((SearchScopeWorkingSetAction)searchScopeAction).getWorkingSets()) : null;
            this.fSelectedAction = searchScopeAction != null ? searchScopeAction : this.fSearchScopeWorkspaceAction;
            this.fDialogSettings.put(DIALOGSTORE_SCOPE_TYPE, this.getSearchScopeType());
            this.fDialogSettings.put(DIALOGSTORE_SELECTED_WORKING_SET, this.fSelectedWorkingSetNames);
        }
    }

    protected CallHierarchyViewPart getView() {
        return this.fView;
    }

    protected IWorkingSetManager getWorkingSetManager() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        return iWorkingSetManager;
    }

    protected void fillSearchActions(IMenuManager iMenuManager) {
        Action[] actionArray = this.getActions();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            if (action.isEnabled()) {
                iMenuManager.add((IAction)action);
            }
            ++n;
        }
        iMenuManager.setVisible(!iMenuManager.isEmpty());
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.search"));
        MenuManager menuManager = new MenuManager(CallHierarchyMessages.SearchScopeActionGroup_searchScope, "group.search");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                SearchScopeActionGroup.this.fillSearchActions(iMenuManager);
            }
        });
        this.fillSearchActions((IMenuManager)menuManager);
        iMenuManager.appendToGroup("group.search", (IContributionItem)menuManager);
    }

    private Action[] getActions() {
        IWorkingSet[] iWorkingSetArray;
        ArrayList<SearchScopeWorkingSetAction> arrayList = new ArrayList<SearchScopeWorkingSetAction>(SearchUtil.LRU_WORKINGSET_LIST_SIZE + 4);
        this.addAction(arrayList, this.fSearchScopeWorkspaceAction);
        this.addAction(arrayList, this.fSearchScopeProjectAction);
        this.addAction(arrayList, this.fSearchScopeHierarchyAction);
        this.addAction(arrayList, this.fSelectWorkingSetAction);
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            iWorkingSetArray = (IWorkingSet[])iterator.next();
            String string = SearchUtil.toString(iWorkingSetArray);
            SearchScopeWorkingSetAction searchScopeWorkingSetAction = new SearchScopeWorkingSetAction(this, iWorkingSetArray, string);
            if (this.isSelectedWorkingSet(iWorkingSetArray)) {
                searchScopeWorkingSetAction.setChecked(true);
            }
            arrayList.add(searchScopeWorkingSetAction);
        }
        iWorkingSetArray = arrayList.toArray(new Action[arrayList.size()]);
        this.ensureExactlyOneCheckedAction((Action[])iWorkingSetArray);
        return iWorkingSetArray;
    }

    private void ensureExactlyOneCheckedAction(Action[] actionArray) {
        int n = this.getCheckedActionCount(actionArray);
        if (n != 1) {
            if (n > 1) {
                int n2 = 0;
                while (n2 < actionArray.length) {
                    Action action = actionArray[n2];
                    action.setChecked(false);
                    ++n2;
                }
            }
            this.fSearchScopeWorkspaceAction.setChecked(true);
        }
    }

    private int getCheckedActionCount(Action[] actionArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < actionArray.length) {
            Action action = actionArray[n2];
            if (action.isChecked()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void addAction(List list, Action action) {
        if (action == this.fSelectedAction) {
            action.setChecked(true);
        } else {
            action.setChecked(false);
        }
        list.add(action);
    }

    private void createActions() {
        int n;
        this.fSearchScopeWorkspaceAction = new SearchScopeWorkspaceAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this);
        this.fSearchScopeHierarchyAction = new SearchScopeHierarchyAction(this);
        this.fSearchScopeProjectAction = new SearchScopeProjectAction(this);
        try {
            n = this.fDialogSettings.getInt(DIALOGSTORE_SCOPE_TYPE);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        String[] stringArray = this.fDialogSettings.getArray(DIALOGSTORE_SELECTED_WORKING_SET);
        this.setSelected(this.getSearchScopeAction(n, stringArray), false);
    }

    public void saveState(IMemento iMemento) {
        int n = this.getSearchScopeType();
        iMemento.putInteger(TAG_SEARCH_SCOPE_TYPE, n);
        if (n == 4) {
            iMemento.putInteger(TAG_WORKING_SET_COUNT, this.fSelectedWorkingSetNames.length);
            int n2 = 0;
            while (n2 < this.fSelectedWorkingSetNames.length) {
                String string = this.fSelectedWorkingSetNames[n2];
                iMemento.putString(TAG_SELECTED_WORKING_SET + n2, string);
                ++n2;
            }
        }
    }

    public void restoreState(IMemento iMemento) {
        String[] stringArray = null;
        Integer n = iMemento.getInteger(TAG_SEARCH_SCOPE_TYPE);
        if (n != null) {
            Integer n2;
            if (n == 4 && (n2 = iMemento.getInteger(TAG_WORKING_SET_COUNT)) != null) {
                stringArray = new String[n2.intValue()];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = iMemento.getString(TAG_SELECTED_WORKING_SET + n3);
                    ++n3;
                }
            }
            this.setSelected(this.getSearchScopeAction(n, stringArray), false);
        }
    }

    private SearchScopeAction getSearchScopeAction(int n, String[] stringArray) {
        switch (n) {
            case 1: {
                return this.fSearchScopeWorkspaceAction;
            }
            case 2: {
                return this.fSearchScopeProjectAction;
            }
            case 3: {
                return this.fSearchScopeHierarchyAction;
            }
            case 4: {
                IWorkingSet[] iWorkingSetArray = this.getWorkingSets(stringArray);
                if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                    return new SearchScopeWorkingSetAction(this, iWorkingSetArray, this.getScopeDescription(iWorkingSetArray));
                }
                return null;
            }
        }
        return null;
    }

    private int getSearchScopeType() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScopeType();
        }
        return 0;
    }

    private String getScopeDescription(IWorkingSet[] iWorkingSetArray) {
        return Messages.format(CallHierarchyMessages.WorkingSetScope, new String[]{SearchUtil.toString(iWorkingSetArray)});
    }

    private boolean isSelectedWorkingSet(IWorkingSet[] iWorkingSetArray) {
        if (this.fSelectedWorkingSetNames != null && this.fSelectedWorkingSetNames.length == iWorkingSetArray.length) {
            HashSet<String> hashSet = new HashSet<String>(iWorkingSetArray.length);
            int n = 0;
            while (n < iWorkingSetArray.length) {
                hashSet.add(iWorkingSetArray[n].getName());
                ++n;
            }
            n = 0;
            while (n < this.fSelectedWorkingSetNames.length) {
                if (!hashSet.contains(this.fSelectedWorkingSetNames[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String getFullDescription() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getFullDescription();
        }
        return null;
    }
}

