/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

abstract class JavaHistoryActionImpl {
    private boolean fModifiesFile;
    private ISelection fSelection;
    private JavaEditor fEditor;
    private String fTitle;
    private String fMessage;

    JavaHistoryActionImpl(boolean bl) {
        this.fModifiesFile = bl;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    final IFile getFile(Object object) {
        return JavaElementHistoryPageSource.getInstance().getFile(object);
    }

    final ITypedElement[] buildEditions(ITypedElement iTypedElement, IFile iFile) {
        IFileState[] iFileStateArray = null;
        try {
            iFileStateArray = iFile.getHistory(null);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        int n = 1;
        if (iFileStateArray != null) {
            n += iFileStateArray.length;
        }
        ITypedElement[] iTypedElementArray = new ITypedElement[n];
        iTypedElementArray[0] = new ResourceNode((IResource)iFile);
        if (iFileStateArray != null) {
            int n2 = 0;
            while (n2 < iFileStateArray.length) {
                iTypedElementArray[n2 + 1] = new HistoryItem(iTypedElement, iFileStateArray[n2]);
                ++n2;
            }
        }
        return iTypedElementArray;
    }

    final Shell getShell() {
        if (this.fEditor != null) {
            return this.fEditor.getEditorSite().getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    final IJavaElement getWorkingCopy(IJavaElement iJavaElement) {
        return iJavaElement;
    }

    final ASTNode getBodyContainer(CompilationUnit compilationUnit, IMember iMember) throws JavaModelException {
        ISourceRange iSourceRange = iMember.getNameRange();
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iSourceRange);
        do {
            if (!(aSTNode instanceof TypeDeclaration) && !(aSTNode instanceof EnumDeclaration) && !(aSTNode instanceof AnnotationTypeDeclaration)) continue;
            return aSTNode;
        } while ((aSTNode = aSTNode.getParent()) != null);
        return null;
    }

    final boolean beingEdited(IFile iFile) {
        FileEditorInput fileEditorInput;
        ICompilationUnitDocumentProvider iCompilationUnitDocumentProvider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        return iCompilationUnitDocumentProvider.getDocument(fileEditorInput = new FileEditorInput(iFile)) != null;
    }

    final IMember getEditionElement(ISelection iSelection) {
        IMember iMember;
        Object object;
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IMember && (iMember = (IMember)object).exists() && !iMember.isBinary() && JavaStructureCreator.hasEdition((IJavaElement)iMember)) {
            return iMember;
        }
        return null;
    }

    final boolean isEnabled(IFile iFile) {
        if (iFile == null || !iFile.exists()) {
            return false;
        }
        if (this.fModifiesFile) {
            return true;
        }
        return true;
    }

    boolean isEnabled(ISelection iSelection) {
        IMember iMember = this.getEditionElement(iSelection);
        if (iMember == null) {
            return false;
        }
        IFile iFile = this.getFile(iMember);
        return this.isEnabled(iFile);
    }

    void applyChanges(ASTRewrite aSTRewrite, IDocument iDocument, final ITextFileBuffer iTextFileBuffer, Shell shell, boolean bl, Map map) throws CoreException, InvocationTargetException, InterruptedException {
        Object object;
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        try {
            object = aSTRewrite.rewriteAST(iDocument, map);
            multiTextEdit.addChildren(object.removeChildren());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JavaPlugin.log(illegalArgumentException);
        }
        try {
            new RewriteSessionEditProcessor(iDocument, (TextEdit)multiTextEdit, 2).performEdits();
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        object = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    iTextFileBuffer.commit(iProgressMonitor, false);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        if (bl) {
            object.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)object);
        }
    }

    static String trimTextBlock(String string, String string2, IJavaProject iJavaProject) {
        String[] stringArray;
        if (string != null && (stringArray = Strings.convertIntoLines(string)) != null) {
            Strings.trimIndentation(stringArray, iJavaProject);
            return Strings.concatenate(stringArray, string2);
        }
        return null;
    }

    final JavaEditor getEditor(IFile iFile) {
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        IWorkbench iWorkbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    JavaEditor javaEditor;
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    if (iEditorPart instanceof JavaEditor && fileEditorInput.equals((Object)(javaEditor = (JavaEditor)iEditorPart).getEditorInput())) {
                        return (JavaEditor)iEditorPart;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public abstract void run(ISelection var1);

    void init(JavaEditor javaEditor, String string, String string2) {
        this.fEditor = javaEditor;
        this.fTitle = string;
        this.fMessage = string2;
    }

    final JavaEditor getEditor() {
        return this.fEditor;
    }

    public final void runFromEditor(IAction iAction) {
        IJavaElement iJavaElement = null;
        try {
            iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {}
        this.fSelection = iJavaElement != null ? new StructuredSelection((Object)iJavaElement) : StructuredSelection.EMPTY;
        boolean bl = this.isEnabled(this.fSelection);
        iAction.setEnabled(bl);
        if (!bl) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.fTitle, (String)this.fMessage);
            return;
        }
        this.run(this.fSelection);
    }

    boolean checkEnabled() {
        ICompilationUnit iCompilationUnit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IFile iFile = this.getFile(iCompilationUnit);
        return this.isEnabled(iFile);
    }

    public final void update(IAction iAction) {
        iAction.setEnabled(this.checkEnabled());
    }

    public final void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection;
        iAction.setEnabled(this.isEnabled(iSelection));
    }

    public final void run(IAction iAction) {
        this.run(this.fSelection);
    }

    static CompilationUnit parsePartialCompilationUnit(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null) {
            throw new IllegalArgumentException();
        }
        try {
            ASTParser aSTParser = ASTParser.newParser((int)3);
            aSTParser.setSource(iCompilationUnit);
            aSTParser.setFocalPosition(0);
            aSTParser.setResolveBindings(false);
            aSTParser.setWorkingCopyOwner(null);
            ASTNode aSTNode = aSTParser.createAST(null);
            return (CompilationUnit)aSTNode;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }
}

