/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class JdtViewerDropAdapter
implements DropTargetListener {
    public static final int LOCATION_NONE = 0;
    public static final int LOCATION_ON = 1;
    public static final int LOCATION_BEFORE = 2;
    public static final int LOCATION_AFTER = 4;
    private static final int LOCATION_EPSILON = 5;
    private static final int ITEM_MARGIN_LEFT = 40;
    private static final int ITEM_MARGIN_RIGTH = 10;
    public static final int INSERTION_FEEDBACK = 2;
    private StructuredViewer fViewer;
    private int fFeedback;
    private boolean fShowInsertionFeedback;
    private boolean fFullWidthMatchesItem;
    private int fRequestedOperation;
    private int fLastOperation;
    protected int fLocation;
    protected Object fTarget;

    public JdtViewerDropAdapter(StructuredViewer structuredViewer, int n) {
        Assert.isNotNull((Object)structuredViewer);
        this.fViewer = structuredViewer;
        this.fFeedback = n;
        this.fLastOperation = -1;
        this.fFullWidthMatchesItem = true;
    }

    public void showInsertionFeedback(boolean bl) {
        this.fShowInsertionFeedback = bl;
    }

    protected void setFullWidthMatchesItem(boolean bl) {
        this.fFullWidthMatchesItem = bl;
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        this.drop(this.fTarget, dropTargetEvent);
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
    }

    public void validateDrop(DropTargetEvent dropTargetEvent) {
        this.validateDrop(this.fTarget, dropTargetEvent, this.fRequestedOperation);
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.dragOperationChanged(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.fTarget = null;
        this.fLocation = 0;
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.fRequestedOperation = dropTargetEvent.detail;
        this.fTarget = this.computeTarget(dropTargetEvent);
        this.fLocation = this.computeLocation(dropTargetEvent);
        this.validateDrop(dropTargetEvent);
        this.fLastOperation = dropTargetEvent.detail;
        this.computeFeedback(dropTargetEvent);
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Object object = this.fTarget;
        this.fTarget = this.computeTarget(dropTargetEvent);
        int n = this.fLocation;
        this.fLocation = this.computeLocation(dropTargetEvent);
        if (n != this.fLocation || object != this.fTarget || this.fLastOperation != dropTargetEvent.detail) {
            this.validateDrop(dropTargetEvent);
            this.fLastOperation = dropTargetEvent.detail;
        } else {
            dropTargetEvent.detail = this.fLastOperation;
        }
        this.computeFeedback(dropTargetEvent);
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        this.fTarget = this.computeTarget(dropTargetEvent);
        this.validateDrop(dropTargetEvent);
        this.fLastOperation = dropTargetEvent.detail;
    }

    protected Object computeTarget(DropTargetEvent dropTargetEvent) {
        if (dropTargetEvent.item == null) {
            return null;
        }
        if (!this.fFullWidthMatchesItem) {
            Point point = this.fViewer.getControl().toControl(new Point(dropTargetEvent.x, dropTargetEvent.y));
            Rectangle rectangle = this.getBounds((Item)dropTargetEvent.item);
            if (point.x < rectangle.x - 40 || point.x >= rectangle.x + rectangle.width + 10) {
                dropTargetEvent.item = null;
                return null;
            }
        }
        return dropTargetEvent.item.getData();
    }

    protected int computeLocation(DropTargetEvent dropTargetEvent) {
        if (!(dropTargetEvent.item instanceof Item)) {
            return 0;
        }
        Item item = (Item)dropTargetEvent.item;
        Point point = this.fViewer.getControl().toControl(new Point(dropTargetEvent.x, dropTargetEvent.y));
        Rectangle rectangle = this.getBounds(item);
        if (rectangle == null) {
            return 0;
        }
        if (point.y - rectangle.y < 5) {
            return 2;
        }
        if (rectangle.y + rectangle.height - point.y < 5) {
            return 4;
        }
        return 1;
    }

    private Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected void computeFeedback(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.feedback = !this.fShowInsertionFeedback && this.fLocation != 0 ? 1 : this.fLocation;
        dropTargetEvent.feedback |= this.fFeedback;
    }

    protected void clearDropOperation(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 0;
    }

    protected int getRequestedOperation() {
        return this.fRequestedOperation;
    }

    protected void setDefaultFeedback(int n) {
        this.fFeedback = n;
    }

    public void internalTestSetLocation(int n) {
        this.fLocation = n;
    }
}

