/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpConstants;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpRefactoringWizard;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpSaveParticipantConfigurationModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeFormatingTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeStyleTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.UnnecessaryCodeTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.xml.sax.InputSource;

public class CleanUpRefactoringWizard
extends RefactoringWizard {
    private static final String USE_CUSTOM_PROFILE_KEY = "org.eclipse.wst.jsdt.ui.cleanup.use_dialog_profile";
    private static final String CUSTOM_PROFILE_KEY = "org.eclipse.wst.jsdt.ui.cleanup.custom_profile";

    public CleanUpRefactoringWizard(CleanUpRefactoring cleanUpRefactoring, int n) {
        super((Refactoring)cleanUpRefactoring, n);
        this.setDefaultPageTitle(MultiFixMessages.CleanUpRefactoringWizard_PageTitle);
        this.setWindowTitle(MultiFixMessages.CleanUpRefactoringWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_CLEAN_UP);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new CleanUpConfigurationPage((CleanUpRefactoring)this.getRefactoring()));
    }

    private static class CleanUpConfigurationPage
    extends UserInputWizardPage
    implements ModifyDialogTabPage.IModificationListener {
        private static final String ENCODING = "UTF-8";
        private final CleanUpRefactoring fCleanUpRefactoring;
        private Map fCustomSettings;
        private SelectionButtonDialogField fUseCustomField;
        private ControlEnableState fEnableState;

        public CleanUpConfigurationPage(CleanUpRefactoring cleanUpRefactoring) {
            super(MultiFixMessages.CleanUpRefactoringWizard_CleanUpConfigurationPage_title);
            this.fCleanUpRefactoring = cleanUpRefactoring;
            ICompilationUnit[] iCompilationUnitArray = this.fCleanUpRefactoring.getCompilationUnits();
            IJavaProject[] iJavaProjectArray = this.fCleanUpRefactoring.getProjects();
            if (iCompilationUnitArray.length == 1) {
                this.setMessage(MultiFixMessages.CleanUpRefactoringWizard_CleaningUp11_Title);
            } else if (iJavaProjectArray.length == 1) {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpN1_Title, new Integer(iCompilationUnitArray.length)));
            } else {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpNN_Title, new Object[]{new Integer(iCompilationUnitArray.length), new Integer(iJavaProjectArray.length)}));
            }
        }

        public void createControl(Composite composite) {
            boolean bl = this.getDialogSettings().getBoolean(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY);
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            composite2.setFont(composite.getFont());
            SelectionButtonDialogField selectionButtonDialogField = new SelectionButtonDialogField(16);
            selectionButtonDialogField.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_configured_radio);
            selectionButtonDialogField.setSelection(!bl);
            selectionButtonDialogField.doFillIntoGrid(composite2, 2);
            ProjectProfileLableProvider projectProfileLableProvider = new ProjectProfileLableProvider();
            ProfileTableAdapter profileTableAdapter = new ProfileTableAdapter(projectProfileLableProvider, this.getShell());
            String[] stringArray = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Configure_Button};
            ListDialogField listDialogField = new ListDialogField(profileTableAdapter, stringArray, (ILabelProvider)projectProfileLableProvider);
            String[] stringArray2 = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Project_TableHeader, MultiFixMessages.CleanUpRefactoringWizard_Profile_TableHeader};
            ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(1, 100, true), new ColumnWeightData(2, 20, true)};
            listDialogField.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDataArray, stringArray2, true));
            listDialogField.setViewerComparator(new ViewerComparator());
            listDialogField.doFillIntoGrid(composite2, 3);
            Table table = listDialogField.getTableViewer().getTable();
            GridData gridData = (GridData)listDialogField.getListControl(null).getLayoutData();
            gridData.horizontalIndent = 15;
            gridData.grabExcessVerticalSpace = false;
            gridData.heightHint = SWTUtil.getTableHeightHint(table, Math.min(5, this.fCleanUpRefactoring.getProjects().length + 1));
            gridData.grabExcessHorizontalSpace = true;
            gridData.verticalAlignment = 1;
            gridData = (GridData)listDialogField.getButtonBox(null).getLayoutData();
            gridData.grabExcessVerticalSpace = false;
            gridData.verticalAlignment = 1;
            gridData = (GridData)listDialogField.getLabelControl(null).getLayoutData();
            gridData.exclude = true;
            listDialogField.setElements(Arrays.asList(this.fCleanUpRefactoring.getProjects()));
            listDialogField.selectFirstElement();
            this.fUseCustomField = new SelectionButtonDialogField(16);
            this.fUseCustomField.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_custom_radio);
            this.fUseCustomField.setSelection(bl);
            this.fUseCustomField.doFillIntoGrid(composite2, 2);
            String string = this.getDialogSettings().get(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY);
            if (string == null) {
                this.fCustomSettings = CleanUpConstants.getEclipseDefaultSettings();
            } else {
                try {
                    this.fCustomSettings = this.decodeSettings(string);
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                    this.fCustomSettings = CleanUpConstants.getEclipseDefaultSettings();
                }
            }
            BulletListBlock bulletListBlock = new BulletListBlock();
            Control control = bulletListBlock.createControl(composite2);
            GridData gridData2 = (GridData)control.getLayoutData();
            gridData2.horizontalIndent = 15;
            gridData2.grabExcessVerticalSpace = true;
            Button button = new Button(composite2, 0);
            button.setText(MultiFixMessages.CleanUpRefactoringWizard_ConfigureCustomProfile_button);
            gridData = new GridData(128, 16384, false, false);
            gridData.widthHint = SWTUtil.getButtonWidthHint(button);
            button.setLayoutData((Object)gridData);
            this.showCustomSettings(bulletListBlock);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, bulletListBlock){
                final /* synthetic */ CleanUpConfigurationPage this$1;
                private final /* synthetic */ BulletListBlock val$bulletListBlock;
                {
                    this.this$1 = cleanUpConfigurationPage;
                    this.val$bulletListBlock = bulletListBlock;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CleanUpSaveParticipantConfigurationModifyDialog cleanUpSaveParticipantConfigurationModifyDialog = new CleanUpSaveParticipantConfigurationModifyDialog(this, this.this$1.getShell(), CleanUpConfigurationPage.access$0(this.this$1), MultiFixMessages.CleanUpRefactoringWizard_CustomCleanUpsDialog_title){
                        final /* synthetic */ 1 this$2;
                        {
                            super(shell, map, string);
                            this.this$2 = var1_1;
                        }

                        protected CleanUpTabPage[] createTabPages(Map map) {
                            CleanUpTabPage[] cleanUpTabPageArray = new CleanUpTabPage[]{new CodeStyleTabPage(this, map, false), new UnnecessaryCodeTabPage(this, map, false), new CodeFormatingTabPage(this, map, false)};
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_code_style_tab, cleanUpTabPageArray[0]);
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_unnecessary_code_tab, cleanUpTabPageArray[1]);
                            this.addTabPage(MultiFixMessages.CleanUpRefactoringWizard_code_organizing_tab, cleanUpTabPageArray[2]);
                            return cleanUpTabPageArray;
                        }
                    };
                    cleanUpSaveParticipantConfigurationModifyDialog.open();
                    CleanUpConfigurationPage.access$1(this.this$1, this.val$bulletListBlock);
                }
            });
            this.updateEnableState(bl, listDialogField, button, bulletListBlock);
            this.fUseCustomField.setDialogFieldListener(new IDialogFieldListener(this, listDialogField, button, bulletListBlock){
                final /* synthetic */ CleanUpConfigurationPage this$1;
                private final /* synthetic */ ListDialogField val$settingsField;
                private final /* synthetic */ Button val$configure;
                private final /* synthetic */ BulletListBlock val$bulletListBlock;
                {
                    this.this$1 = cleanUpConfigurationPage;
                    this.val$settingsField = listDialogField;
                    this.val$configure = button;
                    this.val$bulletListBlock = bulletListBlock;
                }

                public void dialogFieldChanged(DialogField dialogField) {
                    CleanUpConfigurationPage.access$3(this.this$1, CleanUpConfigurationPage.access$2(this.this$1).isSelected(), this.val$settingsField, this.val$configure, this.val$bulletListBlock);
                }
            });
            Link link = new Link(composite2, 64);
            link.setText(MultiFixMessages.CleanUpRefactoringWizard_HideWizard_Link);
            link.setFont(composite.getFont());
            GridData gridData3 = new GridData(4, 4, true, false);
            gridData3.widthHint = this.convertWidthInCharsToPixels(300);
            gridData3.horizontalSpan = 2;
            link.setLayoutData((Object)gridData3);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this, composite2){
                final /* synthetic */ CleanUpConfigurationPage this$1;
                private final /* synthetic */ Composite val$composite;
                {
                    this.this$1 = cleanUpConfigurationPage;
                    this.val$composite = composite;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)this.val$composite.getShell(), (String)"org.eclipse.wst.jsdt.ui.preferences.CleanUpPreferencePage", null, null).open();
                }
            });
            this.setControl((Control)composite2);
            Dialog.applyDialogFont((Control)composite2);
        }

        private void updateEnableState(boolean bl, ListDialogField listDialogField, Button button, BulletListBlock bulletListBlock) {
            listDialogField.getListControl(null).setEnabled(!bl);
            if (bl) {
                this.fEnableState = ControlEnableState.disable((Control)listDialogField.getButtonBox(null));
            } else if (this.fEnableState != null) {
                this.fEnableState.restore();
                this.fEnableState = null;
            }
            bulletListBlock.setEnabled(bl);
            button.setEnabled(bl);
        }

        private void showCustomSettings(BulletListBlock bulletListBlock) {
            StringBuffer stringBuffer = new StringBuffer();
            ICleanUp[] iCleanUpArray = CleanUpRefactoring.createCleanUps(this.fCustomSettings);
            int n = 0;
            while (n < iCleanUpArray.length) {
                String[] stringArray = iCleanUpArray[n].getDescriptions();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append('\n');
                        }
                        stringBuffer.append(stringArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            bulletListBlock.setText(stringBuffer.toString());
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
            this.getDialogSettings().put(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY, this.fUseCustomField.isSelected());
            try {
                this.getDialogSettings().put(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY, this.encodeSettings(this.fCustomSettings));
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }

        private void initializeRefactoring() {
            ICleanUp[] iCleanUpArray = this.fUseCustomField.isSelected() ? CleanUpRefactoring.createCleanUps(this.fCustomSettings) : CleanUpRefactoring.createCleanUps();
            CleanUpRefactoring cleanUpRefactoring = (CleanUpRefactoring)this.getRefactoring();
            cleanUpRefactoring.clearCleanUps();
            int n = 0;
            while (n < iCleanUpArray.length) {
                cleanUpRefactoring.addCleanUp(iCleanUpArray[n]);
                ++n;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String encodeSettings(Map map) throws CoreException {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
            try {
                CleanUpProfileVersioner cleanUpProfileVersioner = new CleanUpProfileVersioner();
                ProfileManager.CustomProfile customProfile = new ProfileManager.CustomProfile("custom", map, cleanUpProfileVersioner.getCurrentVersion(), cleanUpProfileVersioner.getProfileKind());
                ArrayList<ProfileManager.CustomProfile> arrayList = new ArrayList<ProfileManager.CustomProfile>();
                arrayList.add(customProfile);
                ProfileStore.writeProfilesToStream(arrayList, byteArrayOutputStream, ENCODING, cleanUpProfileVersioner);
                try {
                    string = byteArrayOutputStream.toString(ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string2 = byteArrayOutputStream.toString();
                    Object var6_9 = null;
                    try {
                        byteArrayOutputStream.close();
                        return string2;
                    }
                    catch (IOException iOException) {}
                    return string2;
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                byteArrayOutputStream.close();
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            byteArrayOutputStream.close();
            return string;
        }

        public Map decodeSettings(String string) throws CoreException {
            List list;
            ByteArrayInputStream byteArrayInputStream;
            block9: {
                Map map;
                byte[] byArray;
                try {
                    byArray = string.getBytes(ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    list = ProfileStore.readProfilesFromStream(new InputSource(byteArrayInputStream));
                    if (list != null && list.size() != 0) break block9;
                    map = CleanUpConstants.getEclipseDefaultSettings();
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
                return map;
            }
            ProfileManager.CustomProfile customProfile = (ProfileManager.CustomProfile)list.get(0);
            new CleanUpProfileVersioner().update(customProfile);
            Map map = customProfile.getSettings();
            Object var6_8 = null;
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
            return map;
        }

        public void updateStatus(IStatus iStatus) {
        }

        public void valuesModified() {
        }

        static /* synthetic */ Map access$0(CleanUpConfigurationPage cleanUpConfigurationPage) {
            return cleanUpConfigurationPage.fCustomSettings;
        }

        static /* synthetic */ void access$1(CleanUpConfigurationPage cleanUpConfigurationPage, BulletListBlock bulletListBlock) {
            cleanUpConfigurationPage.showCustomSettings(bulletListBlock);
        }

        static /* synthetic */ SelectionButtonDialogField access$2(CleanUpConfigurationPage cleanUpConfigurationPage) {
            return cleanUpConfigurationPage.fUseCustomField;
        }

        static /* synthetic */ void access$3(CleanUpConfigurationPage cleanUpConfigurationPage, boolean bl, ListDialogField listDialogField, Button button, BulletListBlock bulletListBlock) {
            cleanUpConfigurationPage.updateEnableState(bl, listDialogField, button, bulletListBlock);
        }

        private static final class ProfileTableAdapter
        implements IListAdapter {
            private final ProjectProfileLableProvider fProvider;
            private final Shell fShell;

            private ProfileTableAdapter(ProjectProfileLableProvider projectProfileLableProvider, Shell shell) {
                this.fProvider = projectProfileLableProvider;
                this.fShell = shell;
            }

            public void customButtonPressed(ListDialogField listDialogField, int n) {
                this.openPropertyDialog(listDialogField);
            }

            public void doubleClicked(ListDialogField listDialogField) {
                this.openPropertyDialog(listDialogField);
            }

            private void openPropertyDialog(ListDialogField listDialogField) {
                IJavaProject iJavaProject = (IJavaProject)listDialogField.getSelectedElements().get(0);
                PreferencesUtil.createPropertyDialogOn((Shell)this.fShell, (IAdaptable)iJavaProject, (String)"org.eclipse.wst.jsdt.ui.propertyPages.CleanUpPreferencePage", null, null).open();
                List list = listDialogField.getSelectedElements();
                this.fProvider.reset();
                listDialogField.refresh();
                listDialogField.selectElements((ISelection)new StructuredSelection(list));
            }

            public void selectionChanged(ListDialogField listDialogField) {
                if (listDialogField.getSelectedElements().size() != 1) {
                    listDialogField.enableButton(0, false);
                } else {
                    listDialogField.enableButton(0, true);
                }
            }
        }
    }

    private static class ProjectProfileLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable fProfileIdsTable;

        private ProjectProfileLableProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (n == 0) {
                return ((IJavaProject)object).getProject().getName();
            }
            if (n == 1) {
                InstanceScope instanceScope;
                IEclipsePreferences iEclipsePreferences;
                if (this.fProfileIdsTable == null) {
                    this.fProfileIdsTable = this.loadProfiles();
                }
                String string = (iEclipsePreferences = (instanceScope = new InstanceScope()).getNode("org.eclipse.wst.jsdt.ui")).get("cleanup_profile", null) != null ? iEclipsePreferences.get("cleanup_profile", null) : "org.eclipse.wst.jsdt.ui.default.eclipse_clean_up_profile";
                return this.getProjectProfileName((IJavaProject)object, this.fProfileIdsTable, string);
            }
            return null;
        }

        private Hashtable loadProfiles() {
            List list = CleanUpPreferenceUtil.loadProfiles((IScopeContext)new InstanceScope());
            Hashtable<String, ProfileManager.Profile> hashtable = new Hashtable<String, ProfileManager.Profile>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ProfileManager.Profile profile = (ProfileManager.Profile)iterator.next();
                hashtable.put(profile.getID(), profile);
            }
            return hashtable;
        }

        private String getProjectProfileName(IJavaProject iJavaProject, Hashtable hashtable, String string) {
            ProjectScope projectScope = new ProjectScope(iJavaProject.getProject());
            IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.wst.jsdt.ui");
            String string2 = iEclipsePreferences.get("cleanup_profile", null);
            if (string2 == null) {
                ProfileManager.Profile profile = (ProfileManager.Profile)hashtable.get(string);
                if (profile != null) {
                    return profile.getName();
                }
                return MultiFixMessages.CleanUpRefactoringWizard_unknownProfile_Name;
            }
            ProfileManager.Profile profile = (ProfileManager.Profile)hashtable.get(string2);
            if (profile != null) {
                return profile.getName();
            }
            return Messages.format(MultiFixMessages.CleanUpRefactoringWizard_UnmanagedProfileWithName_Name, string2.substring("_".length()));
        }

        public void reset() {
            this.fProfileIdsTable = null;
        }
    }
}

