/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.SortMembersFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class SortMembersCleanUp
extends AbstractCleanUp {
    private HashSet fTouchedFiles;

    public SortMembersCleanUp() {
    }

    public SortMembersCleanUp(Map map) {
        super(map);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean bl;
        if (compilationUnit == null) {
            return null;
        }
        IFix iFix = SortMembersFix.createCleanUp(compilationUnit, bl, (bl = this.isEnabled("cleanup.sort_members")) && this.isEnabled("cleanup.sort_members_all"));
        if (iFix != null) {
            if (this.fTouchedFiles == null) {
                this.fTouchedFiles = new HashSet();
            }
            this.fTouchedFiles.add(((ICompilationUnit)compilationUnit.getJavaElement()).getResource());
        }
        return iFix;
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        if (this.fTouchedFiles == null) {
            return super.checkPostConditions(iProgressMonitor);
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", this.fTouchedFiles.size());
        try {
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            Iterator iterator = this.fTouchedFiles.iterator();
            while (iterator.hasNext()) {
                IFile iFile = (IFile)iterator.next();
                if (SortMembersCleanUp.containsRelevantMarkers(iFile)) {
                    String string = iFile.getProjectRelativePath().toOSString();
                    String string2 = iFile.getProject().getName();
                    refactoringStatus2.addWarning(MessageFormat.format((String)MultiFixMessages.SortMembersCleanUp_RemoveMarkersWarning0, (Object[])new Object[]{string, string2}));
                }
                iProgressMonitor.worked(1);
            }
            refactoringStatus = refactoringStatus2;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iProgressMonitor.done();
            this.fTouchedFiles = null;
            throw throwable;
        }
        iProgressMonitor.done();
        this.fTouchedFiles = null;
        return refactoringStatus;
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        if (this.isEnabled("cleanup.sort_members")) {
            if (this.isEnabled("cleanup.sort_members_all")) {
                return new String[]{MultiFixMessages.SortMembersCleanUp_AllMembers_description};
            }
            return new String[]{MultiFixMessages.SortMembersCleanUp_Excluding_description};
        }
        return null;
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class SortExample {\n");
        if (this.isEnabled("cleanup.sort_members") && this.isEnabled("cleanup.sort_members_all")) {
            stringBuffer.append("  private String bar;\n");
            stringBuffer.append("  private String foo;\n");
        } else {
            stringBuffer.append("  private String foo;\n");
            stringBuffer.append("  private String bar;\n");
        }
        if (this.isEnabled("cleanup.sort_members")) {
            stringBuffer.append("  private void bar() {}\n");
            stringBuffer.append("  private void foo() {}\n");
        } else {
            stringBuffer.append("  private void foo() {}\n");
            stringBuffer.append("  private void bar() {}\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        return false;
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        return this.isEnabled("cleanup.sort_members");
    }

    private static boolean containsRelevantMarkers(IFile iFile) throws CoreException {
        IMarker[] iMarkerArray = iFile.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
        if (iMarkerArray.length != 0) {
            return true;
        }
        IMarker[] iMarkerArray2 = iFile.findMarkers("org.eclipse.core.resources.taskmarker", true, 2);
        if (iMarkerArray2.length != 0) {
            return true;
        }
        IMarker[] iMarkerArray3 = iFile.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        return iMarkerArray3.length != 0;
    }
}

