/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarimport;

import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.filters.EmptyPackageFilter;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportData;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.wst.jsdt.internal.ui.jarimport.RefactoringLocationControl;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public final class JarImportWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "JarImportWizardPage";
    protected static final String SETTING_HISTORY = "org.eclipse.wst.jsdt.ui.refactoring.jarHistory";
    private boolean fFirstTime = true;
    private final boolean fImportWizard;
    private RefactoringLocationControl fLocationControl = null;
    private TreeViewer fTreeViewer = null;
    private final JarImportWizard fWizard;

    public JarImportWizardPage(JarImportWizard jarImportWizard, boolean bl) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)jarImportWizard));
        this.fWizard = jarImportWizard;
        this.fImportWizard = bl;
        if (this.fImportWizard) {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_description);
        } else {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_replace_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_replace_description);
        }
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createLocationGroup(composite2);
        if (this.fImportWizard) {
            this.createInputGroup(composite2);
        }
        this.createRenameGroup(composite2);
        this.setPageComplete(false);
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setMessage(JarImportMessages.JarImportWizardPage_no_jar_files, 1);
        }
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.jar_import_wizard_page_context");
    }

    protected GridData createGridData(int n, int n2, int n3) {
        GridData gridData = new GridData(n);
        gridData.horizontalIndent = n3;
        gridData.horizontalSpan = n2;
        return gridData;
    }

    protected void createInputGroup(Composite composite) {
        Assert.isNotNull((Object)composite);
        new Label(composite, 0);
        Label label = new Label(composite, 0);
        label.setText(JarImportMessages.JarImportWizardPage_import_message);
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof IJavaProject || object instanceof IJavaModel) {
                    return super.getChildren(object);
                }
                return new Object[0];
            }

            protected Object[] getJavaProjects(IJavaModel iJavaModel) throws JavaModelException {
                HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
                IJavaProject[] iJavaProjectArray = iJavaModel.getJavaProjects();
                int n = 0;
                while (n < iJavaProjectArray.length) {
                    Object[] objectArray;
                    if (JarImportWizard.isValidJavaProject(iJavaProjectArray[n]) && (objectArray = this.getPackageFragmentRoots(iJavaProjectArray[n])).length > 0) {
                        hashSet.add(iJavaProjectArray[n]);
                    }
                    ++n;
                }
                return hashSet.toArray();
            }

            protected Object[] getPackageFragmentRoots(IJavaProject iJavaProject) throws JavaModelException {
                HashSet<IPackageFragmentRoot> hashSet = new HashSet<IPackageFragmentRoot>();
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                int n = 0;
                while (n < iPackageFragmentRootArray.length) {
                    if (JarImportWizard.isValidClassPathEntry(iPackageFragmentRootArray[n].getRawClasspathEntry())) {
                        hashSet.add(iPackageFragmentRootArray[n]);
                    }
                    ++n;
                }
                return hashSet.toArray();
            }

            public boolean hasChildren(Object object) {
                return object instanceof IJavaProject || object instanceof IJavaModel;
            }
        };
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(272), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fTreeViewer = new TreeViewer(composite, 2052);
        this.fTreeViewer.getTree().setLayoutData((Object)this.createGridData(1808, 6, 0));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)standardJavaElementContentProvider);
        this.fTreeViewer.addFilter((ViewerFilter)new EmptyPackageFilter());
        this.fTreeViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        IPackageFragmentRoot iPackageFragmentRoot = this.fWizard.getPackageFragmentRoot();
        if (iPackageFragmentRoot != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{iPackageFragmentRoot}), true);
            this.fTreeViewer.expandToLevel((Object)iPackageFragmentRoot, 1);
        }
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        if (standardJavaElementContentProvider.getChildren(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).length == 0) {
            this.fTreeViewer.getControl().setEnabled(false);
            label.setEnabled(false);
        }
    }

    protected void createLocationGroup(Composite composite) {
        Assert.isNotNull((Object)composite);
        new Label(composite, 0).setText(JarImportMessages.JarImportWizardPage_import_label);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText(JarImportMessages.JarImportWizardPage_location_label);
        label.setLayoutData((Object)this.createGridData(32, 1, 0));
        this.fLocationControl = new RefactoringLocationControl((IWizard)this.fWizard, composite2, SETTING_HISTORY);
        this.fLocationControl.setLayoutData(this.createGridData(768, 1, 0));
        this.fLocationControl.loadHistory();
        this.fLocationControl.getControl().addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent modifyEvent) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.setFocus();
        Button button = new Button(composite2, 8);
        button.setText(JarImportMessages.JarImportWizardPage_browse_button_label);
        button.setLayoutData((Object)this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                JarImportWizardPage.this.handleBrowseButtonSelected();
            }
        });
    }

    protected void createRenameGroup(Composite composite) {
        Assert.isNotNull((Object)composite);
        final JarImportData jarImportData = this.fWizard.getImportData();
        final Button button = new Button(composite, 32);
        button.setText(JarImportMessages.JarImportWizardPage_replace_jar_file);
        button.setSelection(!jarImportData.isRenameJarFile());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                jarImportData.setRenameJarFile(!button.getSelection());
            }
        });
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            button.setEnabled(false);
        }
        if (!this.fImportWizard) {
            GridData gridData = new GridData();
            gridData.horizontalIndent = 7;
            button.setLayoutData((Object)gridData);
        }
    }

    protected void handleBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(JarImportMessages.JarImportWizardPage_browse_caption);
        fileDialog.setFilterNames(new String[]{"*.jar", "*.*"});
        fileDialog.setFilterExtensions(new String[]{"*.jar", "*.*"});
        String string = fileDialog.open();
        if (string != null) {
            this.fLocationControl.setText(string);
            this.handleInputChanged();
        }
    }

    protected void handleInputChanged() {
        JarImportData jarImportData = this.fWizard.getImportData();
        jarImportData.setRefactoringHistory(null);
        jarImportData.setRefactoringFileLocation(null);
        this.setErrorMessage(null);
        this.setMessage(null, 0);
        this.setPageComplete(true);
        this.handleJarFileChanged();
        if (this.isPageComplete()) {
            this.handlePackageFragmentRootChanged();
        }
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setErrorMessage(JarImportMessages.JarImportWizardPage_no_jar_files);
        }
        this.fFirstTime = false;
        this.getContainer().updateButtons();
    }

    /*
     * Exception decompiling
     */
    protected void handleJarFileChanged() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 280->286)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handlePackageFragmentRootChanged() {
        if (this.fTreeViewer != null) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
            Object[] objectArray = iStructuredSelection.toArray();
            if (objectArray.length != 1) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
                return;
            }
            JarImportData jarImportData = this.fWizard.getImportData();
            Object object = objectArray[0];
            if (object instanceof IPackageFragmentRoot) {
                jarImportData.setPackageFragmentRoot((IPackageFragmentRoot)object);
            } else if (object instanceof IPackageFragment) {
                jarImportData.setPackageFragmentRoot((IPackageFragmentRoot)((IJavaElement)object).getParent());
            } else {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void handleTimeStampChanged() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 119->125)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void performFinish() {
        this.fLocationControl.saveHistory();
    }

    public void setErrorMessage(String string) {
        if (!this.fFirstTime) {
            super.setErrorMessage(string);
        } else {
            this.setMessage(string, 0);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.handleInputChanged();
        }
    }
}

