/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.SealPackagesFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

class JarManifestWizardPage
extends WizardPage
implements IJarPackageWizardPage {
    private UntypedListener fUntypedListener = new UntypedListener();
    private JarPackageData fJarPackage;
    private IType[] fMainTypes;
    private Composite fManifestGroup;
    private Button fGenerateManifestRadioButton;
    private Button fSaveManifestCheckbox;
    private Button fReuseManifestCheckbox;
    private Text fNewManifestFileText;
    private Label fNewManifestFileLabel;
    private Button fNewManifestFileBrowseButton;
    private Button fUseManifestRadioButton;
    private Text fManifestFileText;
    private Label fManifestFileLabel;
    private Button fManifestFileBrowseButton;
    private Label fSealingHeaderLabel;
    private Button fSealJarRadioButton;
    private Label fSealJarLabel;
    private Button fSealedPackagesDetailsButton;
    private Button fSealPackagesRadioButton;
    private Label fSealPackagesLabel;
    private Button fUnSealedPackagesDetailsButton;
    private Label fMainClassHeaderLabel;
    private Label fMainClassLabel;
    private Text fMainClassText;
    private Button fMainClassBrowseButton;
    private static final String PAGE_NAME = "JarManifestWizardPage";
    private static final String STORE_GENERATE_MANIFEST = "JarManifestWizardPage.GENERATE_MANIFEST";
    private static final String STORE_SAVE_MANIFEST = "JarManifestWizardPage.SAVE_MANIFEST";
    private static final String STORE_REUSE_MANIFEST = "JarManifestWizardPage.REUSE_MANIFEST";
    private static final String STORE_MANIFEST_LOCATION = "JarManifestWizardPage.MANIFEST_LOCATION";
    private static final String STORE_SEAL_JAR = "JarManifestWizardPage.SEAL_JAR";

    public JarManifestWizardPage(JarPackageData jarPackageData) {
        super(PAGE_NAME);
        this.setTitle(JarPackagerMessages.JarManifestWizardPage_title);
        this.setDescription(JarPackagerMessages.JarManifestWizardPage_description);
        this.fJarPackage = jarPackageData;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createLabel(composite2, JarPackagerMessages.JarManifestWizardPage_manifestSource_label, false);
        this.createManifestGroup(composite2);
        this.createSpacer(composite2);
        this.fSealingHeaderLabel = this.createLabel(composite2, JarPackagerMessages.JarManifestWizardPage_sealingHeader_label, false);
        this.createSealingGroup(composite2);
        this.createSpacer(composite2);
        this.fMainClassHeaderLabel = this.createLabel(composite2, JarPackagerMessages.JarManifestWizardPage_mainClassHeader_label, false);
        this.createMainClassGroup(composite2);
        this.setEqualButtonSizes();
        this.restoreWidgetValues();
        this.setControl((Control)composite2);
        this.update();
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.jar_manifest_wizard_page_context");
    }

    protected void createManifestGroup(Composite composite) {
        this.fManifestGroup = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        this.fManifestGroup.setLayout((Layout)gridLayout);
        this.fManifestGroup.setLayoutData((Object)new GridData(784));
        this.fGenerateManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fGenerateManifestRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_genetateManifest_text);
        this.fGenerateManifestRadioButton.addListener(13, (Listener)this.fUntypedListener);
        Composite composite2 = new Composite(this.fManifestGroup, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(784);
        gridData.horizontalIndent = 20;
        composite2.setLayoutData((Object)gridData);
        this.fSaveManifestCheckbox = new Button(composite2, 16416);
        this.fSaveManifestCheckbox.setText(JarPackagerMessages.JarManifestWizardPage_saveManifest_text);
        this.fSaveManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.fReuseManifestCheckbox = new Button(composite2, 16416);
        this.fReuseManifestCheckbox.setText(JarPackagerMessages.JarManifestWizardPage_reuseManifest_text);
        this.fReuseManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.createNewManifestFileGroup(composite2);
        this.fUseManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fUseManifestRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_useManifest_text);
        this.fUseManifestRadioButton.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(this.fManifestGroup, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout3);
        gridData = new GridData(784);
        gridData.horizontalIndent = 20;
        composite3.setLayoutData((Object)gridData);
        this.createManifestFileGroup(composite3);
    }

    protected void createNewManifestFileGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(784));
        this.fNewManifestFileLabel = new Label(composite2, 0);
        this.fNewManifestFileLabel.setText(JarPackagerMessages.JarManifestWizardPage_newManifestFile_text);
        this.fNewManifestFileText = new Text(composite2, 2052);
        this.fNewManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.fNewManifestFileText.setLayoutData((Object)gridData);
        this.fNewManifestFileBrowseButton = new Button(composite2, 8);
        this.fNewManifestFileBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_newManifestFileBrowseButton_text);
        this.fNewManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fNewManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarManifestWizardPage.this.handleNewManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createManifestFileGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(784));
        this.fManifestFileLabel = new Label(composite2, 0);
        this.fManifestFileLabel.setText(JarPackagerMessages.JarManifestWizardPage_manifestFile_text);
        this.fManifestFileText = new Text(composite2, 2052);
        this.fManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.fManifestFileText.setLayoutData((Object)gridData);
        this.fManifestFileBrowseButton = new Button(composite2, 8);
        this.fManifestFileBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_manifestFileBrowse_text);
        this.fManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarManifestWizardPage.this.handleManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createSealingGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing += 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        this.createSealJarGroup(composite2);
        this.createSealPackagesGroup(composite2);
    }

    protected void createSealJarGroup(Composite composite) {
        this.fSealJarRadioButton = new Button(composite, 16);
        this.fSealJarRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_sealJar_text);
        this.fSealJarRadioButton.addListener(13, (Listener)this.fUntypedListener);
        this.fSealJarLabel = new Label(composite, 131072);
        this.fSealJarLabel.setLayoutData((Object)new GridData(768));
        this.fSealJarLabel.setText("");
        this.fUnSealedPackagesDetailsButton = new Button(composite, 8);
        this.fUnSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fUnSealedPackagesDetailsButton.setText(JarPackagerMessages.JarManifestWizardPage_unsealPackagesButton_text);
        this.fUnSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarManifestWizardPage.this.handleUnSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createSealPackagesGroup(Composite composite) {
        this.fSealPackagesRadioButton = new Button(composite, 16);
        this.fSealPackagesRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_sealPackagesButton_text);
        this.fSealPackagesLabel = new Label(composite, 131072);
        this.fSealPackagesLabel.setLayoutData((Object)new GridData(768));
        this.fSealPackagesLabel.setText("");
        this.fSealedPackagesDetailsButton = new Button(composite, 8);
        this.fSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fSealedPackagesDetailsButton.setText(JarPackagerMessages.JarManifestWizardPage_sealedPackagesDetailsButton_text);
        this.fSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarManifestWizardPage.this.handleSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createMainClassGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        this.fMainClassLabel = new Label(composite2, 0);
        this.fMainClassLabel.setText(JarPackagerMessages.JarManifestWizardPage_mainClass_label);
        this.fMainClassText = new Text(composite2, 2052);
        this.fMainClassText.addListener(24, (Listener)this.fUntypedListener);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.fMainClassText.setLayoutData((Object)gridData);
        this.fMainClassText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JarManifestWizardPage.this.fJarPackage.setManifestMainClass(JarManifestWizardPage.this.findMainMethodByName(JarManifestWizardPage.this.fMainClassText.getText()));
                JarManifestWizardPage.this.update();
            }
        });
        this.fMainClassBrowseButton = new Button(composite2, 8);
        this.fMainClassBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_mainClassBrowseButton_text);
        this.fMainClassBrowseButton.setLayoutData((Object)new GridData(256));
        this.fMainClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JarManifestWizardPage.this.handleMainClassBrowseButtonPressed();
            }
        });
    }

    private void update() {
        this.updateModel();
        this.updateEnableState();
        this.updatePageCompletion();
    }

    protected void handleNewManifestFileBrowseButtonPressed() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getContainer().getShell());
        saveAsDialog.create();
        saveAsDialog.getShell().setText(JarPackagerMessages.JarManifestWizardPage_saveAsDialog_title);
        saveAsDialog.setMessage(JarPackagerMessages.JarManifestWizardPage_saveAsDialog_message);
        saveAsDialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getManifestLocation()));
        if (saveAsDialog.open() == 0) {
            this.fJarPackage.setManifestLocation(saveAsDialog.getResult());
            this.fNewManifestFileText.setText(saveAsDialog.getResult().toString());
        }
    }

    protected void handleManifestFileBrowseButtonPressed() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = this.createWorkspaceFileSelectionDialog(JarPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_title, JarPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_message);
        if (this.fJarPackage.isManifestAccessible()) {
            elementTreeSelectionDialog.setInitialSelections((Object[])new IResource[]{this.fJarPackage.getManifestFile()});
        }
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            if (objectArray.length != 1) {
                this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_onlyOneManifestMustBeSelected);
            } else {
                this.setErrorMessage("");
                this.fJarPackage.setManifestLocation(((IResource)objectArray[0]).getFullPath());
                this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
            }
        }
    }

    private IType findMainMethodByName(String string) {
        if (this.fMainTypes == null) {
            List list = JarPackagerUtil.asResources(this.fJarPackage.getElements());
            if (list == null) {
                this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noResourceSelected);
                return null;
            }
            IJavaSearchScope iJavaSearchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(list.toArray(new IResource[list.size()]), true);
            MainMethodSearchEngine mainMethodSearchEngine = new MainMethodSearchEngine();
            try {
                this.fMainTypes = mainMethodSearchEngine.searchMainMethods((IRunnableContext)this.getContainer(), iJavaSearchScope, 0);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = 0;
        while (n < this.fMainTypes.length) {
            if (this.fMainTypes[n].getFullyQualifiedName().equals(string)) {
                return this.fMainTypes[n];
            }
            ++n;
        }
        return null;
    }

    protected void handleMainClassBrowseButtonPressed() {
        List list = JarPackagerUtil.asResources(this.fJarPackage.getElements());
        if (list == null) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noResourceSelected);
            return;
        }
        IJavaSearchScope iJavaSearchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(list.toArray(new IResource[list.size()]), true);
        SelectionDialog selectionDialog = JavaUI.createMainTypeDialog(this.getContainer().getShell(), (IRunnableContext)this.getContainer(), iJavaSearchScope, 0, false, "");
        selectionDialog.setTitle(JarPackagerMessages.JarManifestWizardPage_mainTypeSelectionDialog_title);
        selectionDialog.setMessage(JarPackagerMessages.JarManifestWizardPage_mainTypeSelectionDialog_message);
        if (this.fJarPackage.getManifestMainClass() != null) {
            selectionDialog.setInitialSelections(new Object[]{this.fJarPackage.getManifestMainClass()});
        }
        if (selectionDialog.open() == 0) {
            this.fJarPackage.setManifestMainClass((IType)selectionDialog.getResult()[0]);
            this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
        } else if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer())) {
            this.fJarPackage.setManifestMainClass(null);
            this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
        }
    }

    protected void handleSealPackagesDetailsButtonPressed() {
        SelectionDialog selectionDialog = this.createPackageDialog(this.getPackagesForSelectedResources(this.fJarPackage));
        selectionDialog.setTitle(JarPackagerMessages.JarManifestWizardPage_sealedPackagesSelectionDialog_title);
        selectionDialog.setMessage(JarPackagerMessages.JarManifestWizardPage_sealedPackagesSelectionDialog_message);
        selectionDialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToSeal());
        if (selectionDialog.open() == 0) {
            this.fJarPackage.setPackagesToSeal(this.getPackagesFromDialog(selectionDialog));
        }
        this.updateSealingInfo();
    }

    protected void handleUnSealPackagesDetailsButtonPressed() {
        SelectionDialog selectionDialog = this.createPackageDialog(this.getPackagesForSelectedResources(this.fJarPackage));
        selectionDialog.setTitle(JarPackagerMessages.JarManifestWizardPage_unsealedPackagesSelectionDialog_title);
        selectionDialog.setMessage(JarPackagerMessages.JarManifestWizardPage_unsealedPackagesSelectionDialog_message);
        selectionDialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToUnseal());
        if (selectionDialog.open() == 0) {
            this.fJarPackage.setPackagesToUnseal(this.getPackagesFromDialog(selectionDialog));
        }
        this.updateSealingInfo();
    }

    protected void updateEnableState() {
        boolean bl = this.fGenerateManifestRadioButton.getSelection();
        boolean bl2 = bl && this.fSaveManifestCheckbox.getSelection();
        this.fSaveManifestCheckbox.setEnabled(bl);
        this.fReuseManifestCheckbox.setEnabled(this.fJarPackage.isDescriptionSaved() && bl2);
        this.fNewManifestFileText.setEnabled(bl2);
        this.fNewManifestFileLabel.setEnabled(bl2);
        this.fNewManifestFileBrowseButton.setEnabled(bl2);
        this.fManifestFileText.setEnabled(!bl);
        this.fManifestFileLabel.setEnabled(!bl);
        this.fManifestFileBrowseButton.setEnabled(!bl);
        this.fSealingHeaderLabel.setEnabled(bl);
        boolean bl3 = this.fSealJarRadioButton.getSelection();
        this.fSealJarRadioButton.setEnabled(bl);
        this.fSealJarLabel.setEnabled(bl);
        this.fUnSealedPackagesDetailsButton.setEnabled(bl3 && bl);
        this.fSealPackagesRadioButton.setEnabled(bl);
        this.fSealPackagesLabel.setEnabled(bl);
        this.fSealedPackagesDetailsButton.setEnabled(!bl3 && bl);
        this.fMainClassHeaderLabel.setEnabled(bl);
        this.fMainClassLabel.setEnabled(bl);
        this.fMainClassText.setEnabled(bl);
        this.fMainClassBrowseButton.setEnabled(bl);
        this.updateSealingInfo();
    }

    protected void updateSealingInfo() {
        if (this.fJarPackage.isJarSealed()) {
            this.fSealPackagesLabel.setText("");
            int n = this.fJarPackage.getPackagesToUnseal().length;
            if (n == 0) {
                this.fSealJarLabel.setText(JarPackagerMessages.JarManifestWizardPage_jarSealed);
            } else if (n == 1) {
                this.fSealJarLabel.setText(JarPackagerMessages.JarManifestWizardPage_jarSealedExceptOne);
            } else {
                this.fSealJarLabel.setText(Messages.format(JarPackagerMessages.JarManifestWizardPage_jarSealedExceptSome, new Integer(n)));
            }
        } else {
            this.fSealJarLabel.setText("");
            int n = this.fJarPackage.getPackagesToSeal().length;
            if (n == 0) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.JarManifestWizardPage_nothingSealed);
            } else if (n == 1) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.JarManifestWizardPage_onePackageSealed);
            } else {
                this.fSealPackagesLabel.setText(Messages.format(JarPackagerMessages.JarManifestWizardPage_somePackagesSealed, new Integer(n)));
            }
        }
    }

    public boolean isPageComplete() {
        Object object;
        boolean bl = true;
        this.setMessage(null);
        if (!this.fJarPackage.areGeneratedFilesExported()) {
            return true;
        }
        if (this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                bl = false;
            } else {
                object = this.fJarPackage.getManifestLocation();
                if (!object.toString().startsWith("/")) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestPathMustBeAbsolute);
                    return false;
                }
                IResource iResource = this.findResource((IPath)object);
                if (iResource != null && iResource.getType() != 1) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestMustNotBeExistingContainer);
                    return false;
                }
                iResource = this.findResource(object.removeLastSegments(1));
                if (iResource == null || iResource.getType() == 1) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestContainerDoesNotExist);
                    return false;
                }
            }
        }
        if (!this.fJarPackage.isManifestGenerated()) {
            if (this.fJarPackage.isManifestAccessible()) {
                object = null;
                try {
                    object = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                }
                catch (CoreException coreException) {}
                if (object != null && ((Manifest)object).getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                    this.setMessage(JarPackagerMessages.JarManifestWizardPage_warning_noManifestVersion, 2);
                }
            } else {
                if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noManifestFile);
                } else {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_invalidManifestFile);
                }
                return false;
            }
        }
        object = this.getPackagesForSelectedResources(this.fJarPackage);
        if (this.fJarPackage.isJarSealed() && !object.containsAll(Arrays.asList(this.fJarPackage.getPackagesToUnseal()))) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_unsealedPackagesNotInSelection);
            return false;
        }
        if (!this.fJarPackage.isJarSealed() && !object.containsAll(Arrays.asList(this.fJarPackage.getPackagesToSeal()))) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_sealedPackagesNotInSelection);
            return false;
        }
        if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer()) || this.fJarPackage.getManifestMainClass() == null && this.fMainClassText.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_invalidMainClass);
            return false;
        }
        this.setErrorMessage(null);
        return bl;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        super.setPreviousPage(iWizardPage);
        this.fMainTypes = null;
        this.updateEnableState();
        if (this.getContainer() != null) {
            this.updatePageCompletion();
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public final void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_GENERATE_MANIFEST, this.fJarPackage.isManifestGenerated());
            iDialogSettings.put(STORE_SAVE_MANIFEST, this.fJarPackage.isManifestSaved());
            iDialogSettings.put(STORE_REUSE_MANIFEST, this.fJarPackage.isManifestReused());
            iDialogSettings.put(STORE_MANIFEST_LOCATION, this.fJarPackage.getManifestLocation().toString());
            iDialogSettings.put(STORE_SEAL_JAR, this.fJarPackage.isJarSealed());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        if (this.fJarPackage.isManifestGenerated()) {
            this.fGenerateManifestRadioButton.setSelection(true);
        } else {
            this.fUseManifestRadioButton.setSelection(true);
        }
        this.fSaveManifestCheckbox.setSelection(this.fJarPackage.isManifestSaved());
        this.fReuseManifestCheckbox.setSelection(this.fJarPackage.isManifestReused());
        this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        this.fNewManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        if (this.fJarPackage.isJarSealed()) {
            this.fSealJarRadioButton.setSelection(true);
        } else {
            this.fSealPackagesRadioButton.setSelection(true);
        }
        this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
    }

    protected void initializeJarPackage() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.fJarPackage.setGenerateManifest(iDialogSettings.getBoolean(STORE_GENERATE_MANIFEST));
            this.fJarPackage.setSaveManifest(iDialogSettings.getBoolean(STORE_SAVE_MANIFEST));
            this.fJarPackage.setReuseManifest(iDialogSettings.getBoolean(STORE_REUSE_MANIFEST));
            String string = iDialogSettings.get(STORE_MANIFEST_LOCATION);
            if (string == null) {
                string = "";
            }
            this.fJarPackage.setManifestLocation((IPath)new Path(string));
            this.fJarPackage.setSealJar(iDialogSettings.getBoolean(STORE_SEAL_JAR));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setGenerateManifest(this.fGenerateManifestRadioButton.getSelection());
        this.fJarPackage.setSaveManifest(this.fSaveManifestCheckbox.getSelection());
        this.fJarPackage.setReuseManifest(this.fReuseManifestCheckbox.getSelection());
        String string = this.fJarPackage.isManifestGenerated() ? this.fNewManifestFileText.getText() : this.fManifestFileText.getText();
        if (string == null) {
            string = "";
        }
        this.fJarPackage.setManifestLocation((IPath)new Path(string));
        this.fJarPackage.setSealJar(this.fSealJarRadioButton.getSelection());
    }

    protected void updatePageCompletion() {
        boolean bl = this.isPageComplete();
        this.setPageComplete(bl);
        if (bl) {
            this.setErrorMessage(null);
        }
    }

    protected IFile createFileHandle(IPath iPath) {
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(iPath);
        }
        return null;
    }

    protected Label createLabel(Composite composite, String string, boolean bl) {
        Label label = new Label(composite, 0);
        if (bl) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(string);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void setSize(Control control, int n, int n2) {
        GridData gridData = new GridData(3);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        control.setLayoutData((Object)gridData);
    }

    protected void setEqualButtonSizes() {
        int n = SWTUtil.getButtonWidthHint(this.fManifestFileBrowseButton);
        int n2 = SWTUtil.getButtonWidthHint(this.fNewManifestFileBrowseButton);
        n = Math.max(n, n2);
        n2 = SWTUtil.getButtonWidthHint(this.fSealedPackagesDetailsButton);
        n = Math.max(n, n2);
        n2 = SWTUtil.getButtonWidthHint(this.fUnSealedPackagesDetailsButton);
        n = Math.max(n, n2);
        n2 = SWTUtil.getButtonWidthHint(this.fMainClassBrowseButton);
        n = Math.max(n, n2);
        this.setSize((Control)this.fManifestFileBrowseButton, n, -1);
        this.setSize((Control)this.fNewManifestFileBrowseButton, n, -1);
        this.setSize((Control)this.fSealedPackagesDetailsButton, n, -1);
        this.setSize((Control)this.fUnSealedPackagesDetailsButton, n, -1);
        this.setSize((Control)this.fMainClassBrowseButton, n, -1);
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
    }

    protected IResource findResource(IPath iPath) {
        IWorkspace iWorkspace = JavaPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 15);
        if (iStatus.isOK() && iWorkspace.getRoot().exists(iPath)) {
            return iWorkspace.getRoot().findMember(iPath);
        }
        return null;
    }

    protected IPath getPathFromString(String string) {
        return new Path(string).makeAbsolute();
    }

    protected SelectionDialog createPackageDialog(Set set) {
        IPackageFragment iPackageFragment;
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>(set.size());
        Object object = set.iterator();
        while (object.hasNext()) {
            int n;
            iPackageFragment = (IPackageFragment)object.next();
            boolean bl = false;
            try {
                n = iPackageFragment.getKind();
                bl = iPackageFragment.getChildren().length > 0;
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getContainer().getShell(), JarPackagerMessages.JarManifestWizardPage_error_jarPackageWizardError_title, Messages.format(JarPackagerMessages.JarManifestWizardPage_error_jarPackageWizardError_message, iPackageFragment.getElementName()));
                continue;
            }
            if (n == 2 || !bl) continue;
            arrayList.add(iPackageFragment);
        }
        object = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object object) {
                return !(object instanceof IPackageFragment) && super.hasChildren(object);
            }
        };
        iPackageFragment = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ILabelDecorator)new ProblemsLabelDecorator(null));
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getContainer().getShell(), (ILabelProvider)iPackageFragment, (ITreeContentProvider)object);
        elementTreeSelectionDialog.setDoubleClickSelects(false);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new JavaElementComparator());
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        elementTreeSelectionDialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        elementTreeSelectionDialog.addFilter((ViewerFilter)new LibraryFilter());
        elementTreeSelectionDialog.addFilter((ViewerFilter)new SealPackagesFilter(arrayList));
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                StatusInfo statusInfo = new StatusInfo();
                int n = 0;
                while (n < objectArray.length) {
                    if (!(objectArray[n] instanceof IPackageFragment)) {
                        statusInfo.setError(JarPackagerMessages.JarManifestWizardPage_error_mustContainPackages);
                        return statusInfo;
                    }
                    ++n;
                }
                statusInfo.setOK();
                return statusInfo;
            }
        });
        return elementTreeSelectionDialog;
    }

    protected IPackageFragment[] getPackagesFromDialog(SelectionDialog selectionDialog) {
        if (selectionDialog.getReturnCode() == 0 && selectionDialog.getResult().length > 0) {
            return Arrays.asList(selectionDialog.getResult()).toArray(new IPackageFragment[selectionDialog.getResult().length]);
        }
        return new IPackageFragment[0];
    }

    protected ElementTreeSelectionDialog createWorkspaceFileSelectionDialog(String string, String string2) {
        int n = 272;
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(n), (ILabelDecorator)new ProblemsLabelDecorator(null));
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)decoratingLabelProvider, (ITreeContentProvider)new StandardJavaElementContentProvider());
        elementTreeSelectionDialog.setComparator((ViewerComparator)new JavaElementComparator());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                StatusInfo statusInfo = new StatusInfo();
                if (objectArray.length == 1 && objectArray[0] instanceof IFile) {
                    statusInfo.setOK();
                } else {
                    statusInfo.setError("");
                }
                return statusInfo;
            }
        });
        elementTreeSelectionDialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        elementTreeSelectionDialog.addFilter((ViewerFilter)new LibraryFilter());
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.setStatusLineAboveButtons(true);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        return elementTreeSelectionDialog;
    }

    private Set getPackagesForSelectedResources(JarPackageData jarPackageData) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>();
        int n = this.fJarPackage.getElements().length;
        int n2 = 0;
        while (n2 < n) {
            Object object = this.fJarPackage.getElements()[n2];
            if (object instanceof ICompilationUnit) {
                hashSet.add(((ICompilationUnit)object).getParent());
            }
            ++n2;
        }
        return hashSet;
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event event) {
            if (JarManifestWizardPage.this.getControl() == null) {
                return;
            }
            JarManifestWizardPage.this.update();
        }
    }
}

