/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public final class JarPackagerUtil {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "jardesc";
    private static final String META_INF_ENTRY = "META-INF";
    private static final String REFACTORINGS_ENTRY = "META-INF/REFACTORINGS.XML";

    private JarPackagerUtil() {
    }

    public static boolean askToCreateDirectory(Shell shell, File file) {
        if (shell == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(shell, JarPackagerMessages.JarPackage_confirmCreate_title, Messages.format(JarPackagerMessages.JarPackage_confirmCreate_message, file.toString()));
    }

    public static String getRefactoringsEntry() {
        return REFACTORINGS_ENTRY;
    }

    public static String getDeprecationEntry(String string) {
        return "META-INF/" + string;
    }

    public static String getMetaEntry() {
        return META_INF_ENTRY;
    }

    public static List asResources(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IJavaElement) {
                arrayList.add(((IJavaElement)object).getResource());
            } else if (object instanceof IResource) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean askForOverwritePermission(Shell shell, String string) {
        if (shell == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(shell, JarPackagerMessages.JarPackage_confirmReplace_title, Messages.format(JarPackagerMessages.JarPackage_confirmReplace_message, string));
    }

    static String getMainClassName(JarPackageData jarPackageData) {
        if (jarPackageData.getManifestMainClass() == null) {
            return "";
        }
        return jarPackageData.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell shell, final String string, final String string2) {
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2);
            }
        };
        display.syncExec(runnable);
        return blArray[0];
    }

    public static CoreException createCoreException(String string, Exception exception) {
        if (string == null) {
            string = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 10001, string, (Throwable)exception));
    }

    public static boolean isMainClassValid(JarPackageData jarPackageData, IRunnableContext iRunnableContext) {
        IType iType;
        block5: {
            if (jarPackageData == null) {
                return false;
            }
            iType = jarPackageData.getManifestMainClass();
            if (iType == null) {
                return true;
            }
            try {
                IFile iFile = (IFile)iType.getResource();
                if (iFile != null && JarPackagerUtil.contains(JarPackagerUtil.asResources(jarPackageData.getElements()), iFile)) break block5;
                return false;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException.getStatus());
                return false;
            }
        }
        return JavaModelUtil.hasMainMethod(iType);
    }

    static boolean contains(List list, IFile iFile) {
        if (list == null || iFile == null) {
            return false;
        }
        if (list.contains(iFile)) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource == null || iResource.getType() == 1) continue;
            List<IResource> list2 = null;
            try {
                list2 = Arrays.asList(((IContainer)iResource).members());
            }
            catch (CoreException coreException) {
                continue;
            }
            if (list2 == null || !JarPackagerUtil.contains(list2, iFile)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void calculateCrcAndSize(JarEntry jarEntry, InputStream inputStream, byte[] byArray) throws IOException {
        CRC32 cRC32;
        int n;
        block7: {
            n = 0;
            cRC32 = new CRC32();
            try {
                int n2;
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    cRC32.update(byArray, 0, n2);
                    n += n2;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (inputStream == null) break block7;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
        }
        jarEntry.setSize(n);
        jarEntry.setCrc(cRC32.getValue());
    }
}

