/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public final class ASTProvider {
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ASTProvider"));
    public static final int SHARED_AST_LEVEL = 3;
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private IJavaElement fReconcilingJavaElement;
    private IJavaElement fActiveJavaElement;
    private CompilationUnit fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return JavaPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        int n2 = iWorkbenchWindowArray.length;
        while (n < n2) {
            iWorkbenchWindowArray[n].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJavaEditorChanged(IWorkbenchPart iWorkbenchPart) {
        IJavaElement iJavaElement = null;
        if (iWorkbenchPart instanceof JavaEditor) {
            iJavaElement = ((JavaEditor)iWorkbenchPart).getInputJavaElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = iWorkbenchPart;
            this.fActiveJavaElement = iJavaElement;
            this.cache(null, iJavaElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(iJavaElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingJavaElement == null || !this.fReconcilingJavaElement.equals(iJavaElement))) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            } else if (iJavaElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            }
        }
    }

    public boolean isCached(CompilationUnit compilationUnit) {
        return compilationUnit != null && this.fAST == compilationUnit;
    }

    public boolean isActive(ICompilationUnit iCompilationUnit) {
        return iCompilationUnit != null && iCompilationUnit.equals(this.fActiveJavaElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(iJavaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingJavaElement = iJavaElement;
        }
        this.cache(null, iJavaElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveJavaElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return "null";
        }
        return iJavaElement.getElementName();
    }

    private String toString(CompilationUnit compilationUnit) {
        if (compilationUnit == null) {
            return "null";
        }
        List list = compilationUnit.types();
        if (list != null && list.size() > 0) {
            return ((AbstractTypeDeclaration)list.get(0)).getName().getIdentifier();
        }
        return "AST without any type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(CompilationUnit compilationUnit, IJavaElement iJavaElement) {
        if (this.fActiveJavaElement != null && !this.fActiveJavaElement.equals(iJavaElement)) {
            if (DEBUG && iJavaElement != null) {
                System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(iJavaElement));
            }
            return;
        }
        if (DEBUG && (iJavaElement != null || compilationUnit != null)) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(compilationUnit) + " for: " + this.toString(iJavaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = compilationUnit;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * Exception decompiling
     */
    public CompilationUnit getAST(IJavaElement var1_1, WAIT_FLAG var2_2, IProgressMonitor var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [12 : 667->670)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompilationUnit getAST(IJavaElement iJavaElement, boolean bl, IProgressMonitor iProgressMonitor) {
        if (bl) {
            return this.getAST(iJavaElement, WAIT_YES, iProgressMonitor);
        }
        return this.getAST(iJavaElement, WAIT_NO, iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(IJavaElement iJavaElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return iJavaElement != null && iJavaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling;
        }
    }

    private CompilationUnit createAST(final IJavaElement iJavaElement, final IProgressMonitor iProgressMonitor) {
        if (!this.hasSource(iJavaElement)) {
            return null;
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setResolveBindings(true);
        aSTParser.setStatementsRecovery(true);
        aSTParser.setBindingsRecovery(true);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return null;
        }
        if (iJavaElement.getElementType() == 5) {
            aSTParser.setSource((ICompilationUnit)iJavaElement);
        } else if (iJavaElement.getElementType() == 6) {
            aSTParser.setSource((IClassFile)iJavaElement);
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] compilationUnitArray = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        return;
                    }
                    if (DEBUG) {
                        System.err.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "creating AST for: " + iJavaElement.getElementName());
                    }
                    compilationUnitArray[0] = (CompilationUnit)aSTParser.createAST(iProgressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }

            public void handleException(Throwable throwable) {
                Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Error in JDT Core during AST creation", throwable);
                JavaPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        if (compilationUnitArray[0] != null) {
            ASTNodes.setFlagsToAST((ASTNode)compilationUnitArray[0], 4);
        }
        return compilationUnitArray[0];
    }

    private boolean hasSource(IJavaElement iJavaElement) {
        if (iJavaElement == null || !iJavaElement.exists()) {
            return false;
        }
        try {
            return iJavaElement instanceof ITypeRoot && ((ITypeRoot)iJavaElement).getBuffer() != null;
        }
        catch (JavaModelException javaModelException) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Error in JDT Core during AST creation", (Throwable)javaModelException);
            JavaPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(CompilationUnit compilationUnit, IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(iJavaElement) + ", AST: " + this.toString(compilationUnit));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            boolean bl = this.fIsReconciling = iProgressMonitor != null && iProgressMonitor.isCanceled();
            if (iJavaElement == null || !iJavaElement.equals(this.fReconcilingJavaElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(compilationUnit, iJavaElement);
        }
    }

    private String getThreadName() {
        String string = Thread.currentThread().getName();
        if (string != null) {
            return string;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isJavaEditor(iWorkbenchPartReference) && !this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isJavaEditor(iWorkbenchPartReference) && !this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isActiveEditor(iWorkbenchPartReference)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + iWorkbenchPartReference.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isJavaEditor(iWorkbenchPartReference) && !this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isJavaEditor(iWorkbenchPartReference) && !this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            if (this.isJavaEditor(iWorkbenchPartReference) && this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchWindow.getPartService().getActivePartReference();
            if (this.isJavaEditor(iWorkbenchPartReference) && !this.isActiveEditor(iWorkbenchPartReference)) {
                ASTProvider.this.activeJavaEditorChanged(iWorkbenchPartReference.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && iWorkbenchWindow == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            iWorkbenchWindow.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            iWorkbenchWindow.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference iWorkbenchPartReference) {
            return iWorkbenchPartReference != null && this.isActiveEditor(iWorkbenchPartReference.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart iWorkbenchPart) {
            return iWorkbenchPart != null && iWorkbenchPart == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference == null) {
                return false;
            }
            String string = iWorkbenchPartReference.getId();
            return "org.eclipse.wst.jsdt.ui.ClassFileEditor".equals(string) || "org.eclipse.wst.jsdt.ui.CompilationUnitEditor".equals(string) || iWorkbenchPartReference.getPart(false) instanceof JavaEditor;
        }
    }

    public static final class WAIT_FLAG {
        String fName;

        private WAIT_FLAG(String string) {
            this.fName = string;
        }

        public String toString() {
            return this.fName;
        }
    }
}

