/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;

public class StructureSelectHistoryAction
extends Action
implements IUpdate {
    private JavaEditor fEditor;
    private SelectionHistory fHistory;

    public StructureSelectHistoryAction(JavaEditor javaEditor, SelectionHistory selectionHistory) {
        super(SelectionActionMessages.StructureSelectHistory_label);
        this.setToolTipText(SelectionActionMessages.StructureSelectHistory_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectHistory_description);
        Assert.isNotNull((Object)selectionHistory);
        Assert.isNotNull((Object)javaEditor);
        this.fHistory = selectionHistory;
        this.fEditor = javaEditor;
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.structured_selection_history_action");
    }

    public void update() {
        this.setEnabled(!this.fHistory.isEmpty());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ISourceRange iSourceRange = this.fHistory.getLast();
        if (iSourceRange == null) return;
        try {
            this.fHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(iSourceRange.getOffset(), iSourceRange.getLength());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fHistory.listenToSelectionChanges();
            return;
        }
    }
}

