/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaNavigatorContentProvider
extends PackageExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JDT_EXTENSION_ID = "org.eclipse.wst.jsdt.ui.javaContent";
    private IExtensionStateModel fStateModel;
    private Object fRealInput;
    private IPropertyChangeListener fLayoutPropertyListener;
    static /* synthetic */ Class class$0;

    public JavaNavigatorContentProvider() {
        super(false);
    }

    public JavaNavigatorContentProvider(boolean bl) {
        super(bl);
    }

    public void init(ICommonContentExtensionSite iCommonContentExtensionSite) {
        IExtensionStateModel iExtensionStateModel = iCommonContentExtensionSite.getExtensionStateModel();
        IMemento iMemento = iCommonContentExtensionSite.getMemento();
        this.fStateModel = iExtensionStateModel;
        this.restoreState(iMemento);
        this.fLayoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("isLayoutFlat".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() != null) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue() != false;
                    JavaNavigatorContentProvider.this.setIsFlatLayout(bl);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.fLayoutPropertyListener);
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
        this.setProvideMembers(bl);
    }

    public void dispose() {
        super.dispose();
        this.fStateModel.removePropertyChangeListener(this.fLayoutPropertyListener);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.fRealInput = object2;
        super.inputChanged(viewer, object, this.findInputElement(object2));
    }

    public Object getParent(Object object) {
        Object object2 = super.getParent(object);
        if (object2 instanceof IJavaModel) {
            return this.getViewerInput() != null ? this.fRealInput : object2;
        }
        return object2;
    }

    public Object[] getElements(Object object) {
        if (object instanceof IWorkspaceRoot) {
            IWorkspaceRoot iWorkspaceRoot = (IWorkspaceRoot)object;
            return iWorkspaceRoot.getProjects();
        }
        if (object instanceof IJavaModel) {
            return ((IJavaModel)object).getWorkspace().getRoot().getProjects();
        }
        if (object instanceof IProject) {
            return super.getElements(JavaCore.create((IProject)((IProject)object)));
        }
        return super.getElements(object);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IWorkspaceRoot) {
            IWorkspaceRoot iWorkspaceRoot = (IWorkspaceRoot)object;
            return iWorkspaceRoot.getProjects();
        }
        if (object instanceof IProject) {
            return super.getChildren(JavaCore.create((IProject)((IProject)object)));
        }
        return super.getChildren(object);
    }

    private Object findInputElement(Object object) {
        if (object instanceof IWorkspaceRoot) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)object));
        }
        return object;
    }

    public void restoreState(IMemento iMemento) {
    }

    public void saveState(IMemento iMemento) {
    }

    public void getPipelinedChildren(Object object, Set set) {
        this.customize(this.getChildren(object), set);
    }

    public void getPipelinedElements(Object object, Set set) {
        this.customize(this.getElements(object), set);
    }

    public Object getPipelinedParent(Object object, Object object2) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification pipelinedShapeModification) {
        if (pipelinedShapeModification.getParent() instanceof IJavaProject) {
            pipelinedShapeModification.setParent((Object)((IJavaProject)pipelinedShapeModification.getParent()).getProject());
        } else if (pipelinedShapeModification.getParent() instanceof IWorkspaceRoot || pipelinedShapeModification.getParent() instanceof IJavaProject) {
            this.deconvertJavaProjects(pipelinedShapeModification);
        }
        this.convertToJavaElements(pipelinedShapeModification);
        return pipelinedShapeModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification pipelinedShapeModification) {
        this.deconvertJavaProjects(pipelinedShapeModification);
        this.convertToJavaElements(pipelinedShapeModification.getChildren());
        return pipelinedShapeModification;
    }

    private void deconvertJavaProjects(PipelinedShapeModification pipelinedShapeModification) {
        LinkedHashSet<IProject> linkedHashSet = new LinkedHashSet<IProject>();
        Iterator iterator = pipelinedShapeModification.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IJavaProject)) continue;
            iterator.remove();
            linkedHashSet.add(((IJavaProject)e).getProject());
        }
        pipelinedShapeModification.getChildren().addAll(linkedHashSet);
    }

    private boolean convertToJavaElements(PipelinedShapeModification pipelinedShapeModification) {
        IJavaElement iJavaElement;
        Object object = pipelinedShapeModification.getParent();
        if (object instanceof IContainer && (iJavaElement = JavaCore.create((IResource)((IContainer)object))) != null && iJavaElement.exists()) {
            if (!(iJavaElement instanceof IJavaModel) && !(iJavaElement instanceof IJavaProject)) {
                pipelinedShapeModification.setParent((Object)iJavaElement);
            }
            return this.convertToJavaElements(pipelinedShapeModification.getChildren());
        }
        return false;
    }

    private boolean convertToJavaElements(Set set) {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IFolder || e instanceof IFile) {
                IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)e));
                if (iJavaElement == null || !iJavaElement.exists()) continue;
                iterator.remove();
                linkedHashSet.add(iJavaElement);
                continue;
            }
            if (!(e instanceof IJavaProject)) continue;
            iterator.remove();
            linkedHashSet.add(((IJavaProject)e).getProject());
        }
        if (!linkedHashSet.isEmpty()) {
            set.addAll(linkedHashSet);
            return true;
        }
        return false;
    }

    private void customize(Object[] objectArray, Set set) {
        IResource iResource;
        Object object;
        List<Object> list = Arrays.asList(objectArray);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            object = iterator.next();
            iResource = null;
            if (object instanceof IResource) {
                iResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource == null || (n = list.indexOf(iResource)) < 0) continue;
            objectArray[n] = null;
        }
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (object instanceof IJavaElement) {
                iResource = (IJavaElement)object;
                IResource iResource2 = iResource.getResource();
                if (iResource2 != null) {
                    set.remove(iResource2);
                }
                set.add(object);
            } else if (object != null) {
                set.add(object);
            }
            ++n;
        }
    }

    public boolean interceptRefresh(PipelinedViewerUpdate pipelinedViewerUpdate) {
        return this.convertToJavaElements(pipelinedViewerUpdate.getRefreshTargets());
    }

    public boolean interceptUpdate(PipelinedViewerUpdate pipelinedViewerUpdate) {
        return this.convertToJavaElements(pipelinedViewerUpdate.getRefreshTargets());
    }

    protected void postAdd(Object object, Object object2, Collection collection) {
        if (object instanceof IJavaModel) {
            super.postAdd(((IJavaModel)object).getWorkspace(), object2, collection);
        } else {
            super.postAdd(object, object2, collection);
        }
    }

    protected void postRefresh(List list, boolean bl, Collection collection) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IJavaModel)) continue;
            iterator.remove();
            list.add(this.fRealInput);
            super.postRefresh(list, bl, collection);
            return;
        }
        super.postRefresh(list, bl, collection);
    }
}

