/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class SelectionTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer structuredViewer) {
        super(structuredViewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        Object object;
        Object object2 = object = dropTargetEvent.item != null ? dropTargetEvent.item.getData() : null;
        if (object == null) {
            return false;
        }
        return object instanceof IJavaElement || object instanceof IResource;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.clear();
        super.dragEnter(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.clear();
        super.dragLeave(dropTargetEvent);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        if (this.tooFast(dropTargetEvent)) {
            return;
        }
        this.initializeSelection();
        try {
            switch (n) {
                case 16: {
                    dropTargetEvent.detail = this.handleValidateDefault(object, dropTargetEvent);
                    break;
                }
                case 1: {
                    dropTargetEvent.detail = this.handleValidateCopy(object, dropTargetEvent);
                    break;
                }
                case 2: {
                    dropTargetEvent.detail = this.handleValidateMove(object, dropTargetEvent);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            dropTargetEvent.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = iSelection;
        this.fElements = ((IStructuredSelection)iSelection).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent dropTargetEvent) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)dropTargetEvent.time & 0xFFFFFFFFL)) < 150L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drop(Object object, DropTargetEvent dropTargetEvent) {
        try {
            try {
                switch (dropTargetEvent.detail) {
                    case 2: {
                        this.handleDropMove(object, dropTargetEvent);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(object, dropTargetEvent);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            dropTargetEvent.detail = 0;
            throw throwable;
        }
        {
            Object var4_7 = null;
            dropTargetEvent.detail = 0;
            return;
        }
    }

    private int handleValidateDefault(Object object, DropTargetEvent dropTargetEvent) throws JavaModelException {
        if (object == null) {
            return 0;
        }
        if ((dropTargetEvent.operations & 2) != 0) {
            return this.handleValidateMove(object, dropTargetEvent);
        }
        if ((dropTargetEvent.operations & 1) != 0) {
            return this.handleValidateCopy(object, dropTargetEvent);
        }
        return 0;
    }

    private int handleValidateMove(Object object, DropTargetEvent dropTargetEvent) throws JavaModelException {
        IReorgPolicy.IMovePolicy iMovePolicy;
        if (object == null) {
            return 0;
        }
        if (this.fMoveProcessor == null && (iMovePolicy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements))).canEnable()) {
            this.fMoveProcessor = new JavaMoveProcessor(iMovePolicy);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (object instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)object).isOK()) {
            return 2;
        }
        if (object instanceof IJavaElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IJavaElement)object).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropMove(Object object, DropTargetEvent dropTargetEvent) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(this.fElements);
        IResource[] iResourceArray = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter reorgMoveStarter = null;
        if (object instanceof IResource) {
            reorgMoveStarter = ReorgMoveStarter.create(iJavaElementArray, iResourceArray, (IResource)object);
        } else if (object instanceof IJavaElement) {
            reorgMoveStarter = ReorgMoveStarter.create(iJavaElementArray, iResourceArray, (IJavaElement)object);
        }
        if (reorgMoveStarter != null) {
            reorgMoveStarter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object object, DropTargetEvent dropTargetEvent) throws JavaModelException {
        if (this.fCopyProcessor == null) {
            IReorgPolicy.ICopyPolicy iCopyPolicy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
            JavaCopyProcessor javaCopyProcessor = this.fCopyProcessor = iCopyPolicy.canEnable() ? new JavaCopyProcessor(iCopyPolicy) : null;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (object instanceof IResource && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IResource)object).isOK()) {
            return 1;
        }
        if (object instanceof IJavaElement && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IJavaElement)object).isOK()) {
            return 1;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object object, DropTargetEvent dropTargetEvent) throws JavaModelException, InvocationTargetException, InterruptedException {
        IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(this.fElements);
        IResource[] iResourceArray = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter reorgCopyStarter = null;
        if (object instanceof IResource) {
            reorgCopyStarter = ReorgCopyStarter.create(iJavaElementArray, iResourceArray, (IResource)object);
        } else if (object instanceof IJavaElement) {
            reorgCopyStarter = ReorgCopyStarter.create(iJavaElementArray, iResourceArray, (IJavaElement)object);
        }
        if (reorgCopyStarter != null) {
            reorgCopyStarter.run(this.getShell());
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

