/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaUI;

class CodeAssistFavoritesConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS = CodeAssistFavoritesConfigurationBlock.getJDTUIKey("content_assist_favorite_static_members");
    private static final String WILDCARD = ".*";
    private static final int IDX_NEW_TYPE = 0;
    private static final int IDX_NEW_MEMBER = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private ListDialogField fList;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS};
    }

    public CodeAssistFavoritesConfigurationBlock(IStatusChangeListener iStatusChangeListener, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, null, CodeAssistFavoritesConfigurationBlock.getAllKeys(), iWorkbenchPreferenceContainer);
    }

    protected Control createContents(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledPageContent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createFavoriteList(composite2);
        this.initialize();
        scrolledPageContent.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledPageContent.setMinSize(point.x, point.y);
        Dialog.applyDialogFont((Control)scrolledPageContent);
        return scrolledPageContent;
    }

    private void createFavoriteList(Composite composite) {
        String[] stringArray = new String[]{PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_newType_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_newMember_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_edit_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_remove_button};
        ListAdapter listAdapter = new ListAdapter();
        this.fList = new ListDialogField(listAdapter, stringArray, (ILabelProvider)new ListLabelProvider());
        this.fList.setDialogFieldListener(listAdapter);
        this.fList.setLabelText(PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_description);
        this.fList.setRemoveButtonIndex(3);
        this.fList.enableButton(2, false);
        this.fList.setViewerComparator(new ViewerComparator());
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.fList.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fList.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fList.getListControl(null));
        Control control = this.fList.getListControl(null);
        GridData gridData = (GridData)control.getLayoutData();
        gridData.verticalAlignment = 1;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(7);
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        this.fList.setElements(Arrays.asList(this.getFavoriteStaticMembersPreference()));
    }

    public void performDefaults() {
        super.performDefaults();
        this.initializeFields();
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
    }

    protected void setControlEnabled(OptionsConfigurationBlock.Key key, boolean bl) {
        Control control = this.getControl(key);
        control.setEnabled(bl);
        Label label = (Label)this.fLabels.get(control);
        if (label != null) {
            label.setEnabled(bl);
        }
    }

    private Control getControl(OptionsConfigurationBlock.Key key) {
        Object object;
        Control control;
        int n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            control = (Control)this.fComboBoxes.get(n);
            object = (OptionsConfigurationBlock.ControlData)control.getData();
            if (key.equals(((OptionsConfigurationBlock.ControlData)object).getKey())) {
                return control;
            }
            --n;
        }
        n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            control = (Control)this.fCheckBoxes.get(n);
            object = (OptionsConfigurationBlock.ControlData)control.getData();
            if (key.equals(((OptionsConfigurationBlock.ControlData)object).getKey())) {
                return control;
            }
            --n;
        }
        n = this.fTextBoxes.size() - 1;
        while (n >= 0) {
            control = (Control)this.fTextBoxes.get(n);
            object = (OptionsConfigurationBlock.Key)control.getData();
            if (key.equals(object)) {
                return control;
            }
            --n;
        }
        return null;
    }

    private void doButtonPressed(int n) {
        if (n == 0 || n == 1) {
            List list = this.fList.getElements();
            FavoriteStaticMemberInputDialog favoriteStaticMemberInputDialog = new FavoriteStaticMemberInputDialog(this.getShell(), list, n == 1);
            if (favoriteStaticMemberInputDialog.open() == 0) {
                this.fList.addElement(favoriteStaticMemberInputDialog.getResult());
            }
        } else if (n == 2) {
            List list = this.fList.getSelectedElements();
            if (list.isEmpty()) {
                return;
            }
            String string = (String)list.get(0);
            List list2 = this.fList.getElements();
            list2.remove(string);
            boolean bl = string.endsWith(WILDCARD);
            FavoriteStaticMemberInputDialog favoriteStaticMemberInputDialog = new FavoriteStaticMemberInputDialog(this.getShell(), list2, !bl);
            if (bl) {
                favoriteStaticMemberInputDialog.setInitialSelection(string.substring(0, string.length() - 2));
            } else {
                favoriteStaticMemberInputDialog.setInitialSelection(string);
            }
            if (favoriteStaticMemberInputDialog.open() == 0) {
                this.fList.replaceElement(string, favoriteStaticMemberInputDialog.getResult());
            }
        }
    }

    protected final void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fList) {
            this.setValue(PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS, CodeAssistFavoritesConfigurationBlock.serializeFavorites(this.fList.getElements()));
        }
    }

    private String[] getFavoriteStaticMembersPreference() {
        String string = this.getValue(PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS);
        if (string != null && string.length() > 0) {
            return CodeAssistFavoritesConfigurationBlock.deserializeFavorites(string);
        }
        return new String[0];
    }

    private static String[] deserializeFavorites(String string) {
        return string.split(";");
    }

    private static String serializeFavorites(List list) {
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((String)list.get(n2));
            if (n2 < n - 1) {
                stringBuffer.append(';');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static class FavoriteStaticMemberInputDialog
    extends StatusDialog {
        private StringButtonDialogField fNameDialogField;
        private List fExistingEntries;
        private final boolean fIsEditingMember;

        public FavoriteStaticMemberInputDialog(Shell shell, List list, boolean bl) {
            super(shell);
            String string;
            String string2;
            this.fIsEditingMember = bl;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fExistingEntries = list;
            if (bl) {
                string2 = PreferencesMessages.FavoriteStaticMemberInputDialog_member_title;
                string = PreferencesMessages.FavoriteStaticMemberInputDialog_member_labelText;
            } else {
                string2 = PreferencesMessages.FavoriteStaticMemberInputDialog_type_title;
                string = PreferencesMessages.FavoriteStaticMemberInputDialog_type_labelText;
            }
            this.setTitle(string2);
            StringButtonAdapter stringButtonAdapter = new StringButtonAdapter();
            this.fNameDialogField = new StringButtonDialogField(stringButtonAdapter);
            this.fNameDialogField.setLabelText(string);
            this.fNameDialogField.setButtonLabel(PreferencesMessages.FavoriteStaticMemberInputDialog_browse_button);
            this.fNameDialogField.setDialogFieldListener(stringButtonAdapter);
            this.fNameDialogField.setText("");
        }

        public void setInitialSelection(String string) {
            Assert.isNotNull((Object)string);
            if (string.length() == 0) {
                this.fNameDialogField.setText("");
            } else {
                this.fNameDialogField.setText(string);
            }
        }

        public String getResult() {
            String string = this.fNameDialogField.getText();
            if (!this.fIsEditingMember) {
                string = String.valueOf(string) + CodeAssistFavoritesConfigurationBlock.WILDCARD;
            }
            return string;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.initializeDialogUnits((Control)composite);
            GridLayout gridLayout = (GridLayout)composite2.getLayout();
            gridLayout.numColumns = 2;
            this.fNameDialogField.doFillIntoGrid(composite2, 3);
            this.fNameDialogField.getChangeControl(null).setVisible(!this.fIsEditingMember);
            LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
            int n = this.convertWidthInCharsToPixels(60);
            Text text = this.fNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, n);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            LayoutUtil.setHorizontalSpan((Control)text, this.fIsEditingMember ? 2 : 1);
            TextFieldNavigationHandler.install(text);
            DialogField.createEmptySpace(composite2, 1);
            this.fNameDialogField.postSetFocusOnDialogField(composite.getDisplay());
            FavoriteStaticMemberInputDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        private void doBrowseTypes() {
            BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
            IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
            int n = 256;
            try {
                SelectionDialog selectionDialog = JavaUI.createTypeDialog(this.getShell(), busyIndicatorRunnableContext, iJavaSearchScope, n, false, this.fNameDialogField.getText());
                selectionDialog.setTitle(PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_title);
                selectionDialog.setMessage(PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_description);
                if (selectionDialog.open() == 0) {
                    IType iType = (IType)selectionDialog.getResult()[0];
                    this.fNameDialogField.setText(iType.getFullyQualifiedName('.'));
                }
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_title, PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_error_message);
            }
        }

        void doDialogFieldChanged(DialogField dialogField) {
            this.doValidation();
        }

        private void doValidation() {
            StatusInfo statusInfo = new StatusInfo();
            String string = this.fNameDialogField.getText();
            if (string.length() == 0) {
                statusInfo.setError("");
            } else {
                IStatus iStatus = JavaConventions.validateJavaTypeName((String)string, (String)"1.3", (String)"1.3");
                if (iStatus.matches(4)) {
                    if (this.fIsEditingMember) {
                        statusInfo.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_invalidMemberName);
                    } else {
                        statusInfo.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_invalidTypeName);
                    }
                } else if (this.doesExist(string, this.fIsEditingMember)) {
                    statusInfo.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_entryExists);
                }
            }
            this.updateStatus(statusInfo);
        }

        private boolean doesExist(String string, boolean bl) {
            int n = 0;
            while (n < this.fExistingEntries.size()) {
                String string2 = (String)this.fExistingEntries.get(n);
                if (string.equals(string2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.java_editor_preference_page_context");
        }

        private class StringButtonAdapter
        implements IDialogFieldListener,
        IStringButtonAdapter {
            private StringButtonAdapter() {
            }

            public void dialogFieldChanged(DialogField dialogField) {
                FavoriteStaticMemberInputDialog.this.doDialogFieldChanged(dialogField);
            }

            public void changeControlPressed(DialogField dialogField) {
                FavoriteStaticMemberInputDialog.this.doBrowseTypes();
            }
        }
    }

    private class ListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ListAdapter() {
        }

        private boolean canEdit(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            return list.size() == 1;
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            CodeAssistFavoritesConfigurationBlock.this.doButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            CodeAssistFavoritesConfigurationBlock.this.fList.enableButton(2, this.canEdit(listDialogField));
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CodeAssistFavoritesConfigurationBlock.this.doDialogFieldChanged(dialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField)) {
                CodeAssistFavoritesConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ListLabelProvider
    extends LabelProvider {
        public final Image MEMBER_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 0, JavaElementImageProvider.SMALL_SIZE);
        private final Image CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object object) {
            return ((String)object).endsWith(CodeAssistFavoritesConfigurationBlock.WILDCARD) ? this.CLASS_ICON : this.MEMBER_ICON;
        }

        public String getText(Object object) {
            return (String)object;
        }
    }
}

