/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.preferences.ImportOrganizeConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class ImportOrganizeInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private SelectionButtonDialogField fBrowseTypeButton;
    private List fExistingEntries;
    private final boolean fIsStatic;

    public ImportOrganizeInputDialog(Shell shell, List list, boolean bl) {
        super(shell);
        String string;
        String string2;
        this.fIsStatic = bl;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fExistingEntries = list;
        if (bl) {
            string2 = PreferencesMessages.ImportOrganizeInputDialog_title_static;
            string = PreferencesMessages.ImportOrganizeInputDialog_name_group_static_label;
        } else {
            string2 = PreferencesMessages.ImportOrganizeInputDialog_title;
            string = PreferencesMessages.ImportOrganizeInputDialog_name_group_label;
        }
        this.setTitle(string2);
        ImportOrganizeInputAdapter importOrganizeInputAdapter = new ImportOrganizeInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(importOrganizeInputAdapter);
        this.fNameDialogField.setLabelText(string);
        this.fNameDialogField.setButtonLabel(PreferencesMessages.ImportOrganizeInputDialog_browse_packages_button);
        this.fNameDialogField.setDialogFieldListener(importOrganizeInputAdapter);
        this.fNameDialogField.setText("");
        this.fBrowseTypeButton = new SelectionButtonDialogField(8);
        this.fBrowseTypeButton.setLabelText(PreferencesMessages.ImportOrganizeInputDialog_browse_types_label);
        this.fBrowseTypeButton.setDialogFieldListener(importOrganizeInputAdapter);
    }

    public void setInitialSelection(ImportOrganizeConfigurationBlock.ImportOrderEntry importOrderEntry) {
        Assert.isNotNull((Object)importOrderEntry);
        if (importOrderEntry.name.length() == 0) {
            this.fNameDialogField.setText("");
        } else {
            this.fNameDialogField.setText(importOrderEntry.name);
        }
    }

    public ImportOrganizeConfigurationBlock.ImportOrderEntry getResult() {
        String string = this.fNameDialogField.getText();
        if ("*".equals(string)) {
            return new ImportOrganizeConfigurationBlock.ImportOrderEntry("", this.fIsStatic);
        }
        return new ImportOrganizeConfigurationBlock.ImportOrderEntry(string, this.fIsStatic);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        this.fNameDialogField.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
        int n = this.convertWidthInCharsToPixels(60);
        Text text = this.fNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, n);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        TextFieldNavigationHandler.install(text);
        DialogField.createEmptySpace(composite2, 1);
        this.fBrowseTypeButton.doFillIntoGrid(composite2, 1);
        this.fNameDialogField.postSetFocusOnDialogField(composite.getDisplay());
        ImportOrganizeInputDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    final void doBrowsePackages() {
        BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        int n = 7;
        PackageSelectionDialog packageSelectionDialog = new PackageSelectionDialog(this.getShell(), busyIndicatorRunnableContext, n, iJavaSearchScope);
        packageSelectionDialog.setFilter(this.fNameDialogField.getText());
        packageSelectionDialog.setIgnoreCase(false);
        packageSelectionDialog.setTitle(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_title);
        packageSelectionDialog.setMessage(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_description);
        packageSelectionDialog.setEmptyListMessage(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_empty);
        if (packageSelectionDialog.open() == 0) {
            IPackageFragment iPackageFragment = (IPackageFragment)packageSelectionDialog.getFirstResult();
            this.fNameDialogField.setText(iPackageFragment.getElementName());
        }
    }

    private void doBrowseTypes() {
        BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        int n = 256;
        try {
            SelectionDialog selectionDialog = JavaUI.createTypeDialog(this.getShell(), busyIndicatorRunnableContext, iJavaSearchScope, n, false, this.fNameDialogField.getText());
            selectionDialog.setTitle(PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_title);
            selectionDialog.setMessage(PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_description);
            if (selectionDialog.open() == 0) {
                IType iType = (IType)selectionDialog.getResult()[0];
                this.fNameDialogField.setText(iType.getFullyQualifiedName('.'));
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_title, PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_error_message);
        }
    }

    final void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fBrowseTypeButton) {
            this.doBrowseTypes();
        } else {
            this.doValidation();
        }
    }

    private void doValidation() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameDialogField.getText();
        if (string.length() == 0) {
            statusInfo.setError("");
        } else if (string.equals("*")) {
            if (this.doesExist("", this.fIsStatic)) {
                statusInfo.setError(PreferencesMessages.ImportOrganizeInputDialog_error_entryExists);
            }
        } else {
            IStatus iStatus = JavaConventions.validateJavaTypeName((String)string, (String)"1.3", (String)"1.3");
            if (iStatus.matches(4)) {
                statusInfo.setError(PreferencesMessages.ImportOrganizeInputDialog_error_invalidName);
            } else if (this.doesExist(string, this.fIsStatic)) {
                statusInfo.setError(PreferencesMessages.ImportOrganizeInputDialog_error_entryExists);
            }
        }
        this.updateStatus(statusInfo);
    }

    private boolean doesExist(String string, boolean bl) {
        int n = 0;
        while (n < this.fExistingEntries.size()) {
            ImportOrganizeConfigurationBlock.ImportOrderEntry importOrderEntry = (ImportOrganizeConfigurationBlock.ImportOrderEntry)this.fExistingEntries.get(n);
            if (string.equals(importOrderEntry.name) && bl == importOrderEntry.isStatic) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.import_organize_input_dialog_context");
    }

    private class ImportOrganizeInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ImportOrganizeInputAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ImportOrganizeInputDialog.this.doDialogFieldChanged(dialogField);
        }

        public void changeControlPressed(DialogField dialogField) {
            ImportOrganizeInputDialog.this.doBrowsePackages();
        }
    }
}

