/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.TypeFilterInputDialog;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;

public class TypeFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String TYPE_FILTER_PREF_PAGE_ID = "org.eclipse.wst.jsdt.ui.preferences.TypeFilterPreferencePage";
    private static final String PREF_FILTER_ENABLED = "org.eclipse.wst.jsdt.ui.typefilter.enabled";
    private static final String PREF_FILTER_DISABLED = "org.eclipse.wst.jsdt.ui.typefilter.disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_PACKAGE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_SELECT = 5;
    private static final int IDX_DESELECT = 6;
    private CheckedListDialogField fFilterListField;

    private static String[] unpackOrderList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private static String packOrderList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            stringBuffer.append((String)list.get(n));
            stringBuffer.append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    public TypeFilterPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.TypeFilterPreferencePage_description);
        String[] stringArray = new String[7];
        stringArray[0] = PreferencesMessages.TypeFilterPreferencePage_add_button;
        stringArray[1] = PreferencesMessages.TypeFilterPreferencePage_addpackage_button;
        stringArray[2] = PreferencesMessages.TypeFilterPreferencePage_edit_button;
        stringArray[3] = PreferencesMessages.TypeFilterPreferencePage_remove_button;
        stringArray[5] = PreferencesMessages.TypeFilterPreferencePage_selectall_button;
        stringArray[6] = PreferencesMessages.TypeFilterPreferencePage_deselectall_button;
        String[] stringArray2 = stringArray;
        TypeFilterAdapter typeFilterAdapter = new TypeFilterAdapter();
        this.fFilterListField = new CheckedListDialogField(typeFilterAdapter, stringArray2, (ILabelProvider)new LabelProvider());
        this.fFilterListField.setDialogFieldListener(typeFilterAdapter);
        this.fFilterListField.setLabelText(PreferencesMessages.TypeFilterPreferencePage_list_label);
        this.fFilterListField.setCheckAllButtonIndex(5);
        this.fFilterListField.setUncheckAllButtonIndex(6);
        this.fFilterListField.setRemoveButtonIndex(3);
        this.fFilterListField.enableButton(2, false);
        this.initialize(false);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.type_filter_preference_page_context");
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fFilterListField.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fFilterListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fFilterListField.getLabelControl(null), this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fFilterListField.getListControl(null));
        this.fFilterListField.getTableViewer().setComparator(new ViewerComparator());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void initialize(boolean bl) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = bl ? iPreferenceStore.getDefaultString(PREF_FILTER_ENABLED) : iPreferenceStore.getString(PREF_FILTER_ENABLED);
        String string2 = bl ? iPreferenceStore.getDefaultString(PREF_FILTER_DISABLED) : iPreferenceStore.getString(PREF_FILTER_DISABLED);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = TypeFilterPreferencePage.unpackOrderList(string);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = TypeFilterPreferencePage.unpackOrderList(string2);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            arrayList.add(stringArray2[n2]);
            ++n2;
        }
        this.fFilterListField.setElements(arrayList);
        this.fFilterListField.setCheckedElements(Arrays.asList(stringArray));
    }

    private void doButtonPressed(int n) {
        if (n == 0) {
            List list = this.fFilterListField.getElements();
            TypeFilterInputDialog typeFilterInputDialog = new TypeFilterInputDialog(this.getShell(), list);
            if (typeFilterInputDialog.open() == 0) {
                Object object = typeFilterInputDialog.getResult();
                this.fFilterListField.addElement(object);
                this.fFilterListField.setChecked(object, true);
            }
        } else if (n == 1) {
            String[] stringArray = this.choosePackage();
            if (stringArray != null) {
                this.fFilterListField.addElements(Arrays.asList(stringArray));
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.fFilterListField.setChecked(stringArray[n2], true);
                    ++n2;
                }
            }
        } else if (n == 2) {
            List list = this.fFilterListField.getSelectedElements();
            if (list.isEmpty()) {
                return;
            }
            String string = (String)list.get(0);
            List list2 = this.fFilterListField.getElements();
            list2.remove(string);
            TypeFilterInputDialog typeFilterInputDialog = new TypeFilterInputDialog(this.getShell(), list2);
            typeFilterInputDialog.setInitialString(string);
            if (typeFilterInputDialog.open() == 0) {
                this.fFilterListField.replaceElement(string, typeFilterInputDialog.getResult());
            }
        }
    }

    private String[] choosePackage() {
        IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
        int n = 7;
        PackageSelectionDialog packageSelectionDialog = new PackageSelectionDialog(this.getShell(), busyIndicatorRunnableContext, n, iJavaSearchScope);
        packageSelectionDialog.setTitle(PreferencesMessages.TypeFilterPreferencePage_choosepackage_label);
        packageSelectionDialog.setMessage(PreferencesMessages.TypeFilterPreferencePage_choosepackage_description);
        packageSelectionDialog.setMultipleSelection(true);
        if (packageSelectionDialog.open() == 0) {
            Object[] objectArray = packageSelectionDialog.getResult();
            String[] stringArray = new String[objectArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = String.valueOf(((IPackageFragment)objectArray[n2]).getElementName()) + ".*";
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        this.initialize(true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        List list = this.fFilterListField.getCheckedElements();
        List list2 = this.fFilterListField.getElements();
        list2.removeAll(list);
        iPreferenceStore.setValue(PREF_FILTER_ENABLED, TypeFilterPreferencePage.packOrderList(list));
        iPreferenceStore.setValue(PREF_FILTER_DISABLED, TypeFilterPreferencePage.packOrderList(list2));
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private class TypeFilterAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TypeFilterAdapter() {
        }

        private boolean canEdit(ListDialogField listDialogField) {
            return listDialogField.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            TypeFilterPreferencePage.this.doButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            TypeFilterPreferencePage.this.fFilterListField.enableButton(2, this.canEdit(listDialogField));
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField)) {
                TypeFilterPreferencePage.this.doButtonPressed(2);
            }
        }
    }
}

