/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenAction
extends SelectionDispatchAction {
    private PropertiesFileEditor fEditor;

    public OpenAction(PropertiesFileEditor propertiesFileEditor) {
        super((IWorkbenchSite)propertiesFileEditor.getEditorSite());
        this.fEditor = propertiesFileEditor;
        this.setText(PropertiesFileEditorMessages.OpenAction_label);
        this.setToolTipText(PropertiesFileEditorMessages.OpenAction_tooltip);
        this.setEnabled(this.fEditor.getEditorInput() instanceof IFileEditorInput);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(this.checkEnabled(iTextSelection));
    }

    private boolean checkEnabled(ITextSelection iTextSelection) {
        if (iTextSelection == null || iTextSelection.isEmpty()) {
            return false;
        }
        return this.fEditor.getEditorInput() instanceof IFileEditorInput;
    }

    public void run(ITextSelection iTextSelection) {
        if (!this.checkEnabled(iTextSelection)) {
            return;
        }
        Region region = new Region(iTextSelection.getOffset(), iTextSelection.getLength());
        PropertyKeyHyperlinkDetector propertyKeyHyperlinkDetector = new PropertyKeyHyperlinkDetector();
        propertyKeyHyperlinkDetector.setContext((IAdaptable)this.fEditor);
        IHyperlink[] iHyperlinkArray = propertyKeyHyperlinkDetector.detectHyperlinks((ITextViewer)this.fEditor.internalGetSourceViewer(), (IRegion)region, false);
        if (iHyperlinkArray != null && iHyperlinkArray.length == 1) {
            iHyperlinkArray[0].open();
        }
    }
}

