/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeExceptionsControl;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.wst.jsdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IExceptionListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class ChangeSignatureWizard
extends RefactoringWizard {
    public ChangeSignatureWizard(ChangeSignatureRefactoring changeSignatureRefactoring) {
        super((Refactoring)changeSignatureRefactoring, 4);
        this.setDefaultPageTitle(RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeSignatureInputPage());
    }

    private static class ChangeSignatureInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeSignatureInputPage";
        private JavaSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;

        public ChangeSignatureInputPage() {
            super(PAGE_NAME);
            this.setMessage(RefactoringMessages.ChangeSignatureInputPage_change);
            this.fSignaturePreviewDocument = new Document();
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            this.initializeDialogUnits((Control)composite2);
            try {
                Label label;
                this.createHeadControls(composite2);
                this.createParameterExceptionsFolder(composite2);
                this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(composite2, this.getRefactoring(), false);
                if (this.fLeaveDelegateCheckBox != null) {
                    this.fDeprecateDelegateCheckBox = new Button(composite2, 32);
                    label = new GridData();
                    label.horizontalAlignment = 4;
                    label.horizontalIndent = gridLayout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                    label.horizontalSpan = 2;
                    this.fDeprecateDelegateCheckBox.setLayoutData((Object)label);
                    this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                    ChangeSignatureRefactoring changeSignatureRefactoring = this.getChangeMethodSignatureRefactoring();
                    this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(changeSignatureRefactoring));
                    changeSignatureRefactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                    this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, changeSignatureRefactoring){
                        final /* synthetic */ ChangeSignatureInputPage this$1;
                        private final /* synthetic */ ChangeSignatureRefactoring val$refactoring;
                        {
                            this.this$1 = changeSignatureInputPage;
                            this.val$refactoring = changeSignatureRefactoring;
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            this.val$refactoring.setDeprecateDelegates(ChangeSignatureInputPage.access$0(this.this$1).getSelection());
                        }
                    });
                    this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                    this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                        final /* synthetic */ ChangeSignatureInputPage this$1;
                        {
                            this.this$1 = changeSignatureInputPage;
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            ChangeSignatureInputPage.access$0(this.this$1).setEnabled(ChangeSignatureInputPage.access$1(this.this$1).getSelection());
                        }
                    });
                }
                label = new Label(composite2, 258);
                label.setLayoutData((Object)new GridData(768));
                this.createSignaturePreview(composite2);
                this.update(false);
                this.setControl((Control)composite2);
                Dialog.applyDialogFont((Control)composite2);
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ChangeSignatureInputPage_Change_Signature, RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.modify_parameters_wizard_page_context");
        }

        private void createHeadControls(Composite composite) throws JavaModelException {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            this.createAccessControl(composite2);
            this.createReturnTypeControl(composite2);
            this.createNameControl(composite2);
        }

        private void createAccessControl(Composite composite) throws JavaModelException {
            int n;
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            int[] nArray = this.getChangeMethodSignatureRefactoring().getAvailableVisibilities();
            int n2 = this.getChangeMethodSignatureRefactoring().getVisibility();
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_access_modifier);
            Combo combo = new Combo(composite2, 12);
            if (nArray.length == 0) {
                combo.setEnabled(false);
            } else {
                n = 0;
                while (n < nArray.length) {
                    combo.add(this.getAccessModifierString(nArray[n]));
                    ++n;
                }
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, nArray, combo){
                    final /* synthetic */ ChangeSignatureInputPage this$1;
                    private final /* synthetic */ int[] val$availableVisibilities;
                    private final /* synthetic */ Combo val$combo;
                    {
                        this.this$1 = changeSignatureInputPage;
                        this.val$availableVisibilities = nArray;
                        this.val$combo = combo;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        int n = this.val$availableVisibilities[this.val$combo.getSelectionIndex()];
                        ChangeSignatureInputPage.access$2(this.this$1).setVisibility(n);
                        ChangeSignatureInputPage.access$3(this.this$1, true);
                    }
                });
            }
            combo.setText(this.getAccessModifierString(n2));
            combo.setLayoutData((Object)new GridData(256));
            Dialog.applyDialogFont((Control)composite2);
            composite2.pack();
            n = label.getSize().x + 3 * gridLayout.horizontalSpacing;
            if (n > combo.getSize().x) {
                label.setLayoutData((Object)new GridData(n, label.getSize().y));
            }
        }

        private String getAccessModifierString(int n) {
            switch (n) {
                case 1: {
                    return "public";
                }
                case 4: {
                    return "protected";
                }
                case 0: {
                    return RefactoringMessages.ChangeSignatureInputPage_default;
                }
                case 2: {
                    return "private";
                }
            }
            throw new IllegalArgumentException("\"" + n + "\" is not a Modifier constant");
        }

        private void createReturnTypeControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(1808));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_return_type);
            Text text = new Text(composite2, 2048);
            text.setText(this.getChangeMethodSignatureRefactoring().getReturnTypeString());
            text.setLayoutData((Object)new GridData(768));
            TextFieldNavigationHandler.install(text);
            if (this.getChangeMethodSignatureRefactoring().canChangeNameAndReturnType()) {
                text.addModifyListener(new ModifyListener(this, text){
                    final /* synthetic */ ChangeSignatureInputPage this$1;
                    private final /* synthetic */ Text val$text;
                    {
                        this.this$1 = changeSignatureInputPage;
                        this.val$text = text;
                    }

                    public void modifyText(ModifyEvent modifyEvent) {
                        ChangeSignatureInputPage.access$2(this.this$1).setNewReturnTypeName(this.val$text.getText());
                        ChangeSignatureInputPage.access$3(this.this$1, true);
                    }
                });
            } else {
                text.setEnabled(false);
            }
            JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(true, true);
            StubTypeContext stubTypeContext = this.getChangeMethodSignatureRefactoring().getStubTypeContext();
            javaTypeCompletionProcessor.setCompletionContext(stubTypeContext.getCuHandle(), stubTypeContext.getBeforeString(), stubTypeContext.getAfterString());
            ControlContentAssistHelper.createTextContentAssistant(text, javaTypeCompletionProcessor);
        }

        private void createNameControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(1808));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_method_name);
            Text text = new Text(composite2, 2048);
            text.setText(this.getChangeMethodSignatureRefactoring().getMethodName());
            text.setLayoutData((Object)new GridData(768));
            TextFieldNavigationHandler.install(text);
            if (this.getChangeMethodSignatureRefactoring().canChangeNameAndReturnType()) {
                text.addModifyListener(new ModifyListener(this, text){
                    final /* synthetic */ ChangeSignatureInputPage this$1;
                    private final /* synthetic */ Text val$text;
                    {
                        this.this$1 = changeSignatureInputPage;
                        this.val$text = text;
                    }

                    public void modifyText(ModifyEvent modifyEvent) {
                        ChangeSignatureInputPage.access$2(this.this$1).setNewMethodName(this.val$text.getText());
                        ChangeSignatureInputPage.access$3(this.this$1, true);
                    }
                });
            } else {
                text.setEnabled(false);
            }
        }

        private void createParameterExceptionsFolder(Composite composite) {
            TabFolder tabFolder = new TabFolder(composite, 128);
            tabFolder.setLayoutData((Object)new GridData(1808));
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(RefactoringMessages.ChangeSignatureInputPage_parameters);
            tabItem.setControl(this.createParameterTableControl((Composite)tabFolder));
            TabItem tabItem2 = new TabItem(tabFolder, 0);
            tabItem2.setText(RefactoringMessages.ChangeSignatureInputPage_exceptions);
            tabItem2.setControl(this.createExceptionsTableControl((Composite)tabFolder));
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((TabItem)selectionEvent.item).getControl().setFocus();
                }
            });
        }

        private Control createParameterTableControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            String string = null;
            ChangeParametersControl changeParametersControl = new ChangeParametersControl(composite2, 0, string, new IParameterListChangeListener(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void parameterChanged(ParameterInfo parameterInfo) {
                    ChangeSignatureInputPage.access$3(this.this$1, true);
                }

                public void parameterListChanged() {
                    ChangeSignatureInputPage.access$3(this.this$1, true);
                }

                public void parameterAdded(ParameterInfo parameterInfo) {
                    ChangeSignatureInputPage.access$3(this.this$1, true);
                }
            }, ChangeParametersControl.Mode.CHANGE_METHOD_SIGNATURE, this.getChangeMethodSignatureRefactoring().getStubTypeContext());
            changeParametersControl.setLayoutData(new GridData(1808));
            changeParametersControl.setInput(this.getChangeMethodSignatureRefactoring().getParameterInfos());
            return composite2;
        }

        private Control createExceptionsTableControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            ChangeExceptionsControl changeExceptionsControl = new ChangeExceptionsControl(composite2, 0, new IExceptionListChangeListener(this){
                final /* synthetic */ ChangeSignatureInputPage this$1;
                {
                    this.this$1 = changeSignatureInputPage;
                }

                public void exceptionListChanged() {
                    ChangeSignatureInputPage.access$3(this.this$1, true);
                }
            }, this.getChangeMethodSignatureRefactoring().getMethod().getJavaProject());
            changeExceptionsControl.setLayoutData(new GridData(1808));
            changeExceptionsControl.setInput(this.getChangeMethodSignatureRefactoring().getExceptionInfos());
            return composite2;
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void createSignaturePreview(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, iPreferenceStore);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), iPreferenceStore, null, null));
            this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control control = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(control);
            GridData gridData = new GridData(1808);
            gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            control.setLayoutData((Object)gridData);
        }

        private ChangeSignatureRefactoring getChangeMethodSignatureRefactoring() {
            return (ChangeSignatureRefactoring)this.getRefactoring();
        }

        private void update(boolean bl) {
            this.updateStatus(bl);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean bl) {
            try {
                if (this.getChangeMethodSignatureRefactoring().isSignatureSameAsInitial()) {
                    if (bl) {
                        this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_unchanged);
                    } else {
                        this.setErrorMessage(null);
                    }
                    this.setPageComplete(false);
                    return;
                }
                RefactoringStatus refactoringStatus = this.getChangeMethodSignatureRefactoring().checkSignature();
                if (bl) {
                    this.setPageComplete(refactoringStatus);
                } else {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
            catch (JavaModelException javaModelException) {
                this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
                this.setPageComplete(false);
                JavaPlugin.log(javaModelException);
            }
        }

        private void updateSignaturePreview() {
            try {
                int n = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.getChangeMethodSignatureRefactoring().getNewMethodSignature());
                this.fSignaturePreview.getTextWidget().setTopPixel(n);
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters, RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }

        static /* synthetic */ Button access$0(ChangeSignatureInputPage changeSignatureInputPage) {
            return changeSignatureInputPage.fDeprecateDelegateCheckBox;
        }

        static /* synthetic */ Button access$1(ChangeSignatureInputPage changeSignatureInputPage) {
            return changeSignatureInputPage.fLeaveDelegateCheckBox;
        }

        static /* synthetic */ ChangeSignatureRefactoring access$2(ChangeSignatureInputPage changeSignatureInputPage) {
            return changeSignatureInputPage.getChangeMethodSignatureRefactoring();
        }

        static /* synthetic */ void access$3(ChangeSignatureInputPage changeSignatureInputPage, boolean bl) {
            changeSignatureInputPage.update(bl);
        }
    }
}

