/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;

public class ExtractInterfaceWizard
extends RefactoringWizard {
    public ExtractInterfaceWizard(ExtractInterfaceRefactoring extractInterfaceRefactoring) {
        super((Refactoring)extractInterfaceRefactoring, 4);
        this.setDefaultPageTitle(RefactoringMessages.ExtractInterfaceWizard_Extract_Interface);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractInterfaceInputPage());
    }

    private static class ExtractInterfaceInputPage
    extends TextInputWizardPage {
        private Button fReplaceAllCheckbox;
        private Button fDeclarePublicCheckbox;
        private Button fDeclareAbstractCheckbox;
        private Button fGenerateCommentsCheckbox;
        private Button fInstanceofCheckbox;
        private CheckboxTableViewer fTableViewer;
        private static final String DESCRIPTION = RefactoringMessages.ExtractInterfaceInputPage_description;
        private static final String SETTING_PUBLIC = "Public";
        private static final String SETTING_ABSTRACT = "Abstract";
        private static final String SETTING_REPLACE = "Replace";
        private static final String SETTING_COMMENTS = "Comments";
        private static final String SETTING_INSTANCEOF = "InstanceOf";
        private Button fSelectAllButton;
        private Button fDeselectAllButton;

        public ExtractInterfaceInputPage() {
            super(DESCRIPTION, true);
        }

        public void createControl(Composite composite) {
            this.initializeDialogUnits((Control)composite);
            Composite composite2 = new Composite(composite, 0);
            this.setControl((Control)composite2);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ExtractInterfaceInputPage_Interface_name);
            Text text = this.createTextInputField(composite2);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            this.addReplaceAllCheckbox(composite2);
            this.addInstanceofCheckbox(composite2, gridLayout.marginWidth);
            this.fReplaceAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                {
                    this.this$1 = extractInterfaceInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractInterfaceInputPage.access$0(this.this$1).setEnabled(ExtractInterfaceInputPage.access$1(this.this$1).getSelection());
                }
            });
            this.addDeclareAsPublicCheckbox(composite2);
            this.addDeclareAsAbstractCheckbox(composite2);
            Label label2 = new Label(composite2, 0);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            label2.setLayoutData((Object)gridData);
            Label label3 = new Label(composite2, 0);
            label3.setText(RefactoringMessages.ExtractInterfaceInputPage_Members);
            label3.setEnabled(this.anyMembersToExtract());
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label3.setLayoutData((Object)gridData);
            this.addMemberListComposite(composite2);
            this.addGenerateCommentsCheckbox(composite2);
            Dialog.applyDialogFont((Control)composite2);
            this.initializeCheckboxes();
            this.updateUIElementEnablement();
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.extract_interface_temp_page_context");
        }

        private void addGenerateCommentsCheckbox(Composite composite) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            String string = RefactoringMessages.ExtractInterfaceWizard_generate_comments;
            this.fGenerateCommentsCheckbox = ExtractInterfaceInputPage.createCheckbox(composite, string, false);
            extractInterfaceProcessor.setComments(this.fGenerateCommentsCheckbox.getSelection());
            this.fGenerateCommentsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, extractInterfaceProcessor){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                private final /* synthetic */ ExtractInterfaceProcessor val$processor;
                {
                    this.this$1 = extractInterfaceInputPage;
                    this.val$processor = extractInterfaceProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setComments(ExtractInterfaceInputPage.access$2(this.this$1).getSelection());
                }
            });
        }

        private void addInstanceofCheckbox(Composite composite, int n) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            String string = RefactoringMessages.ExtractInterfaceWizard_use_supertype;
            this.fInstanceofCheckbox = new Button(composite, 32);
            this.fInstanceofCheckbox.setSelection(false);
            GridData gridData = new GridData();
            gridData.horizontalIndent = n + this.fInstanceofCheckbox.computeSize((int)-1, (int)-1).x;
            gridData.horizontalSpan = 2;
            this.fInstanceofCheckbox.setLayoutData((Object)gridData);
            this.fInstanceofCheckbox.setText(string);
            extractInterfaceProcessor.setInstanceOf(this.fInstanceofCheckbox.getSelection());
            this.fInstanceofCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, extractInterfaceProcessor){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                private final /* synthetic */ SuperTypeRefactoringProcessor val$processor;
                {
                    this.this$1 = extractInterfaceInputPage;
                    this.val$processor = superTypeRefactoringProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setInstanceOf(ExtractInterfaceInputPage.access$0(this.this$1).getSelection());
                }
            });
        }

        private void addMemberListComposite(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(12);
            gridData.horizontalSpan = 2;
            composite2.setLayoutData((Object)gridData);
            this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2816);
            this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            try {
                this.fTableViewer.setInput((Object)this.getExtractableMembers());
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ExtractInterfaceInputPage_Extract_Interface, RefactoringMessages.ExtractInterfaceInputPage_Internal_Error);
                this.fTableViewer.setInput((Object)new IMember[0]);
            }
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(this){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                {
                    this.this$1 = extractInterfaceInputPage;
                }

                public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                    this.this$1.updateUIElementEnablement();
                }
            });
            this.fTableViewer.setComparator((ViewerComparator)new JavaElementComparator());
            this.fTableViewer.getControl().setEnabled(this.anyMembersToExtract());
            this.createButtonComposite(composite2);
        }

        private IMember[] getExtractableMembers() throws JavaModelException {
            return this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor().getExtractableMembers();
        }

        protected void updateUIElementEnablement() {
            IMember[] iMemberArray;
            IMember[] iMemberArray2 = this.getCheckedMembers();
            try {
                iMemberArray = this.getExtractableMembers();
            }
            catch (JavaModelException javaModelException) {
                iMemberArray = new IMember[]{};
                JavaPlugin.log(javaModelException);
            }
            boolean bl = ExtractInterfaceInputPage.containsMethods(iMemberArray2);
            this.fDeclarePublicCheckbox.setEnabled(bl);
            this.fDeclareAbstractCheckbox.setEnabled(bl);
            this.fGenerateCommentsCheckbox.setEnabled(bl);
            this.fInstanceofCheckbox.setEnabled(this.fReplaceAllCheckbox.getSelection());
            this.fSelectAllButton.setEnabled(iMemberArray2.length < iMemberArray.length);
            this.fDeselectAllButton.setEnabled(iMemberArray2.length > 0);
        }

        private static boolean containsMethods(IMember[] iMemberArray) {
            int n = 0;
            while (n < iMemberArray.length) {
                if (iMemberArray[n].getElementType() == 9) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private ILabelProvider createLabelProvider() {
            AppearanceAwareLabelProvider appearanceAwareLabelProvider = new AppearanceAwareLabelProvider(36283885830185L, 1);
            return new DecoratingJavaLabelProvider(appearanceAwareLabelProvider);
        }

        private void createButtonComposite(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1040);
            composite2.setLayoutData((Object)gridData);
            this.fSelectAllButton = new Button(composite2, 8);
            this.fSelectAllButton.setText(RefactoringMessages.ExtractInterfaceInputPage_Select_All);
            this.fSelectAllButton.setEnabled(this.anyMembersToExtract());
            this.fSelectAllButton.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
            this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                {
                    this.this$1 = extractInterfaceInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractInterfaceInputPage.access$3(this.this$1).setAllChecked(true);
                    this.this$1.updateUIElementEnablement();
                }
            });
            this.fDeselectAllButton = new Button(composite2, 8);
            this.fDeselectAllButton.setText(RefactoringMessages.ExtractInterfaceInputPage_Deselect_All);
            this.fDeselectAllButton.setEnabled(this.anyMembersToExtract());
            this.fDeselectAllButton.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
            this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                {
                    this.this$1 = extractInterfaceInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractInterfaceInputPage.access$3(this.this$1).setAllChecked(false);
                    this.this$1.updateUIElementEnablement();
                }
            });
        }

        private boolean anyMembersToExtract() {
            try {
                return this.getExtractableMembers().length > 0;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        private void addReplaceAllCheckbox(Composite composite) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            String string = RefactoringMessages.ExtractInterfaceInputPage_change_references;
            boolean bl = extractInterfaceProcessor.isReplace();
            this.fReplaceAllCheckbox = ExtractInterfaceInputPage.createCheckbox(composite, string, bl);
            extractInterfaceProcessor.setReplace(this.fReplaceAllCheckbox.getSelection());
            this.fReplaceAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, extractInterfaceProcessor){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                private final /* synthetic */ ExtractInterfaceProcessor val$processor;
                {
                    this.this$1 = extractInterfaceInputPage;
                    this.val$processor = extractInterfaceProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setReplace(ExtractInterfaceInputPage.access$1(this.this$1).getSelection());
                }
            });
        }

        private void addDeclareAsPublicCheckbox(Composite composite) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            Object[] objectArray = new String[]{RefactoringMessages.ExtractInterfaceWizard_public_label};
            String string = Messages.format(RefactoringMessages.ExtractInterfaceWizard_12, objectArray);
            boolean bl = extractInterfaceProcessor.getPublic();
            this.fDeclarePublicCheckbox = ExtractInterfaceInputPage.createCheckbox(composite, string, bl);
            extractInterfaceProcessor.setPublic(this.fDeclarePublicCheckbox.getSelection());
            this.fDeclarePublicCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, extractInterfaceProcessor){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                private final /* synthetic */ ExtractInterfaceProcessor val$processor;
                {
                    this.this$1 = extractInterfaceInputPage;
                    this.val$processor = extractInterfaceProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setPublic(ExtractInterfaceInputPage.access$4(this.this$1).getSelection());
                }
            });
        }

        private void addDeclareAsAbstractCheckbox(Composite composite) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            Object[] objectArray = new String[]{RefactoringMessages.ExtractInterfaceWizard_abstract_label};
            String string = Messages.format(RefactoringMessages.ExtractInterfaceWizard_12, objectArray);
            boolean bl = extractInterfaceProcessor.getAbstract();
            this.fDeclareAbstractCheckbox = ExtractInterfaceInputPage.createCheckbox(composite, string, bl);
            extractInterfaceProcessor.setAbstract(this.fDeclareAbstractCheckbox.getSelection());
            this.fDeclareAbstractCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, extractInterfaceProcessor){
                final /* synthetic */ ExtractInterfaceInputPage this$1;
                private final /* synthetic */ ExtractInterfaceProcessor val$processor;
                {
                    this.this$1 = extractInterfaceInputPage;
                    this.val$processor = extractInterfaceProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setAbstract(ExtractInterfaceInputPage.access$5(this.this$1).getSelection());
                }
            });
        }

        private static Button createCheckbox(Composite composite, String string, boolean bl) {
            Button button = new Button(composite, 32);
            button.setText(string);
            button.setSelection(bl);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            button.setLayoutData((Object)gridData);
            return button;
        }

        protected RefactoringStatus validateTextField(String string) {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            extractInterfaceProcessor.setTypeName(string);
            return extractInterfaceProcessor.checkTypeName(string);
        }

        private ExtractInterfaceRefactoring getExtractInterfaceRefactoring() {
            return (ExtractInterfaceRefactoring)this.getRefactoring();
        }

        public IWizardPage getNextPage() {
            try {
                this.initializeRefactoring();
                this.storeDialogSettings();
                return super.getNextPage();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return null;
            }
        }

        public boolean performFinish() {
            try {
                this.initializeRefactoring();
                this.storeDialogSettings();
                return super.performFinish();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return false;
            }
        }

        private void initializeRefactoring() throws JavaModelException {
            ExtractInterfaceProcessor extractInterfaceProcessor = this.getExtractInterfaceRefactoring().getExtractInterfaceProcessor();
            extractInterfaceProcessor.setTypeName(this.getText());
            extractInterfaceProcessor.setReplace(this.fReplaceAllCheckbox.getSelection());
            extractInterfaceProcessor.setExtractedMembers(this.getCheckedMembers());
            extractInterfaceProcessor.setAbstract(this.fDeclareAbstractCheckbox.getSelection());
            extractInterfaceProcessor.setPublic(this.fDeclarePublicCheckbox.getSelection());
            extractInterfaceProcessor.setComments(this.fGenerateCommentsCheckbox.getSelection());
            extractInterfaceProcessor.setInstanceOf(this.fInstanceofCheckbox.getSelection());
        }

        private IMember[] getCheckedMembers() {
            List<Object> list = Arrays.asList(this.fTableViewer.getCheckedElements());
            return list.toArray(new IMember[list.size()]);
        }

        public void dispose() {
            this.fInstanceofCheckbox = null;
            this.fGenerateCommentsCheckbox = null;
            this.fReplaceAllCheckbox = null;
            this.fTableViewer = null;
            super.dispose();
        }

        private void initializeCheckboxes() {
            this.initializeCheckBox(this.fDeclarePublicCheckbox, SETTING_PUBLIC, true);
            this.initializeCheckBox(this.fDeclareAbstractCheckbox, SETTING_ABSTRACT, true);
            this.initializeCheckBox(this.fReplaceAllCheckbox, SETTING_REPLACE, true);
            this.initializeCheckBox(this.fGenerateCommentsCheckbox, SETTING_COMMENTS, true);
            this.initializeCheckBox(this.fInstanceofCheckbox, SETTING_INSTANCEOF, false);
        }

        private void initializeCheckBox(Button button, String string, boolean bl) {
            String string2 = JavaPlugin.getDefault().getDialogSettings().get(string);
            if (string2 != null) {
                button.setSelection(new Boolean(string2).booleanValue());
            } else {
                button.setSelection(bl);
            }
        }

        private void storeDialogSettings() {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            iDialogSettings.put(SETTING_PUBLIC, this.fDeclarePublicCheckbox.getSelection());
            iDialogSettings.put(SETTING_ABSTRACT, this.fDeclareAbstractCheckbox.getSelection());
            iDialogSettings.put(SETTING_REPLACE, this.fReplaceAllCheckbox.getSelection());
            iDialogSettings.put(SETTING_COMMENTS, this.fGenerateCommentsCheckbox.getSelection());
            iDialogSettings.put(SETTING_INSTANCEOF, this.fInstanceofCheckbox.getSelection());
        }

        static /* synthetic */ Button access$0(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fInstanceofCheckbox;
        }

        static /* synthetic */ Button access$1(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fReplaceAllCheckbox;
        }

        static /* synthetic */ Button access$2(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fGenerateCommentsCheckbox;
        }

        static /* synthetic */ CheckboxTableViewer access$3(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fTableViewer;
        }

        static /* synthetic */ Button access$4(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fDeclarePublicCheckbox;
        }

        static /* synthetic */ Button access$5(ExtractInterfaceInputPage extractInterfaceInputPage) {
            return extractInterfaceInputPage.fDeclareAbstractCheckbox;
        }
    }
}

