/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class IntroduceFactoryInputPage
extends UserInputWizardPage {
    private Text fMethodName;
    private RefactoringStatus fMethodNameStatus;
    private RefactoringStatus fDestinationStatus;

    public IntroduceFactoryInputPage(String string) {
        super(string);
    }

    private Text createTextInputField(Composite composite) {
        Text text = new Text(composite, 18436);
        text.selectAll();
        TextFieldNavigationHandler.install(text);
        return text;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(RefactoringMessages.IntroduceFactoryInputPage_method_name);
        this.fMethodName = this.createTextInputField(composite2);
        GridData gridData = new GridData(768);
        this.fMethodName.setLayoutData((Object)gridData);
        this.fMethodName.setText(this.getUseFactoryRefactoring().getNewMethodName());
        Label label2 = new Label(composite2, 0);
        label2.setText(RefactoringMessages.IntroduceFactoryInputPage_factoryClassLabel);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(768));
        final Text text = this.createTextInputField(composite3);
        text.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite3, 8);
        button.setText(RefactoringMessages.IntroduceFactoryInputPage_browseLabel);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        final Button button2 = new Button(composite2, 32);
        button2.setText(RefactoringMessages.IntroduceFactoryInputPage_protectConstructorLabel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button2.setLayoutData((Object)gridData);
        this.fMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                IntroduceFactoryInputPage.this.fMethodNameStatus = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setNewMethodName(IntroduceFactoryInputPage.this.fMethodName.getText());
                IntroduceFactoryInputPage.this.validateInput(true);
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button2.getSelection();
                IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setProtectConstructor(bl);
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                IntroduceFactoryInputPage.this.fDestinationStatus = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setFactoryClass(text.getText());
                IntroduceFactoryInputPage.this.validateInput(false);
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IType iType = IntroduceFactoryInputPage.this.chooseFactoryClass();
                if (iType == null) {
                    return;
                }
                RefactoringStatus refactoringStatus = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setFactoryClass(iType.getFullyQualifiedName());
                boolean bl = refactoringStatus.isOK();
                text.setText(iType.getFullyQualifiedName());
                IntroduceFactoryInputPage.this.setPageComplete(bl);
                IntroduceFactoryInputPage.this.setErrorMessage(bl ? "" : refactoringStatus.getMessageMatchingSeverity(3));
            }
        });
        if (this.getUseFactoryRefactoring().canProtectConstructor()) {
            button2.setSelection(true);
        } else {
            button2.setSelection(false);
            button2.setEnabled(false);
            this.getUseFactoryRefactoring().setProtectConstructor(false);
        }
        text.setText(this.getUseFactoryRefactoring().getFactoryClassName());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.introduce_factory_wizard_page_context");
    }

    private IType chooseFactoryClass() {
        IJavaProject iJavaProject = this.getUseFactoryRefactoring().getProject();
        if (iJavaProject == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{iJavaProject};
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray);
        FilteredTypesSelectionDialog filteredTypesSelectionDialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), iJavaSearchScope, 5);
        filteredTypesSelectionDialog.setTitle(RefactoringMessages.IntroduceFactoryInputPage_chooseFactoryClass_title);
        filteredTypesSelectionDialog.setMessage(RefactoringMessages.IntroduceFactoryInputPage_chooseFactoryClass_message);
        if (filteredTypesSelectionDialog.open() == 0) {
            return (IType)filteredTypesSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IntroduceFactoryRefactoring getUseFactoryRefactoring() {
        return (IntroduceFactoryRefactoring)this.getRefactoring();
    }

    private void validateInput(boolean bl) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fMethodNameStatus != null && (bl || this.fMethodNameStatus.hasError())) {
            refactoringStatus.merge(this.fMethodNameStatus);
        }
        if (this.fDestinationStatus != null && (!bl || this.fDestinationStatus.hasError())) {
            refactoringStatus.merge(this.fDestinationStatus);
        }
        this.setPageComplete(!refactoringStatus.hasError());
        int n = refactoringStatus.getSeverity();
        String string = refactoringStatus.getMessageMatchingSeverity(n);
        if (n >= 1) {
            this.setMessage(string, n);
        } else {
            this.setMessage("", 0);
        }
    }
}

