/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class JavaStatusContextViewer
extends TextStatusContextViewer {
    public void createControl(Composite composite) {
        super.createControl(composite);
        SourceViewer sourceViewer = this.getSourceViewer();
        sourceViewer.unconfigure();
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        sourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), iPreferenceStore, null, null));
        sourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
    }

    protected SourceViewer createSourceViewer(Composite composite) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        return new JavaSourceViewer(composite, null, null, false, 33620738, iPreferenceStore);
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IClassFile iClassFile) {
        IJavaElement iJavaElement = iClassFile.getParent();
        while (iJavaElement != null && iJavaElement.getElementType() != 3) {
            iJavaElement = iJavaElement.getParent();
        }
        return (IPackageFragmentRoot)iJavaElement;
    }

    public void setInput(RefactoringStatusContext refactoringStatusContext) {
        if (refactoringStatusContext instanceof JavaStatusContext) {
            JavaStatusContext javaStatusContext = (JavaStatusContext)refactoringStatusContext;
            IDocument iDocument = null;
            if (javaStatusContext.isBinary()) {
                IClassFile iClassFile = javaStatusContext.getClassFile();
                InternalClassFileEditorInput internalClassFileEditorInput = new InternalClassFileEditorInput(iClassFile);
                iDocument = this.getDocument((IDocumentProvider)JavaPlugin.getDefault().getClassFileDocumentProvider(), internalClassFileEditorInput);
                if (iDocument.getLength() == 0) {
                    iDocument = new Document(Messages.format(RefactoringMessages.JavaStatusContextViewer_no_source_found0, this.getPackageFragmentRoot(iClassFile).getElementName()));
                }
                this.updateTitle((IAdaptable)iClassFile);
            } else {
                ICompilationUnit iCompilationUnit = javaStatusContext.getCompilationUnit();
                if (iCompilationUnit.isWorkingCopy()) {
                    try {
                        iDocument = this.newJavaDocument(iCompilationUnit.getSource());
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    FileEditorInput fileEditorInput = new FileEditorInput((IFile)iCompilationUnit.getResource());
                    iDocument = this.getDocument(JavaPlugin.getDefault().getCompilationUnitDocumentProvider(), (IEditorInput)fileEditorInput);
                }
                if (iDocument == null) {
                    iDocument = new Document(RefactoringMessages.JavaStatusContextViewer_no_source_available);
                }
                this.updateTitle((IAdaptable)iCompilationUnit);
            }
            this.setInput(iDocument, JavaStatusContextViewer.createRegion(javaStatusContext.getSourceRange()));
        } else if (refactoringStatusContext instanceof JavaStringStatusContext) {
            this.updateTitle(null);
            JavaStringStatusContext javaStringStatusContext = (JavaStringStatusContext)refactoringStatusContext;
            this.setInput(this.newJavaDocument(javaStringStatusContext.getSource()), JavaStatusContextViewer.createRegion(javaStringStatusContext.getSourceRange()));
        }
    }

    private IDocument newJavaDocument(String string) {
        Document document = new Document(string);
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        javaTextTools.setupJavaDocumentPartitioner((IDocument)document);
        return document;
    }

    private static IRegion createRegion(ISourceRange iSourceRange) {
        return new Region(iSourceRange.getOffset(), iSourceRange.getLength());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocument getDocument(IDocumentProvider iDocumentProvider, IEditorInput iEditorInput) {
        if (iEditorInput == null) {
            return null;
        }
        IDocument iDocument = null;
        try {
            try {
                iDocumentProvider.connect((Object)iEditorInput);
                iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iDocumentProvider.disconnect((Object)iEditorInput);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iDocumentProvider.disconnect((Object)iEditorInput);
        return iDocument;
    }
}

