/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;

public abstract class TextInputWizardPage
extends UserInputWizardPage {
    private String fInitialValue;
    private Text fTextField;
    public static final String PAGE_NAME = "TextInputPage";

    public TextInputWizardPage(String string, boolean bl) {
        this(string, bl, "");
    }

    public TextInputWizardPage(String string, boolean bl, String string2) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)string2);
        this.setDescription(string);
        this.fInitialValue = string2;
    }

    protected boolean isInitialInputValid() {
        return false;
    }

    protected boolean isEmptyInputValid() {
        return false;
    }

    protected String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    protected void setText(String string) {
        if (this.fTextField == null) {
            return;
        }
        this.fTextField.setText(string);
    }

    protected Text getTextField() {
        return this.fTextField;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    protected RefactoringStatus validateTextField(String string) {
        return null;
    }

    protected Text createTextInputField(Composite composite) {
        return this.createTextInputField(composite, 2048);
    }

    protected Text createTextInputField(Composite composite, int n) {
        this.fTextField = new Text(composite, n);
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TextInputWizardPage.this.textModified(TextInputWizardPage.this.getText());
            }
        });
        this.fTextField.setText(this.fInitialValue);
        TextFieldNavigationHandler.install(this.fTextField);
        return this.fTextField;
    }

    protected void textModified(String string) {
        if (!this.isEmptyInputValid() && "".equals(string)) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        if (!this.isInitialInputValid() && this.fInitialValue.equals(string)) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        RefactoringStatus refactoringStatus = this.validateTextField(string);
        if (refactoringStatus == null) {
            refactoringStatus = new RefactoringStatus();
        }
        this.setPageComplete(refactoringStatus);
    }

    protected void restoreMessage() {
        this.setMessage(null);
    }

    public void dispose() {
        this.fTextField = null;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.textModified(this.getText());
        }
        super.setVisible(bl);
        if (bl && this.fTextField != null) {
            this.fTextField.setFocus();
        }
    }
}

