/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RenameJavaElementAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public RenameJavaElementAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    public RenameJavaElementAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            if (iStructuredSelection.size() == 1) {
                this.setEnabled(RenameJavaElementAction.canEnable(iStructuredSelection));
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection iStructuredSelection) throws CoreException {
        IJavaElement iJavaElement = RenameJavaElementAction.getJavaElement(iStructuredSelection);
        if (iJavaElement == null) {
            return false;
        }
        return RenameJavaElementAction.isRenameAvailable(iJavaElement);
    }

    private static IJavaElement getJavaElement(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)object;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IJavaElement iJavaElement = RenameJavaElementAction.getJavaElement(iStructuredSelection);
        if (iJavaElement == null) {
            return;
        }
        try {
            this.run(iJavaElement, false);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        block5: {
            if (iTextSelection instanceof JavaTextSelection) {
                try {
                    IJavaElement[] iJavaElementArray = ((JavaTextSelection)iTextSelection).resolveElementAtOffset();
                    if (iJavaElementArray.length == 1) {
                        this.setEnabled(RenameJavaElementAction.isRenameAvailable(iJavaElementArray[0]));
                        break block5;
                    }
                    this.setEnabled(false);
                }
                catch (CoreException coreException) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void run(ITextSelection iTextSelection) {
        RenameLinkedMode renameLinkedMode = RenameLinkedMode.getActiveLinkedMode();
        if (renameLinkedMode != null) {
            if (renameLinkedMode.isCaretInLinkedPosition()) {
                renameLinkedMode.startFullDialog();
                return;
            }
            renameLinkedMode.cancel();
        }
        try {
            IJavaElement iJavaElement = this.getJavaElementFromEditor();
            if (iJavaElement != null && RenameJavaElementAction.isRenameAvailable(iJavaElement)) {
                IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
                this.run(iJavaElement, iPreferenceStore.getBoolean("Refactor.lightweight"));
                return;
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameJavaElementAction_name, (String)RefactoringMessages.RenameJavaElementAction_not_available);
    }

    public boolean canRunInEditor() {
        IJavaElement iJavaElement;
        block6: {
            if (RenameLinkedMode.getActiveLinkedMode() != null) {
                return true;
            }
            iJavaElement = this.getJavaElementFromEditor();
            if (iJavaElement != null) break block6;
            return false;
        }
        try {
            return RenameJavaElementAction.isRenameAvailable(iJavaElement);
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        return false;
    }

    private IJavaElement getJavaElementFromEditor() throws JavaModelException {
        IJavaElement[] iJavaElementArray = SelectionConverter.codeResolve(this.fEditor);
        if (iJavaElementArray == null || iJavaElementArray.length != 1) {
            return null;
        }
        return iJavaElementArray[0];
    }

    private void run(IJavaElement iJavaElement, boolean bl) throws CoreException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), iJavaElement)) {
            return;
        }
        if (ActionUtil.mustDisableJavaModelAction(this.getShell(), iJavaElement)) {
            return;
        }
        if (bl && this.fEditor instanceof CompilationUnitEditor && !(iJavaElement instanceof IPackageFragment)) {
            new RenameLinkedMode(iJavaElement, (CompilationUnitEditor)this.fEditor).start();
        } else {
            RefactoringExecutionStarter.startRenameRefactoring(iJavaElement, this.getShell());
        }
    }

    private static boolean isRenameAvailable(IJavaElement iJavaElement) throws CoreException {
        switch (iJavaElement.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IJavaProject)iJavaElement);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragmentRoot)iJavaElement);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragment)iJavaElement);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)iJavaElement);
            }
            case 7: {
                return false;
            }
            case 9: {
                IMethod iMethod = (IMethod)iJavaElement;
                if (iMethod.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable(iMethod.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable(iMethod);
            }
            case 8: {
                IField iField = (IField)iJavaElement;
                if (Flags.isEnum((int)iField.getFlags())) {
                    return RefactoringAvailabilityTester.isRenameEnumConstAvailable(iField);
                }
                return RefactoringAvailabilityTester.isRenameFieldAvailable(iField);
            }
            case 15: {
                return RefactoringAvailabilityTester.isRenameAvailable((ITypeParameter)iJavaElement);
            }
            case 14: {
                return RefactoringAvailabilityTester.isRenameAvailable((ILocalVariable)iJavaElement);
            }
        }
        return false;
    }
}

