/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;

public class JavaSourcePackageFragmentRootCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private char[] fProposalAutoActivationSet;
    private IJavaModel fRoot = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    private CompletionProposalComparator fComparator;
    private JavaElementLabelProvider fLabelProvider;

    public JavaSourcePackageFragmentRootCompletionProcessor() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = string.toCharArray();
        this.fComparator = new CompletionProposalComparator();
        this.fLabelProvider = new JavaElementLabelProvider(256);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        if (this.fRoot == null) {
            return null;
        }
        String string = iContentAssistSubjectControl.getDocument().get();
        String string2 = string.substring(0, n);
        ICompletionProposal[] iCompletionProposalArray = this.createSourcePackageFragmentRootProposals(string2, string.length());
        Arrays.sort(iCompletionProposalArray, this.fComparator);
        return iCompletionProposalArray;
    }

    private ICompletionProposal[] createSourcePackageFragmentRootProposals(String string, int n) {
        ArrayList<JavaCompletionProposal> arrayList = new ArrayList<JavaCompletionProposal>();
        try {
            IJavaProject[] iJavaProjectArray = this.fRoot.getJavaProjects();
            int n2 = 0;
            while (n2 < iJavaProjectArray.length) {
                IJavaProject iJavaProject = iJavaProjectArray[n2];
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                int n3 = 0;
                while (n3 < iPackageFragmentRootArray.length) {
                    IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n3];
                    if (iPackageFragmentRoot.exists() && iPackageFragmentRoot.getKind() == 1) {
                        String string2 = iPackageFragmentRoot.getPath().toString();
                        if (string2.length() > 1) {
                            string2 = string2.substring(1);
                        }
                        if (string2.startsWith(string)) {
                            Image image = this.fLabelProvider.getImage(iPackageFragmentRoot);
                            JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string2, 0, n, image, string2, 0);
                            arrayList.add(javaCompletionProposal);
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        return null;
    }
}

