/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;

class PackageFragmentSelection
extends StringButtonStatusDialogField
implements SourceChangeListener {
    private final SourceFirstPackageSelectionDialogField fDialogField;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private IDialogFieldListener fUpdateListener;

    public PackageFragmentSelection(SourceFirstPackageSelectionDialogField sourceFirstPackageSelectionDialogField, String string, String string2, String string3, IStringButtonAdapter iStringButtonAdapter) {
        super(iStringButtonAdapter);
        this.fDialogField = sourceFirstPackageSelectionDialogField;
        this.setLabelText(string);
        this.setButtonLabel(string2);
        this.setStatusWidthHint(string3);
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
    }

    public void setUpdateListener(IDialogFieldListener iDialogFieldListener) {
        this.fUpdateListener = iDialogFieldListener;
    }

    public Control[] doFillIntoGrid(Composite composite, int n, int n2) {
        Control[] controlArray = super.doFillIntoGrid(composite, n);
        Text text = this.getTextControl(null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PackageFragmentSelection.this.updateListener();
            }
        });
        LayoutUtil.setWidthHint((Control)text, n2);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fCurrPackageCompletionProcessor);
        TextFieldNavigationHandler.install(text);
        return controlArray;
    }

    public void setPackageFragment(IPackageFragment iPackageFragment) {
        if (iPackageFragment != null) {
            this.setText(iPackageFragment.getElementName());
        }
        this.updateListener();
    }

    private void updateListener() {
        if (this.fUpdateListener != null) {
            this.fUpdateListener.dialogFieldChanged(this);
        }
    }

    public IPackageFragment getPackageFragment() {
        return this.calculateFragment(this.fDialogField.getSelectedFragmentRoot());
    }

    private IPackageFragment calculateFragment(IPackageFragmentRoot iPackageFragmentRoot) {
        if (iPackageFragmentRoot == null) {
            return null;
        }
        return iPackageFragmentRoot.getPackageFragment(this.getText());
    }

    public void sourceRootChanged(IPackageFragmentRoot iPackageFragmentRoot) {
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(iPackageFragmentRoot);
        this.setPackageFragment(this.calculateFragment(iPackageFragmentRoot));
    }
}

