/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ReorgCopyAction
extends SelectionDispatchAction {
    public ReorgCopyAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ReorgMessages.ReorgCopyAction_3);
        this.setDescription(ReorgMessages.ReorgCopyAction_4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.copy_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        block7: {
            if (!iStructuredSelection.isEmpty()) {
                if (ReorgUtils.containsOnlyProjects(iStructuredSelection.toList())) {
                    this.setEnabled(this.createWorkbenchAction(iStructuredSelection).isEnabled());
                    return;
                }
                try {
                    List list = iStructuredSelection.toList();
                    IResource[] iResourceArray = ReorgUtils.getResources(list);
                    IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(list);
                    if (list.size() != iResourceArray.length + iJavaElementArray.length) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(RefactoringAvailabilityTester.isCopyAvailable(iResourceArray, iJavaElementArray));
                }
                catch (JavaModelException javaModelException) {
                    if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                        JavaPlugin.log(javaModelException);
                    }
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private CopyProjectAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        CopyProjectAction copyProjectAction = new CopyProjectAction(this.getShell());
        copyProjectAction.selectionChanged(iStructuredSelection);
        return copyProjectAction;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (ReorgUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.createWorkbenchAction(iStructuredSelection).run();
            return;
        }
        try {
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ReorgUtils.getResources(list);
            IJavaElement[] iJavaElementArray = ReorgUtils.getJavaElements(list);
            if (RefactoringAvailabilityTester.isCopyAvailable(iResourceArray, iJavaElementArray)) {
                RefactoringExecutionStarter.startCopyRefactoring(iResourceArray, iJavaElementArray, this.getShell());
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

