/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

class ImportFilter
extends JavaMatchFilter {
    ImportFilter() {
    }

    public boolean filters(JavaElementMatch javaElementMatch) {
        return javaElementMatch.getElement() instanceof IImportDeclaration;
    }

    public String getName() {
        return SearchMessages.MatchFilter_ImportFilter_name;
    }

    public String getActionLabel() {
        return SearchMessages.MatchFilter_ImportFilter_actionLabel;
    }

    public String getDescription() {
        return SearchMessages.MatchFilter_ImportFilter_description;
    }

    public boolean isApplicable(JavaSearchQuery javaSearchQuery) {
        QuerySpecification querySpecification = javaSearchQuery.getSpecification();
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuerySpecification = (ElementQuerySpecification)querySpecification;
            IJavaElement iJavaElement = elementQuerySpecification.getElement();
            return iJavaElement instanceof IType || iJavaElement instanceof IPackageFragment;
        }
        if (querySpecification instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuerySpecification = (PatternQuerySpecification)querySpecification;
            int n = patternQuerySpecification.getSearchFor();
            return n == 0 || n == 2;
        }
        return false;
    }

    public String getID() {
        return "filter_imports";
    }
}

