/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesGroupKey;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private CompilationUnit fRoot;
    private Name fSelectedNode;
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();
    private boolean fTargetIsStaticMethodImport;

    public OccurrencesFinder(IBinding iBinding) {
        super(true);
        this.fTarget = iBinding;
    }

    public OccurrencesFinder() {
        super(true);
    }

    public String initialize(CompilationUnit compilationUnit, int n, int n2) {
        return this.initialize(compilationUnit, NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    public String initialize(CompilationUnit compilationUnit, ASTNode aSTNode) {
        if (!(aSTNode instanceof Name)) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = compilationUnit;
        this.fSelectedNode = (Name)aSTNode;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return SearchMessages.OccurrencesFinder_no_binding;
        }
        this.fTarget = this.getBindingDeclaration(this.fTarget);
        this.fTargetIsStaticMethodImport = OccurrencesFinder.isStaticImport(this.fSelectedNode.getParent());
        return null;
    }

    public List perform() {
        this.fRoot.accept((ASTVisitor)this);
        return this.fUsages;
    }

    public void collectOccurrenceMatches(IJavaElement iJavaElement, IDocument iDocument, Collection collection) {
        boolean bl = this.fTarget instanceof IVariableBinding;
        HashMap<Integer, OccurrencesGroupKey> hashMap = new HashMap<Integer, OccurrencesGroupKey>();
        Iterator iterator = this.fUsages.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            int n = aSTNode.getStartPosition();
            int n2 = aSTNode.getLength();
            try {
                IRegion iRegion;
                boolean bl2 = this.fWriteUsages.contains(aSTNode);
                int n3 = iDocument.getLineOfOffset(n);
                Integer n4 = new Integer(n3);
                OccurrencesGroupKey occurrencesGroupKey = (OccurrencesGroupKey)hashMap.get(n4);
                if (occurrencesGroupKey == null) {
                    iRegion = iDocument.getLineInformation(n3);
                    String string = iDocument.get(iRegion.getOffset(), iRegion.getLength()).trim();
                    occurrencesGroupKey = new OccurrencesGroupKey(iJavaElement, n3, string, bl2, bl);
                    hashMap.put(n4, occurrencesGroupKey);
                } else if (bl2) {
                    occurrencesGroupKey.setWriteAccess(true);
                }
                iRegion = new Match((Object)occurrencesGroupKey, n, n2);
                collection.add(iRegion);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedNode);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    public boolean visit(QualifiedName qualifiedName) {
        IBinding iBinding = qualifiedName.resolveBinding();
        if (iBinding instanceof IVariableBinding && ((IVariableBinding)iBinding).isField()) {
            SimpleName simpleName = qualifiedName.getName();
            return !this.match((Name)simpleName, this.fUsages, simpleName.resolveBinding());
        }
        if (iBinding instanceof IMethodBinding && OccurrencesFinder.isStaticImport((ASTNode)qualifiedName)) {
            SimpleName simpleName = qualifiedName.getName();
            return !this.matchStaticImport((Name)simpleName, this.fUsages, (IMethodBinding)iBinding);
        }
        return !this.match((Name)qualifiedName, this.fUsages, iBinding);
    }

    private static boolean isStaticImport(ASTNode aSTNode) {
        if (!(aSTNode instanceof QualifiedName)) {
            return false;
        }
        ASTNode aSTNode2 = ((QualifiedName)aSTNode).getParent();
        return aSTNode2 instanceof ImportDeclaration && ((ImportDeclaration)aSTNode2).isStatic();
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (this.fTargetIsStaticMethodImport) {
            return !this.matchStaticImport((Name)methodInvocation.getName(), this.fUsages, methodInvocation.resolveMethodBinding());
        }
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        return !this.match((Name)simpleName, this.fUsages, simpleName.resolveBinding());
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        Type type = classInstanceCreation.getType();
        if (type != null) {
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getType();
            }
            if (type instanceof SimpleType) {
                Name name = ((SimpleType)type).getName();
                if (name instanceof QualifiedName) {
                    name = ((QualifiedName)name).getName();
                }
                this.match(name, this.fUsages, (IBinding)classInstanceCreation.resolveConstructorBinding());
            }
        } else {
            Expression expression = classInstanceCreation.getMember();
            if (expression instanceof SimpleName) {
                SimpleName simpleName = (SimpleName)expression;
                this.match((Name)simpleName, this.fUsages, (IBinding)classInstanceCreation.resolveConstructorBinding());
            }
        }
        return super.visit(classInstanceCreation);
    }

    public boolean visit(Assignment assignment) {
        Expression expression = assignment.getLeftHandSide();
        SimpleName simpleName = this.getSimpleName(expression);
        if (simpleName != null) {
            this.match((Name)simpleName, this.fWriteUsages, simpleName.resolveBinding());
        }
        expression.accept((ASTVisitor)this);
        assignment.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.match((Name)singleVariableDeclaration.getName(), this.fWriteUsages, (IBinding)singleVariableDeclaration.resolveBinding());
        return super.visit(singleVariableDeclaration);
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        if (variableDeclarationFragment.getParent().getNodeType() == 23 || variableDeclarationFragment.getInitializer() != null) {
            this.match((Name)variableDeclarationFragment.getName(), this.fWriteUsages, (IBinding)variableDeclarationFragment.resolveBinding());
        }
        return super.visit(variableDeclarationFragment);
    }

    public boolean visit(PrefixExpression prefixExpression) {
        Expression expression;
        SimpleName simpleName;
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (simpleName = this.getSimpleName(expression = prefixExpression.getOperand())) != null) {
            this.match((Name)simpleName, this.fWriteUsages, simpleName.resolveBinding());
        }
        return super.visit(prefixExpression);
    }

    public boolean visit(PostfixExpression postfixExpression) {
        Expression expression = postfixExpression.getOperand();
        SimpleName simpleName = this.getSimpleName(expression);
        if (simpleName != null) {
            this.match((Name)simpleName, this.fWriteUsages, simpleName.resolveBinding());
        }
        return super.visit(postfixExpression);
    }

    private boolean match(Name name, List list, IBinding iBinding) {
        if (iBinding != null && Bindings.equals(this.getBindingDeclaration(iBinding), this.fTarget)) {
            list.add(name);
            return true;
        }
        return false;
    }

    private boolean matchStaticImport(Name name, List list, IMethodBinding iMethodBinding) {
        if (iMethodBinding == null || name == null || !(this.fTarget instanceof IMethodBinding) || !Modifier.isStatic((int)iMethodBinding.getModifiers())) {
            return false;
        }
        IMethodBinding iMethodBinding2 = (IMethodBinding)this.fTarget;
        if ((this.fTargetIsStaticMethodImport || Modifier.isStatic((int)iMethodBinding2.getModifiers())) && iMethodBinding2.getDeclaringClass().getTypeDeclaration() == iMethodBinding.getDeclaringClass().getTypeDeclaration() && name.getFullyQualifiedName().equals(iMethodBinding2.getName())) {
            list.add(name);
            return true;
        }
        return false;
    }

    private SimpleName getSimpleName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }

    private IBinding getBindingDeclaration(IBinding iBinding) {
        switch (iBinding.getKind()) {
            case 2: {
                return ((ITypeBinding)iBinding).getTypeDeclaration();
            }
            case 4: {
                return ((IMethodBinding)iBinding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)iBinding).getVariableDeclaration();
            }
        }
        return iBinding;
    }
}

