/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class PatternStrings {
    public static String getSignature(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 9: {
                return PatternStrings.getMethodSignature((IMethod)iJavaElement);
            }
            case 7: {
                return PatternStrings.getTypeSignature((IType)iJavaElement);
            }
            case 8: {
                return PatternStrings.getFieldSignature((IField)iJavaElement);
            }
        }
        return iJavaElement.getElementName();
    }

    public static String getMethodSignature(IMethod iMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iMethod.getDeclaringType() != null) {
            stringBuffer.append(JavaElementLabels.getElementLabel((IJavaElement)iMethod.getDeclaringType(), 0x1000000040000L));
            boolean bl = iMethod.getElementName().equals(iMethod.getDeclaringType().getElementName());
            if (!bl) {
                stringBuffer.append('.');
            }
            stringBuffer.append(PatternStrings.getUnqualifiedMethodSignature(iMethod, !bl));
        }
        return stringBuffer.toString();
    }

    private static String getUnqualifiedMethodSignature(IMethod iMethod, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(iMethod.getElementName());
        }
        stringBuffer.append('(');
        String[] stringArray = iMethod.getParameterTypes();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            String string = Signature.toString((String)stringArray[n]);
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getUnqualifiedMethodSignature(IMethod iMethod) {
        return PatternStrings.getUnqualifiedMethodSignature(iMethod, true);
    }

    public static String getTypeSignature(IType iType) {
        return JavaElementLabels.getElementLabel((IJavaElement)iType, 281474979069952L);
    }

    public static String getFieldSignature(IField iField) {
        return JavaElementLabels.getElementLabel((IJavaElement)iField, 65536L);
    }
}

