/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocCompletionProcessor;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String AUTOACTIVATION_TRIGGERS_JAVA = "content_assist_autoactivation_triggers_java";
    private static final String AUTOACTIVATION_TRIGGERS_JAVADOC = "content_assist_autoactivation_triggers_javadoc";
    private static final String SHOW_VISIBLE_PROPOSALS = "content_assist_show_visible_proposals";
    private static final String CASE_SENSITIVITY = "content_assist_case_sensitivity";
    private static final String FILL_METHOD_ARGUMENTS = "content_assist_fill_method_arguments";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";

    private static Color getColor(IPreferenceStore iPreferenceStore, String string, IColorManager iColorManager) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return iColorManager.getColor(rGB);
    }

    private static Color getColor(IPreferenceStore iPreferenceStore, String string) {
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        return ContentAssistPreference.getColor(iPreferenceStore, string, javaTextTools.getColorManager());
    }

    private static JavaCompletionProcessor getJavaProcessor(ContentAssistant contentAssistant) {
        IContentAssistProcessor iContentAssistProcessor = contentAssistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (iContentAssistProcessor instanceof JavaCompletionProcessor) {
            return (JavaCompletionProcessor)iContentAssistProcessor;
        }
        return null;
    }

    private static JavadocCompletionProcessor getJavaDocProcessor(ContentAssistant contentAssistant) {
        IContentAssistProcessor iContentAssistProcessor = contentAssistant.getContentAssistProcessor("__java_javadoc");
        if (iContentAssistProcessor instanceof JavadocCompletionProcessor) {
            return (JavadocCompletionProcessor)iContentAssistProcessor;
        }
        return null;
    }

    private static void configureJavaProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        JavaCompletionProcessor javaCompletionProcessor = ContentAssistPreference.getJavaProcessor(contentAssistant);
        if (javaCompletionProcessor == null) {
            return;
        }
        String string = iPreferenceStore.getString(AUTOACTIVATION_TRIGGERS_JAVA);
        if (string != null) {
            javaCompletionProcessor.setCompletionProposalAutoActivationCharacters(string.toCharArray());
        }
        boolean bl = iPreferenceStore.getBoolean(SHOW_VISIBLE_PROPOSALS);
        javaCompletionProcessor.restrictProposalsToVisibility(bl);
        bl = iPreferenceStore.getBoolean(CASE_SENSITIVITY);
        javaCompletionProcessor.restrictProposalsToMatchingCases(bl);
    }

    private static void configureJavaDocProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        JavadocCompletionProcessor javadocCompletionProcessor = ContentAssistPreference.getJavaDocProcessor(contentAssistant);
        if (javadocCompletionProcessor == null) {
            return;
        }
        String string = iPreferenceStore.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
        if (string != null) {
            javadocCompletionProcessor.setCompletionProposalAutoActivationCharacters(string.toCharArray());
        }
        boolean bl = iPreferenceStore.getBoolean(CASE_SENSITIVITY);
        javadocCompletionProcessor.restrictProposalsToMatchingCases(bl);
    }

    public static void configure(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore) {
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager iColorManager = javaTextTools.getColorManager();
        boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION);
        contentAssistant.enableAutoActivation(bl);
        int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
        contentAssistant.setAutoActivationDelay(n);
        Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND, iColorManager);
        contentAssistant.setProposalSelectorForeground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND, iColorManager);
        contentAssistant.setProposalSelectorBackground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND, iColorManager);
        contentAssistant.setContextInformationPopupForeground(color);
        contentAssistant.setContextSelectorForeground(color);
        color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND, iColorManager);
        contentAssistant.setContextInformationPopupBackground(color);
        contentAssistant.setContextSelectorBackground(color);
        bl = iPreferenceStore.getBoolean(AUTOINSERT);
        contentAssistant.enableAutoInsert(bl);
        bl = iPreferenceStore.getBoolean(PREFIX_COMPLETION);
        contentAssistant.enablePrefixCompletion(bl);
        ContentAssistPreference.configureJavaProcessor(contentAssistant, iPreferenceStore);
        ContentAssistPreference.configureJavaDocProcessor(contentAssistant, iPreferenceStore);
    }

    private static void changeJavaProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, String string) {
        JavaCompletionProcessor javaCompletionProcessor = ContentAssistPreference.getJavaProcessor(contentAssistant);
        if (javaCompletionProcessor == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVA.equals(string)) {
            String string2 = iPreferenceStore.getString(AUTOACTIVATION_TRIGGERS_JAVA);
            if (string2 != null) {
                javaCompletionProcessor.setCompletionProposalAutoActivationCharacters(string2.toCharArray());
            }
        } else if (SHOW_VISIBLE_PROPOSALS.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(SHOW_VISIBLE_PROPOSALS);
            javaCompletionProcessor.restrictProposalsToVisibility(bl);
        } else if (CASE_SENSITIVITY.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(CASE_SENSITIVITY);
            javaCompletionProcessor.restrictProposalsToMatchingCases(bl);
        }
    }

    private static void changeJavaDocProcessor(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, String string) {
        JavadocCompletionProcessor javadocCompletionProcessor = ContentAssistPreference.getJavaDocProcessor(contentAssistant);
        if (javadocCompletionProcessor == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVADOC.equals(string)) {
            String string2 = iPreferenceStore.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
            if (string2 != null) {
                javadocCompletionProcessor.setCompletionProposalAutoActivationCharacters(string2.toCharArray());
            }
        } else if (CASE_SENSITIVITY.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(CASE_SENSITIVITY);
            javadocCompletionProcessor.restrictProposalsToMatchingCases(bl);
        }
    }

    public static void changeConfiguration(ContentAssistant contentAssistant, IPreferenceStore iPreferenceStore, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (AUTOACTIVATION.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOACTIVATION);
            contentAssistant.enableAutoActivation(bl);
        } else if (AUTOACTIVATION_DELAY.equals(string)) {
            int n = iPreferenceStore.getInt(AUTOACTIVATION_DELAY);
            contentAssistant.setAutoActivationDelay(n);
        } else if (PROPOSALS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_FOREGROUND);
            contentAssistant.setProposalSelectorForeground(color);
        } else if (PROPOSALS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PROPOSALS_BACKGROUND);
            contentAssistant.setProposalSelectorBackground(color);
        } else if (PARAMETERS_FOREGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_FOREGROUND);
            contentAssistant.setContextInformationPopupForeground(color);
            contentAssistant.setContextSelectorForeground(color);
        } else if (PARAMETERS_BACKGROUND.equals(string)) {
            Color color = ContentAssistPreference.getColor(iPreferenceStore, PARAMETERS_BACKGROUND);
            contentAssistant.setContextInformationPopupBackground(color);
            contentAssistant.setContextSelectorBackground(color);
        } else if (AUTOINSERT.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(AUTOINSERT);
            contentAssistant.enableAutoInsert(bl);
        } else if (PREFIX_COMPLETION.equals(string)) {
            boolean bl = iPreferenceStore.getBoolean(PREFIX_COMPLETION);
            contentAssistant.enablePrefixCompletion(bl);
        }
        ContentAssistPreference.changeJavaProcessor(contentAssistant, iPreferenceStore, string);
        ContentAssistPreference.changeJavaDocProcessor(contentAssistant, iPreferenceStore, string);
    }

    public static boolean fillArgumentsOnMethodCompletion(IPreferenceStore iPreferenceStore) {
        return iPreferenceStore.getBoolean(FILL_METHOD_ARGUMENTS);
    }
}

