/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.io.IOException;
import org.eclipse.jface.internal.text.html.SingleCharReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class JavaCodeReader
extends SingleCharReader {
    public static final int EOF = -1;
    private boolean fSkipComments = false;
    private boolean fSkipStrings = false;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private int fCachedLineNumber = -1;
    private int fCachedLineOffset = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument iDocument, int n, int n2, boolean bl, boolean bl2) throws IOException {
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fSkipComments = bl;
        this.fSkipStrings = bl2;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + n2);
    }

    public void configureBackwardReader(IDocument iDocument, int n, boolean bl, boolean bl2) throws IOException {
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fSkipComments = bl;
        this.fSkipStrings = bl2;
        this.fForward = false;
        try {
            this.fCachedLineNumber = this.fDocument.getLineOfOffset(this.fOffset);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    private void gotoCommentEnd() throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char c;
            if ((c = this.fDocument.getChar(this.fOffset++)) != '*' || this.fOffset >= this.fEnd || this.fDocument.getChar(this.fOffset) != '/') continue;
            ++this.fOffset;
            return;
        }
    }

    private void gotoStringEnd(char c) throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char c2;
            if ((c2 = this.fDocument.getChar(this.fOffset++)) == '\\') {
                ++this.fOffset;
                continue;
            }
            if (c2 != c) continue;
            return;
        }
    }

    private void gotoLineEnd() throws BadLocationException {
        int n = this.fDocument.getLineOfOffset(this.fOffset);
        this.fOffset = this.fDocument.getLineOffset(n + 1);
    }

    private int readForwards() throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char c = this.fDocument.getChar(this.fOffset++);
            switch (c) {
                case '/': {
                    if (this.fSkipComments && this.fOffset < this.fEnd) {
                        char c2 = this.fDocument.getChar(this.fOffset);
                        if (c2 == '*') {
                            ++this.fOffset;
                            this.gotoCommentEnd();
                            break;
                        }
                        if (c2 == '/') {
                            this.gotoLineEnd();
                            break;
                        }
                    }
                    return c;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        this.gotoStringEnd(c);
                        break;
                    }
                    return c;
                }
                default: {
                    return c;
                }
            }
        }
        return -1;
    }

    private void handleSingleLineComment() throws BadLocationException {
        int n = this.fDocument.getLineOfOffset(this.fOffset);
        if (n < this.fCachedLineNumber) {
            this.fCachedLineNumber = n;
            this.fCachedLineOffset = this.fDocument.getLineOffset(n);
            int n2 = this.fOffset;
            while (this.fCachedLineOffset < n2) {
                char c;
                if ((c = this.fDocument.getChar(n2--)) != '/' || this.fCachedLineOffset > n2 || this.fDocument.getChar(n2) != '/') continue;
                this.fOffset = n2;
                return;
            }
        }
    }

    private void gotoCommentStart() throws BadLocationException {
        while (this.fOffset > 0) {
            char c;
            if ((c = this.fDocument.getChar(this.fOffset--)) != '*' || this.fOffset < 0 || this.fDocument.getChar(this.fOffset) != '/') continue;
            return;
        }
    }

    private void gotoStringStart(char c) throws BadLocationException {
        while (this.fOffset > 0) {
            char c2 = this.fDocument.getChar(this.fOffset);
            if (c2 == c && (this.fOffset < 0 || this.fDocument.getChar(this.fOffset - 1) != '\\')) {
                return;
            }
            --this.fOffset;
        }
    }

    private int readBackwards() throws BadLocationException {
        while (this.fOffset > 0) {
            --this.fOffset;
            this.handleSingleLineComment();
            char c = this.fDocument.getChar(this.fOffset);
            switch (c) {
                case '/': {
                    char c2;
                    if (this.fSkipComments && this.fOffset > 1 && (c2 = this.fDocument.getChar(this.fOffset - 1)) == '*') {
                        this.fOffset -= 2;
                        this.gotoCommentStart();
                        break;
                    }
                    return c;
                }
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        --this.fOffset;
                        this.gotoStringStart(c);
                        break;
                    }
                    return c;
                }
                default: {
                    return c;
                }
            }
        }
        return -1;
    }
}

