/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public abstract class AbstractMethodCompletionProposal
extends LinkedCorrectionProposal {
    private ASTNode fNode;
    private ITypeBinding fSenderBinding;

    public AbstractMethodCompletionProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, ITypeBinding iTypeBinding, int n, Image image) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, image);
        Assert.isTrue((iTypeBinding != null && Bindings.isDeclarationBinding((IBinding)iTypeBinding) ? 1 : 0) != 0);
        this.fNode = aSTNode;
        this.fSenderBinding = iTypeBinding;
    }

    protected ASTNode getInvocationNode() {
        return this.fNode;
    }

    protected ITypeBinding getSenderBinding() {
        return this.fSenderBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean bl;
        CompilationUnit compilationUnit = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode aSTNode2 = null;
        if (aSTNode != null) {
            bl = false;
            aSTNode2 = aSTNode;
        } else {
            bl = true;
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode2 = compilationUnit.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(compilationUnit);
        if (aSTNode2 != null) {
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            MethodDeclaration methodDeclaration = this.getStub(aSTRewrite, aSTNode2);
            ChildListPropertyDescriptor childListPropertyDescriptor = ASTNodes.getBodyDeclarationsProperty(aSTNode2);
            List list = (List)aSTNode2.getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor);
            int n = this.isConstructor() ? this.findConstructorInsertIndex(list) : (!bl ? this.findMethodInsertIndex(list, this.fNode.getStartPosition()) : list.size());
            ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode2, childListPropertyDescriptor);
            listRewrite.insertAt((ASTNode)methodDeclaration, n, null);
            return aSTRewrite;
        }
        return null;
    }

    private MethodDeclaration getStub(ASTRewrite aSTRewrite, ASTNode aSTNode) throws CoreException {
        Object object;
        Object object2;
        Type type;
        AST aST = aSTNode.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        SimpleName simpleName = this.getNewName(aSTRewrite);
        methodDeclaration.setConstructor(this.isConstructor());
        this.addNewModifiers(aSTRewrite, aSTNode, methodDeclaration.modifiers());
        ArrayList<String> arrayList = new ArrayList<String>();
        this.addNewTypeParameters(aSTRewrite, arrayList, methodDeclaration.typeParameters());
        methodDeclaration.setName(simpleName);
        IVariableBinding[] iVariableBindingArray = this.fSenderBinding.getDeclaredFields();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            arrayList.add(iVariableBindingArray[n].getName());
            ++n;
        }
        String string = "";
        if (!this.isConstructor()) {
            type = this.getNewMethodType(aSTRewrite);
            if (type == null) {
                methodDeclaration.setReturnType2((Type)aST.newPrimitiveType(PrimitiveType.VOID));
            } else {
                methodDeclaration.setReturnType2(type);
            }
            if (!this.fSenderBinding.isInterface() && type != null) {
                object2 = aST.newReturnStatement();
                object2.setExpression(ASTNodeFactory.newDefaultExpression(aST, type, 0));
                string = ASTNodes.asFormattedString((ASTNode)object2, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaProject().getOptions(true));
            }
        }
        this.addNewParameters(aSTRewrite, arrayList, methodDeclaration.parameters());
        this.addNewExceptions(aSTRewrite, methodDeclaration.thrownExceptions());
        type = null;
        if (!this.fSenderBinding.isInterface()) {
            type = aST.newBlock();
            object2 = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), this.fSenderBinding.getName(), simpleName.getIdentifier(), this.isConstructor(), string, String.valueOf('\n'));
            if (object2 != null) {
                object = aSTRewrite.createStringPlaceholder((String)object2, 41);
                type.statements().add(object);
            }
        }
        methodDeclaration.setBody((Block)type);
        object2 = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (object2.createComments && !this.fSenderBinding.isAnonymous() && (object = CodeGeneration.getMethodComment(this.getCompilationUnit(), this.fSenderBinding.getName(), methodDeclaration, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        return methodDeclaration;
    }

    private int findMethodInsertIndex(List list, int n) {
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            ASTNode aSTNode = (ASTNode)list.get(n3);
            if (aSTNode instanceof MethodDeclaration && n < aSTNode.getStartPosition() + aSTNode.getLength()) {
                return n3 + 1;
            }
            ++n3;
        }
        return n2;
    }

    private int findConstructorInsertIndex(List list) {
        int n = list.size();
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            ASTNode aSTNode = (ASTNode)list.get(n3);
            if (aSTNode instanceof MethodDeclaration) {
                if (((MethodDeclaration)aSTNode).isConstructor()) {
                    return n3 + 1;
                }
                n2 = n3;
            }
            --n3;
        }
        return n2;
    }

    protected abstract boolean isConstructor();

    protected abstract void addNewModifiers(ASTRewrite var1, ASTNode var2, List var3);

    protected abstract void addNewTypeParameters(ASTRewrite var1, List var2, List var3) throws CoreException;

    protected abstract void addNewParameters(ASTRewrite var1, List var2, List var3) throws CoreException;

    protected abstract void addNewExceptions(ASTRewrite var1, List var2) throws CoreException;

    protected abstract SimpleName getNewName(ASTRewrite var1);

    protected abstract Type getNewMethodType(ASTRewrite var1) throws CoreException;
}

