/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class ChangeMethodSignatureProposal
extends LinkedCorrectionProposal {
    private ASTNode fInvocationNode;
    private IMethodBinding fSenderBinding;
    private ChangeDescription[] fParameterChanges;
    private ChangeDescription[] fExceptionChanges;

    public ChangeMethodSignatureProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, IMethodBinding iMethodBinding, ChangeDescription[] changeDescriptionArray, ChangeDescription[] changeDescriptionArray2, int n, Image image) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, image);
        Assert.isTrue((iMethodBinding != null && Bindings.isDeclarationBinding((IBinding)iMethodBinding) ? 1 : 0) != 0);
        this.fInvocationNode = aSTNode;
        this.fSenderBinding = iMethodBinding;
        this.fParameterChanges = changeDescriptionArray;
        this.fExceptionChanges = changeDescriptionArray2;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean bl;
        CompilationUnit compilationUnit = (CompilationUnit)this.fInvocationNode.getRoot();
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode aSTNode2 = null;
        if (aSTNode != null) {
            bl = false;
            aSTNode2 = aSTNode;
        } else {
            bl = true;
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode2 = compilationUnit.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(compilationUnit);
        if (aSTNode2 instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode2;
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            if (this.fParameterChanges != null) {
                this.modifyParameters(aSTRewrite, methodDeclaration, bl);
            }
            if (this.fExceptionChanges != null) {
                this.modifyExceptions(aSTRewrite, methodDeclaration);
            }
            return aSTRewrite;
        }
        return null;
    }

    private void modifyParameters(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration, boolean bl) throws CoreException {
        IBinding[] iBindingArray;
        AST aST = methodDeclaration.getAST();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        IVariableBinding[] iVariableBindingArray = this.fSenderBinding.getDeclaringClass().getDeclaredFields();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            arrayList.add(iVariableBindingArray[n].getName());
            ++n;
        }
        ImportRewrite importRewrite = this.getImportRewrite();
        ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY);
        List list = methodDeclaration.parameters();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fParameterChanges.length) {
            SimpleName simpleName;
            Type type;
            SingleVariableDeclaration singleVariableDeclaration;
            SingleVariableDeclaration singleVariableDeclaration2;
            Object object;
            iBindingArray = this.fParameterChanges[n3];
            if (iBindingArray == null) {
                object = (SingleVariableDeclaration)list.get(n2);
                arrayList.add(object.getName().getIdentifier());
                ++n2;
            } else if (iBindingArray instanceof InsertDescription) {
                object = (InsertDescription)iBindingArray;
                singleVariableDeclaration2 = aST.newSingleVariableDeclaration();
                singleVariableDeclaration2.setType(importRewrite.addImport(object.type, aST));
                singleVariableDeclaration2.setName(aST.newSimpleName("x"));
                object.resultingParamName = new SimpleName[]{singleVariableDeclaration2.getName()};
                object.resultingParamType = singleVariableDeclaration2.getType();
                bl2 = true;
                listRewrite.insertAt((ASTNode)singleVariableDeclaration2, n3, null);
                singleVariableDeclaration = methodDeclaration.getJavadoc();
                if (singleVariableDeclaration != null) {
                    type = aST.newTagElement();
                    type.setTagName("@param");
                    simpleName = aST.newSimpleName("x");
                    type.fragments().add(simpleName);
                    this.insertTabStop(aSTRewrite, type.fragments(), "param_tagcomment" + n3);
                    this.insertParamTag(aSTRewrite.getListRewrite((ASTNode)singleVariableDeclaration, Javadoc.TAGS_PROPERTY), list, n2, (TagElement)type);
                    object.resultingTagArg = simpleName;
                } else {
                    object.resultingTagArg = null;
                }
            } else if (iBindingArray instanceof RemoveDescription) {
                object = (SingleVariableDeclaration)list.get(n2);
                listRewrite.remove((ASTNode)object, null);
                ++n2;
                singleVariableDeclaration2 = this.findParamTag(methodDeclaration, (SingleVariableDeclaration)object);
                if (singleVariableDeclaration2 != null) {
                    aSTRewrite.remove((ASTNode)singleVariableDeclaration2, null);
                }
            } else if (iBindingArray instanceof EditDescription) {
                Object object2;
                TagElement tagElement;
                object = (EditDescription)iBindingArray;
                singleVariableDeclaration2 = object.type;
                singleVariableDeclaration = (SingleVariableDeclaration)list.get(n2);
                if (n2 == list.size() - 1 && n3 == this.fParameterChanges.length - 1 && singleVariableDeclaration.isVarargs() && singleVariableDeclaration2.isArray()) {
                    singleVariableDeclaration2 = singleVariableDeclaration2.getElementType();
                } else {
                    aSTRewrite.set((ASTNode)singleVariableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)Boolean.FALSE, null);
                }
                type = importRewrite.addImport((ITypeBinding)singleVariableDeclaration2, aST);
                aSTRewrite.replace((ASTNode)singleVariableDeclaration.getType(), (ASTNode)type, null);
                aSTRewrite.set((ASTNode)singleVariableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
                simpleName = singleVariableDeclaration.getName().resolveBinding();
                if (simpleName != null) {
                    tagElement = LinkedNodeFinder.findByBinding(singleVariableDeclaration.getRoot(), (IBinding)simpleName);
                    object2 = new SimpleName[((SimpleName[])tagElement).length];
                    int n4 = 0;
                    while (n4 < ((SimpleName[])tagElement).length) {
                        SimpleName simpleName2;
                        object2[n4] = simpleName2 = aST.newSimpleName("x");
                        aSTRewrite.replace((ASTNode)tagElement[n4], (ASTNode)simpleName2, null);
                        ++n4;
                    }
                    object.resultingParamName = object2;
                } else {
                    tagElement = aST.newSimpleName("x");
                    aSTRewrite.replace((ASTNode)singleVariableDeclaration.getName(), (ASTNode)tagElement, null);
                    object.resultingParamName = new SimpleName[]{tagElement};
                }
                object.resultingParamType = type;
                object.orginalName = singleVariableDeclaration.getName().getIdentifier();
                bl2 = true;
                ++n2;
                tagElement = this.findParamTag(methodDeclaration, singleVariableDeclaration);
                if (tagElement != null && !(object2 = tagElement.fragments()).isEmpty()) {
                    SimpleName simpleName3 = aST.newSimpleName("x");
                    aSTRewrite.replace((ASTNode)object2.get(0), (ASTNode)simpleName3, null);
                    object.resultingTagArg = simpleName3;
                }
            } else if (iBindingArray instanceof SwapDescription) {
                object = (SingleVariableDeclaration)list.get(n2);
                singleVariableDeclaration2 = (SingleVariableDeclaration)list.get(((SwapDescription)iBindingArray).index);
                aSTRewrite.replace((ASTNode)object, aSTRewrite.createCopyTarget((ASTNode)singleVariableDeclaration2), null);
                aSTRewrite.replace((ASTNode)singleVariableDeclaration2, aSTRewrite.createCopyTarget((ASTNode)object), null);
                arrayList.add(object.getName().getIdentifier());
                ++n2;
                singleVariableDeclaration = this.findParamTag(methodDeclaration, (SingleVariableDeclaration)object);
                type = this.findParamTag(methodDeclaration, singleVariableDeclaration2);
                if (singleVariableDeclaration != null && type != null) {
                    aSTRewrite.replace((ASTNode)singleVariableDeclaration, aSTRewrite.createCopyTarget((ASTNode)type), null);
                    aSTRewrite.replace((ASTNode)type, aSTRewrite.createCopyTarget((ASTNode)singleVariableDeclaration), null);
                }
            }
            ++n3;
        }
        if (!bl2) {
            return;
        }
        if (methodDeclaration.getBody() != null) {
            CompilationUnit compilationUnit = (CompilationUnit)methodDeclaration.getRoot();
            iBindingArray = new ScopeAnalyzer(compilationUnit).getDeclarationsAfter(methodDeclaration.getBody().getStartPosition(), 2);
            int n5 = 0;
            while (n5 < iBindingArray.length) {
                arrayList.add(iBindingArray[n5].getName());
                ++n5;
            }
        }
        this.fixupNames(aSTRewrite, arrayList, methodDeclaration, bl);
    }

    private void fixupNames(ASTRewrite aSTRewrite, ArrayList arrayList, MethodDeclaration methodDeclaration, boolean bl) {
        AST aST = aSTRewrite.getAST();
        int n = 0;
        while (n < this.fParameterChanges.length) {
            ChangeDescription changeDescription = this.fParameterChanges[n];
            if (changeDescription instanceof ModifyDescription) {
                ModifyDescription modifyDescription = (ModifyDescription)changeDescription;
                String string = this.getParamTypeGroupId(n);
                String string2 = this.getParamNameGroupId(n);
                String string3 = null;
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                String string4 = modifyDescription.name;
                if (string4 != null) {
                    string3 = StubUtility.suggestArgumentName(this.getCompilationUnit().getJavaProject(), string4, stringArray);
                    this.addLinkedPositionProposal(string2, string3, null);
                }
                if (modifyDescription instanceof EditDescription) {
                    this.addLinkedPositionProposal(string2, ((EditDescription)modifyDescription).orginalName, null);
                }
                Type type = modifyDescription.resultingParamType;
                String[] stringArray2 = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaProject(), type, stringArray);
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    this.addLinkedPositionProposal(string2, stringArray2[n2], null);
                    ++n2;
                }
                if (string3 == null) {
                    string3 = stringArray2[0];
                }
                arrayList.add(string3);
                SimpleName[] simpleNameArray = modifyDescription.resultingParamName;
                int n3 = 0;
                while (n3 < simpleNameArray.length) {
                    simpleNameArray[n3].setIdentifier(string3);
                    this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleNameArray[n3]), false, string2);
                    ++n3;
                }
                this.addLinkedPosition(aSTRewrite.track((ASTNode)modifyDescription.resultingParamType), true, string);
                ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, modifyDescription.type);
                int n4 = 0;
                while (n4 < iTypeBindingArray.length) {
                    this.addLinkedPositionProposal(string, iTypeBindingArray[n4]);
                    ++n4;
                }
                SimpleName simpleName = modifyDescription.resultingTagArg;
                if (simpleName != null) {
                    simpleName.setIdentifier(string3);
                    this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), false, string2);
                }
            }
            ++n;
        }
    }

    private TagElement findParamTag(MethodDeclaration methodDeclaration, SingleVariableDeclaration singleVariableDeclaration) {
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc != null) {
            return JavadocTagsSubProcessor.findParamTag(javadoc, singleVariableDeclaration.getName().getIdentifier());
        }
        return null;
    }

    private TagElement insertParamTag(ListRewrite listRewrite, List list, int n, TagElement tagElement) {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)list.get(n2);
            hashSet.add(singleVariableDeclaration.getName().getIdentifier());
            ++n2;
        }
        JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, hashSet);
        return tagElement;
    }

    private void modifyExceptions(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) throws CoreException {
        AST aST = methodDeclaration.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        List list = methodDeclaration.thrownExceptions();
        int n = 0;
        int n2 = 0;
        while (n2 < this.fExceptionChanges.length) {
            Name name;
            TagElement tagElement;
            Object object;
            String string;
            Object object2;
            String string2;
            ModifyDescription modifyDescription;
            ChangeDescription changeDescription = this.fExceptionChanges[n2];
            if (changeDescription == null) {
                ++n;
            } else if (changeDescription instanceof InsertDescription) {
                modifyDescription = (InsertDescription)changeDescription;
                string2 = importRewrite.addImport(modifyDescription.type);
                object2 = ASTNodeFactory.newName(aST, string2);
                listRewrite.insertAt((ASTNode)object2, n2, null);
                string = this.getExceptionTypeGroupId(n2);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)object2), false, string);
                object = methodDeclaration.getJavadoc();
                if (object != null) {
                    tagElement = aST.newTagElement();
                    tagElement.setTagName("@throws");
                    name = ASTNodeFactory.newName(aST, string2);
                    tagElement.fragments().add(name);
                    this.insertTabStop(aSTRewrite, tagElement.fragments(), "throws_tagcomment" + n2);
                    this.insertThrowsTag(aSTRewrite.getListRewrite((ASTNode)object, Javadoc.TAGS_PROPERTY), list, n, tagElement);
                    this.addLinkedPosition(aSTRewrite.track((ASTNode)name), false, string);
                }
            } else if (changeDescription instanceof RemoveDescription) {
                modifyDescription = (Name)list.get(n);
                listRewrite.remove((ASTNode)modifyDescription, null);
                ++n;
                string2 = this.findThrowsTag(methodDeclaration, (Name)modifyDescription);
                if (string2 != null) {
                    aSTRewrite.remove((ASTNode)string2, null);
                }
            } else if (changeDescription instanceof EditDescription) {
                modifyDescription = (EditDescription)changeDescription;
                string2 = (Name)list.get(n);
                object2 = importRewrite.addImport(((EditDescription)modifyDescription).type);
                string = ASTNodeFactory.newName(aST, (String)object2);
                listRewrite.replace((ASTNode)string2, (ASTNode)string, null);
                object = this.getExceptionTypeGroupId(n2);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)string), false, (String)object);
                ++n;
                tagElement = this.findThrowsTag(methodDeclaration, (Name)string2);
                if (tagElement != null) {
                    name = ASTNodeFactory.newName(aST, (String)object2);
                    aSTRewrite.replace((ASTNode)tagElement.fragments().get(0), (ASTNode)name, null);
                    this.addLinkedPosition(aSTRewrite.track((ASTNode)name), false, (String)object);
                }
            } else if (changeDescription instanceof SwapDescription) {
                modifyDescription = (Name)list.get(n);
                string2 = (Name)list.get(((SwapDescription)changeDescription).index);
                aSTRewrite.replace((ASTNode)modifyDescription, aSTRewrite.createCopyTarget((ASTNode)string2), null);
                aSTRewrite.replace((ASTNode)string2, aSTRewrite.createCopyTarget((ASTNode)modifyDescription), null);
                ++n;
                object2 = this.findThrowsTag(methodDeclaration, (Name)modifyDescription);
                string = this.findThrowsTag(methodDeclaration, (Name)string2);
                if (object2 != null && string != null) {
                    aSTRewrite.replace((ASTNode)object2, aSTRewrite.createCopyTarget((ASTNode)string), null);
                    aSTRewrite.replace((ASTNode)string, aSTRewrite.createCopyTarget((ASTNode)object2), null);
                }
            }
            ++n2;
        }
    }

    private void insertTabStop(ASTRewrite aSTRewrite, List list, String string) {
        TextElement textElement = aSTRewrite.getAST().newTextElement();
        textElement.setText("");
        list.add(textElement);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)textElement), false, string);
    }

    private TagElement findThrowsTag(MethodDeclaration methodDeclaration, Name name) {
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc != null) {
            String string = ASTNodes.getSimpleNameIdentifier(name);
            return JavadocTagsSubProcessor.findThrowsTag(javadoc, string);
        }
        return null;
    }

    private TagElement insertThrowsTag(ListRewrite listRewrite, List list, int n, TagElement tagElement) {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            Name name = (Name)list.get(n2);
            hashSet.add(ASTNodes.getSimpleNameIdentifier(name));
            ++n2;
        }
        JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, hashSet);
        return tagElement;
    }

    public String getParamNameGroupId(int n) {
        return "param_name_" + n;
    }

    public String getParamTypeGroupId(int n) {
        return "param_type_" + n;
    }

    public String getExceptionTypeGroupId(int n) {
        return "exc_type_" + n;
    }

    public static interface ChangeDescription {
    }

    public static class EditDescription
    extends ModifyDescription {
        String orginalName;

        public EditDescription(ITypeBinding iTypeBinding, String string) {
            super(iTypeBinding, string);
        }
    }

    public static class InsertDescription
    extends ModifyDescription {
        public InsertDescription(ITypeBinding iTypeBinding, String string) {
            super(iTypeBinding, string);
        }
    }

    static class ModifyDescription
    implements ChangeDescription {
        public final String name;
        public final ITypeBinding type;
        Type resultingParamType;
        SimpleName[] resultingParamName;
        SimpleName resultingTagArg;

        private ModifyDescription(ITypeBinding iTypeBinding, String string) {
            this.type = iTypeBinding;
            this.name = string;
        }
    }

    public static class RemoveDescription
    implements ChangeDescription {
    }

    public static class SwapDescription
    implements ChangeDescription {
        final int index;

        public SwapDescription(int n) {
            this.index = n;
        }
    }
}

