/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class JavadocTagsSubProcessor {
    private static String[] TAG_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@see", "@since", "@serial", "@deprecated"};

    public static void getMissingJavadocTagProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        Object object;
        String string;
        ASTNode aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        if (aSTNode == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode = ASTNodes.getNormalizedNode(aSTNode));
        if (bodyDeclaration == null) {
            return;
        }
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor == SingleVariableDeclaration.NAME_PROPERTY) {
            string = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            if (aSTNode.getParent().getLocationInParent() != MethodDeclaration.PARAMETERS_PROPERTY) {
                return;
            }
        } else if (structuralPropertyDescriptor == TypeParameter.NAME_PROPERTY) {
            string = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            object = aSTNode.getParent().getLocationInParent();
            if (object != MethodDeclaration.TYPE_PARAMETERS_PROPERTY && object != TypeDeclaration.TYPE_PARAMETERS_PROPERTY) {
                return;
            }
        } else if (structuralPropertyDescriptor == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
            string = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_returntag_description;
        } else if (structuralPropertyDescriptor == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
            string = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_throwstag_description;
        } else {
            return;
        }
        object = new AddMissingJavadocTagProposal(string, iInvocationContext.getCompilationUnit(), bodyDeclaration, aSTNode, 1);
        collection.add(object);
        String string2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description;
        AddAllMissingJavadocTagsProposal addAllMissingJavadocTagsProposal = new AddAllMissingJavadocTagsProposal(string2, iInvocationContext.getCompilationUnit(), bodyDeclaration, 5);
        collection.add(addAllMissingJavadocTagsProposal);
    }

    public static void getMissingJavadocCommentProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws CoreException {
        ASTNode aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        if (aSTNode == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        ITypeBinding iTypeBinding = Bindings.getBindingOfParentType((ASTNode)bodyDeclaration);
        if (iTypeBinding == null) {
            return;
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            String string;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
            IMethodBinding iMethodBinding2 = null;
            if (iMethodBinding != null) {
                iMethodBinding2 = Bindings.findOverriddenMethod(iMethodBinding, true);
            }
            if ((string = CodeGeneration.getMethodComment(iCompilationUnit, iTypeBinding.getName(), methodDeclaration, iMethodBinding2, String.valueOf('\n'))) != null) {
                String string2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description;
                collection.add(new AddJavadocCommentProposal(string2, iCompilationUnit, 1, bodyDeclaration.getStartPosition(), string));
            }
        } else if (bodyDeclaration instanceof AbstractTypeDeclaration) {
            String[] stringArray;
            Object object;
            String string = Bindings.getTypeQualifiedName(iTypeBinding);
            if (bodyDeclaration instanceof TypeDeclaration) {
                object = ((TypeDeclaration)bodyDeclaration).typeParameters();
                stringArray = new String[object.size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = ((TypeParameter)object.get(n)).getName().getIdentifier();
                    ++n;
                }
            } else {
                stringArray = new String[]{};
            }
            object = CodeGeneration.getTypeComment(iCompilationUnit, string, stringArray, String.valueOf('\n'));
            if (object != null) {
                String string3 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_type_description;
                collection.add(new AddJavadocCommentProposal(string3, iCompilationUnit, 1, bodyDeclaration.getStartPosition(), (String)object));
            }
        } else if (bodyDeclaration instanceof FieldDeclaration) {
            String string;
            String string4 = "/**\n *\n */\n";
            List list = ((FieldDeclaration)bodyDeclaration).fragments();
            if (list != null && list.size() > 0) {
                string = (VariableDeclaration)list.get(0);
                String string5 = string.getName().getIdentifier();
                String string6 = iTypeBinding.getName();
                string4 = CodeGeneration.getFieldComment(iCompilationUnit, string6, string5, String.valueOf('\n'));
            }
            if (string4 != null) {
                string = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_field_description;
                collection.add(new AddJavadocCommentProposal(string, iCompilationUnit, 1, bodyDeclaration.getStartPosition(), string4));
            }
        } else if (bodyDeclaration instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
            String string = enumConstantDeclaration.getName().getIdentifier();
            String string7 = CodeGeneration.getFieldComment(iCompilationUnit, iTypeBinding.getName(), string, String.valueOf('\n'));
            String string8 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_enumconst_description;
            collection.add(new AddJavadocCommentProposal(string8, iCompilationUnit, 1, bodyDeclaration.getStartPosition(), string7));
        }
    }

    public static Set getPreviousTypeParamNames(List list, ASTNode aSTNode) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < list.size()) {
            TypeParameter typeParameter = (TypeParameter)list.get(n);
            if (typeParameter == aSTNode) {
                return hashSet;
            }
            hashSet.add(String.valueOf('<') + typeParameter.getName().getIdentifier() + '>');
            ++n;
        }
        return hashSet;
    }

    private static Set getPreviousParamNames(List list, ASTNode aSTNode) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < list.size()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)list.get(n);
            if (singleVariableDeclaration == aSTNode) {
                return hashSet;
            }
            hashSet.add(singleVariableDeclaration.getName().getIdentifier());
            ++n;
        }
        return hashSet;
    }

    private static Set getPreviousExceptionNames(List list, ASTNode aSTNode) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < list.size() && aSTNode != list.get(n)) {
            Name name = (Name)list.get(n);
            hashSet.add(ASTNodes.getSimpleNameIdentifier(name));
            ++n;
        }
        return hashSet;
    }

    public static TagElement findTag(Javadoc javadoc, String string, String string2) {
        List list = javadoc.tags();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            TagElement tagElement = (TagElement)list.get(n2);
            if (string.equals(tagElement.getTagName())) {
                if (string2 != null) {
                    String string3 = JavadocTagsSubProcessor.getArgument(tagElement);
                    if (string2.equals(string3)) {
                        return tagElement;
                    }
                } else {
                    return tagElement;
                }
            }
            ++n2;
        }
        return null;
    }

    public static TagElement findParamTag(Javadoc javadoc, String string) {
        List list = javadoc.tags();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            TagElement tagElement = (TagElement)list.get(n2);
            String string3 = tagElement.getTagName();
            if ("@param".equals(string3) && string.equals(string2 = JavadocTagsSubProcessor.getArgument(tagElement))) {
                return tagElement;
            }
            ++n2;
        }
        return null;
    }

    public static TagElement findThrowsTag(Javadoc javadoc, String string) {
        List list = javadoc.tags();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            TagElement tagElement = (TagElement)list.get(n2);
            String string3 = tagElement.getTagName();
            if (("@throws".equals(string3) || "@exception".equals(string3)) && string.equals(string2 = JavadocTagsSubProcessor.getArgument(tagElement))) {
                return tagElement;
            }
            ++n2;
        }
        return null;
    }

    public static void insertTag(ListRewrite listRewrite, TagElement tagElement, Set set) {
        JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, set, null);
    }

    public static void insertTag(ListRewrite listRewrite, TagElement tagElement, Set set, TextEditGroup textEditGroup) {
        List list = listRewrite.getRewrittenList();
        String string = tagElement.getTagName();
        TagElement tagElement2 = null;
        int n = JavadocTagsSubProcessor.getTagRanking(string);
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            String string2;
            TagElement tagElement3 = (TagElement)list.get(n2);
            String string3 = tagElement3.getTagName();
            if (string3 == null || n > JavadocTagsSubProcessor.getTagRanking(string3)) {
                tagElement2 = tagElement3;
                break;
            }
            if (set != null && JavadocTagsSubProcessor.isSameTag(string, string3) && (string2 = JavadocTagsSubProcessor.getArgument(tagElement3)) != null && set.contains(string2)) {
                tagElement2 = tagElement3;
                break;
            }
            --n2;
        }
        if (tagElement2 != null) {
            listRewrite.insertAfter((ASTNode)tagElement, tagElement2, textEditGroup);
        } else {
            listRewrite.insertFirst((ASTNode)tagElement, textEditGroup);
        }
    }

    private static boolean isSameTag(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if ("@exception".equals(string2)) {
            return "@throws".equals(string);
        }
        return false;
    }

    private static int getTagRanking(String string) {
        if (string.equals("@exception")) {
            string = "@throws";
        }
        int n = 0;
        while (n < TAG_ORDER.length) {
            if (string.equals(TAG_ORDER[n])) {
                return n;
            }
            ++n;
        }
        return TAG_ORDER.length;
    }

    private static String getArgument(TagElement tagElement) {
        List list = tagElement.fragments();
        if (!list.isEmpty()) {
            Object e = list.get(0);
            if (e instanceof Name) {
                return ASTNodes.getSimpleNameIdentifier((Name)e);
            }
            if (e instanceof TextElement && "@param".equals(tagElement.getTagName())) {
                String string = ((TextElement)e).getText();
                if ("<".equals(string) && list.size() >= 3) {
                    Object e2 = list.get(1);
                    Object e3 = list.get(2);
                    if (e2 instanceof Name && e3 instanceof TextElement && ">".equals(((TextElement)e3).getText())) {
                        return String.valueOf('<') + ASTNodes.getSimpleNameIdentifier((Name)e2) + '>';
                    }
                } else if (string.startsWith(String.valueOf('<')) && string.endsWith(String.valueOf('>')) && string.length() > 2) {
                    return string.substring(1, string.length() - 1);
                }
            }
        }
        return null;
    }

    public static void getRemoveJavadocTagProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        ASTNode aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        while (aSTNode != null && !(aSTNode instanceof TagElement)) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode == null) {
            return;
        }
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aSTNode.getAST());
        aSTRewrite.remove(aSTNode, null);
        String string = CorrectionMessages.JavadocTagsSubProcessor_removetag_description;
        Image image = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        collection.add(new ASTRewriteCorrectionProposal(string, iInvocationContext.getCompilationUnit(), aSTRewrite, 5, image));
    }

    private static final class AddAllMissingJavadocTagsProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;

        public AddAllMissingJavadocTagsProposal(String string, ICompilationUnit iCompilationUnit, BodyDeclaration bodyDeclaration, int n) {
            super(string, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = bodyDeclaration;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)this.fBodyDecl.getAST());
            if (this.fBodyDecl instanceof MethodDeclaration) {
                this.insertAllMissingMethodTags(aSTRewrite, (MethodDeclaration)this.fBodyDecl);
            } else {
                this.insertAllMissingTypeTags(aSTRewrite, (TypeDeclaration)this.fBodyDecl);
            }
            return aSTRewrite;
        }

        private void insertAllMissingMethodTags(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) {
            Type type;
            Object object;
            TagElement tagElement;
            String string;
            Object object2;
            AST aST = methodDeclaration.getAST();
            Javadoc javadoc = methodDeclaration.getJavadoc();
            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            List list = methodDeclaration.typeParameters();
            ArrayList<SingleVariableDeclaration> arrayList = new ArrayList<SingleVariableDeclaration>();
            int n = list.size() - 1;
            while (n >= 0) {
                TypeParameter typeParameter = (TypeParameter)list.get(n);
                object2 = String.valueOf('<') + typeParameter.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", (String)object2) == null) {
                    string = aST.newTagElement();
                    string.setTagName("@param");
                    tagElement = aST.newTextElement();
                    tagElement.setText((String)object2);
                    string.fragments().add(tagElement);
                    this.insertTabStop(aSTRewrite, string.fragments(), "typeParam" + n);
                    JavadocTagsSubProcessor.insertTag(listRewrite, (TagElement)string, JavadocTagsSubProcessor.getPreviousTypeParamNames(list, (ASTNode)typeParameter));
                }
                arrayList.add((SingleVariableDeclaration)object2);
                --n;
            }
            List list2 = methodDeclaration.parameters();
            int n2 = list2.size() - 1;
            while (n2 >= 0) {
                object2 = (SingleVariableDeclaration)list2.get(n2);
                string = object2.getName().getIdentifier();
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", string) == null) {
                    tagElement = aST.newTagElement();
                    tagElement.setTagName("@param");
                    tagElement.fragments().add(aST.newSimpleName(string));
                    this.insertTabStop(aSTRewrite, tagElement.fragments(), "methParam" + n2);
                    object = JavadocTagsSubProcessor.getPreviousParamNames(list2, (ASTNode)object2);
                    object.addAll(arrayList);
                    JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, (Set)object);
                }
                --n2;
            }
            if (!(methodDeclaration.isConstructor() || (type = methodDeclaration.getReturnType2()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessor.findTag(javadoc, "@return", null) != null)) {
                object2 = aST.newTagElement();
                object2.setTagName("@return");
                this.insertTabStop(aSTRewrite, object2.fragments(), "return");
                JavadocTagsSubProcessor.insertTag(listRewrite, (TagElement)object2, null);
            }
            List list3 = methodDeclaration.thrownExceptions();
            int n3 = list3.size() - 1;
            while (n3 >= 0) {
                string = (Name)list3.get(n3);
                tagElement = string.resolveTypeBinding();
                if (tagElement != null && JavadocTagsSubProcessor.findThrowsTag(javadoc, (String)(object = tagElement.getName())) == null) {
                    TagElement tagElement2 = aST.newTagElement();
                    tagElement2.setTagName("@throws");
                    TextElement textElement = aST.newTextElement();
                    textElement.setText(ASTNodes.asString((ASTNode)string));
                    tagElement2.fragments().add(textElement);
                    this.insertTabStop(aSTRewrite, tagElement2.fragments(), "exception" + n3);
                    JavadocTagsSubProcessor.insertTag(listRewrite, tagElement2, JavadocTagsSubProcessor.getPreviousExceptionNames(list3, (ASTNode)string));
                }
                --n3;
            }
        }

        private void insertAllMissingTypeTags(ASTRewrite aSTRewrite, TypeDeclaration typeDeclaration) {
            AST aST = typeDeclaration.getAST();
            Javadoc javadoc = typeDeclaration.getJavadoc();
            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            List list = typeDeclaration.typeParameters();
            int n = list.size() - 1;
            while (n >= 0) {
                TypeParameter typeParameter = (TypeParameter)list.get(n);
                String string = String.valueOf('<') + typeParameter.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", string) == null) {
                    TagElement tagElement = aST.newTagElement();
                    tagElement.setTagName("@param");
                    TextElement textElement = aST.newTextElement();
                    textElement.setText(string);
                    tagElement.fragments().add(textElement);
                    this.insertTabStop(aSTRewrite, tagElement.fragments(), "typeParam" + n);
                    JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, JavadocTagsSubProcessor.getPreviousTypeParamNames(list, (ASTNode)typeParameter));
                }
                --n;
            }
        }

        private void insertTabStop(ASTRewrite aSTRewrite, List list, String string) {
            TextElement textElement = aSTRewrite.getAST().newTextElement();
            textElement.setText("");
            list.add(textElement);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)textElement), false, string);
        }
    }

    private static final class AddJavadocCommentProposal
    extends CUCorrectionProposal {
        private final int fInsertPosition;
        private final String fComment;

        private AddJavadocCommentProposal(String string, ICompilationUnit iCompilationUnit, int n, int n2, String string2) {
            super(string, iCompilationUnit, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fInsertPosition = n2;
            this.fComment = string2;
        }

        protected void addEdits(IDocument iDocument, TextEdit textEdit) throws CoreException {
            try {
                String string = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                IJavaProject iJavaProject = this.getCompilationUnit().getJavaProject();
                IRegion iRegion = iDocument.getLineInformationOfOffset(this.fInsertPosition);
                String string2 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                String string3 = Strings.getIndentString(string2, iJavaProject);
                String string4 = Strings.changeIndent(this.fComment, 0, iJavaProject, string3, string);
                InsertEdit insertEdit = new InsertEdit(this.fInsertPosition, string4);
                textEdit.addChild((TextEdit)insertEdit);
                if (this.fComment.charAt(this.fComment.length() - 1) != '\n') {
                    textEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, string));
                    textEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, string3));
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException(JavaUIStatus.createError(4, badLocationException));
            }
        }
    }

    private static final class AddMissingJavadocTagProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;
        private final ASTNode fMissingNode;

        public AddMissingJavadocTagProposal(String string, ICompilationUnit iCompilationUnit, BodyDeclaration bodyDeclaration, ASTNode aSTNode, int n) {
            super(string, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = bodyDeclaration;
            this.fMissingNode = aSTNode;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            AST aST = this.fBodyDecl.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            this.insertMissingJavadocTag(aSTRewrite, this.fMissingNode, this.fBodyDecl);
            return aSTRewrite;
        }

        private void insertMissingJavadocTag(ASTRewrite aSTRewrite, ASTNode aSTNode, BodyDeclaration bodyDeclaration) {
            TagElement tagElement;
            SingleVariableDeclaration singleVariableDeclaration;
            AST aST = bodyDeclaration.getAST();
            Javadoc javadoc = bodyDeclaration.getJavadoc();
            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
            if (structuralPropertyDescriptor == SingleVariableDeclaration.NAME_PROPERTY) {
                singleVariableDeclaration = (SingleVariableDeclaration)aSTNode.getParent();
                String string = ((SimpleName)aSTNode).getIdentifier();
                tagElement = aST.newTagElement();
                tagElement.setTagName("@param");
                List list = tagElement.fragments();
                list.add(aST.newSimpleName(string));
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                List list2 = methodDeclaration.parameters();
                Set set = JavadocTagsSubProcessor.getPreviousParamNames(list2, (ASTNode)singleVariableDeclaration);
                List list3 = methodDeclaration.typeParameters();
                int n = 0;
                while (n < list3.size()) {
                    String string2 = String.valueOf('<') + ((TypeParameter)list3.get(n)).getName().getIdentifier() + '>';
                    set.add(string2);
                    ++n;
                }
                JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, set);
            } else if (structuralPropertyDescriptor == TypeParameter.NAME_PROPERTY) {
                singleVariableDeclaration = (TypeParameter)aSTNode.getParent();
                String string = String.valueOf('<') + ((SimpleName)aSTNode).getIdentifier() + '>';
                tagElement = aST.newTagElement();
                tagElement.setTagName("@param");
                TextElement textElement = aST.newTextElement();
                textElement.setText(string);
                tagElement.fragments().add(textElement);
                List list = bodyDeclaration instanceof TypeDeclaration ? ((TypeDeclaration)bodyDeclaration).typeParameters() : ((MethodDeclaration)bodyDeclaration).typeParameters();
                JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, JavadocTagsSubProcessor.getPreviousTypeParamNames(list, (ASTNode)singleVariableDeclaration));
            } else if (structuralPropertyDescriptor == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
                tagElement = aST.newTagElement();
                tagElement.setTagName("@return");
                JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, null);
            } else if (structuralPropertyDescriptor == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                tagElement = aST.newTagElement();
                tagElement.setTagName("@throws");
                singleVariableDeclaration = aST.newTextElement();
                singleVariableDeclaration.setText(ASTNodes.asString(aSTNode));
                tagElement.fragments().add(singleVariableDeclaration);
                List list = ((MethodDeclaration)bodyDeclaration).thrownExceptions();
                JavadocTagsSubProcessor.insertTag(listRewrite, tagElement, JavadocTagsSubProcessor.getPreviousExceptionNames(list, aSTNode));
            } else {
                Assert.isTrue((boolean)false, (String)"AddMissingJavadocTagProposal: unexpected node location");
                return;
            }
            singleVariableDeclaration = aST.newTextElement();
            singleVariableDeclaration.setText("");
            tagElement.fragments().add(singleVariableDeclaration);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration), false, "comment_start");
        }
    }
}

