/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.SurroundWithTemplateProposal;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor;

public class QuickTemplateProcessor
implements IQuickAssistProcessor {
    private static final String $_LINE_SELECTION = "${line_selection}";

    public boolean hasAssists(IInvocationContext iInvocationContext) throws CoreException {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        IDocument iDocument = this.getDocument(iCompilationUnit);
        int n = iInvocationContext.getSelectionOffset();
        int n2 = iInvocationContext.getSelectionLength();
        if (n2 == 0) {
            return false;
        }
        try {
            int n3 = iDocument.getLineOfOffset(n);
            int n4 = iDocument.getLineOfOffset(n + n2);
            IRegion iRegion = iDocument.getLineInformation(n4);
            return n3 < n4 || n2 > 0 && n == iRegion.getOffset() && n2 == iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IJavaCompletionProposal[] getAssists(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (iProblemLocationArray != null && iProblemLocationArray.length > 0) {
            return new IJavaCompletionProposal[0];
        }
        try {
            Object object;
            int n = iInvocationContext.getSelectionOffset();
            int n2 = iInvocationContext.getSelectionLength();
            if (n2 == 0) {
                return null;
            }
            ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
            IDocument iDocument = this.getDocument(iCompilationUnit);
            int n3 = iDocument.getLineOfOffset(n);
            int n4 = iDocument.getLineOfOffset(n + n2);
            IRegion iRegion = iDocument.getLineInformation(n4);
            if (n4 > n3 && iRegion.getOffset() == n + n2) {
                iRegion = iDocument.getLineInformation(--n4);
                n2 = iRegion.getOffset() + iRegion.getLength() - n;
            }
            if (n3 == n4) {
                if (!(n2 != 0 && n == iRegion.getOffset() && n2 == iRegion.getLength() || SurroundWith.isApplicable((IInvocationContext)(object = new AssistContext(iCompilationUnit, n, n2))))) {
                    return null;
                }
            } else {
                n = iDocument.getLineOffset(n3);
                n2 = iRegion.getOffset() + iRegion.getLength() - n;
            }
            object = new ArrayList();
            this.collectSurroundTemplates(iDocument, iCompilationUnit, n, n2, (Collection)object);
            this.sort((ArrayList)object);
            return ((ArrayList)object).toArray(new IJavaCompletionProposal[((ArrayList)object).size()]);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(JavaUIStatus.createError(4, "", badLocationException));
        }
    }

    private void sort(ArrayList arrayList) {
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                IJavaCompletionProposal iJavaCompletionProposal = (IJavaCompletionProposal)object;
                IJavaCompletionProposal iJavaCompletionProposal2 = (IJavaCompletionProposal)object2;
                return Collator.getInstance().compare(iJavaCompletionProposal.getDisplayString(), iJavaCompletionProposal2.getDisplayString());
            }
        });
    }

    private IDocument getDocument(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IFile iFile = (IFile)iCompilationUnit.getResource();
        IDocument iDocument = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(iFile));
        if (iDocument == null) {
            return new Document(iCompilationUnit.getSource());
        }
        return iDocument;
    }

    private void collectSurroundTemplates(IDocument iDocument, ICompilationUnit iCompilationUnit, int n, int n2, Collection collection) throws BadLocationException, CoreException {
        CompilationUnitContextType compilationUnitContextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        CompilationUnitContext compilationUnitContext = compilationUnitContextType.createContext(iDocument, n, n2, iCompilationUnit);
        compilationUnitContext.setVariable("selection", iDocument.get(n, n2));
        compilationUnitContext.setForceEvaluation(true);
        int n3 = compilationUnitContext.getStart();
        int n4 = compilationUnitContext.getEnd();
        Region region = new Region(n3, n4 - n3);
        AssistContext assistContext = new AssistContext(iCompilationUnit, n3, n4 - n3);
        Statement[] statementArray = SurroundWith.getSelectedStatements(assistContext);
        Template[] templateArray = JavaPlugin.getDefault().getTemplateStore().getTemplates();
        int n5 = 0;
        while (n5 != templateArray.length) {
            Template template = templateArray[n5];
            if (compilationUnitContext.canEvaluate(template) && template.getContextTypeId().equals("javaScript") && template.getPattern().indexOf($_LINE_SELECTION) != -1) {
                Object[] objectArray;
                Object object;
                if (statementArray != null) {
                    object = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                    objectArray = new SurroundWithTemplateProposal(iCompilationUnit, template, compilationUnitContext, (IRegion)region, (Image)object, statementArray);
                    Object[] objectArray2 = new String[]{template.getName(), template.getDescription()};
                    objectArray.setDisplayString(Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, objectArray2));
                    collection.add(objectArray);
                } else {
                    object = new TemplateProposal(template, (TemplateContext)compilationUnitContext, (IRegion)region, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.template_obj.gif")){

                        public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
                            return false;
                        }
                    };
                    objectArray = new String[]{template.getName(), template.getDescription()};
                    ((TemplateProposal)object).setDisplayString(Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, objectArray));
                    collection.add(object);
                }
            }
            ++n5;
        }
    }
}

